
AC_DEFUN(LAC_INIT,
[

AC_PREREQ(2.12)

dnl Set up relative postion within the configuration tree

topsrcdir="${srcdir}/lac_base_path"
builddir=.
topbuilddir="lac_base_path"
configurationdir="${srcdir}/lac_config_path"
AC_SUBST(topsrcdir)
AC_SUBST(topbuilddir)
AC_SUBST(configurationdir)

globus_cv_system_type=unknown
globus_cv_threads_type=unknown


if test -r ${topbuilddir}/globus-install
then
   message="Globus cannot configure in its own source directory!  "
   message="${message}Make a temporary working directory and "
   message="${message}rerun configure in that directory.  Example: "
   message="${message}'(mkdir ./build && cd ./build && ../configure ...)'"
   AC_MSG_ERROR("${message}")
fi


dnl Set up the Globus revision numbers and stuff

# The following variables are updated by CVS.  
cvsHeader='$Header: /home/globdev/CVS/globus-current/Globus/Configuration/acmisc.m4,v 1.145 2001/03/01 16:06:16 bester Exp $'
cvsDate='$Date: 2001/03/01 16:06:16 $'
cvsRevision='$Revision: 1.145 $'
cvsName='$Name:  $'

dnl Tags must be formed in the following way
dnl globus_<major>_<minor>_<patch>[_b<beta>]





GLOBUS_TAG=`cat ${topsrcdir}/VERSION`

GLOBUS_RELEASE="$GLOBUS_TAG"
GLOBUS_NUMBER="`echo $GLOBUS_TAG | sed 's/globus_//'`"
GLOBUS_RELEASE_MAJOR="`echo $GLOBUS_NUMBER | awk -F_ '{print [$]1}'`"
GLOBUS_RELEASE_MINOR="`echo $GLOBUS_NUMBER | awk -F_ '{print [$]2}'`"

GLOBUS_PATCH_BETA="`echo $GLOBUS_NUMBER | awk -F_ '{print [$]3}'`"
GLOBUS_RELEASE_PATCH="`echo $GLOBUS_PATCH_BETA | awk -Fb '{print [$]1}'`"
GLOBUS_RELEASE_BETA="` echo $GLOBUS_PATCH_BETA | awk -Fb '{print [$]2}'`"

if test -z "$GLOBUS_RELEASE_BETA"  ; then
   GLOBUS_RELEASE_BETA="0xFFFFFFFF"
fi

GLOBUS_RELEASE_DATE=`echo $cvsDate |  sed -e 's|Date: *||' -e 's|\\$||g'`
GLOBUS_RELEASE_NOTES=


dnl AC_SUBST(GLOBUS_VERSION)
AC_SUBST(GLOBUS_RELEASE)
AC_SUBST(GLOBUS_RELEASE_MAJOR)
AC_SUBST(GLOBUS_RELEASE_MINOR)
AC_SUBST(GLOBUS_RELEASE_PATCH)
AC_SUBST(GLOBUS_RELEASE_BETA)
AC_SUBST(GLOBUS_RELEASE_DATE)
AC_SUBST(GLOBUS_RELEASE_NOTES)




AC_CONFIG_AUX_DIR(lac_config_path)

dnl The following two lines are stolen from AC_OUTPUT().
dnl We needed to hoist the setting of prefix and exec_prefix
dnl so that could get real values for things like bindir.
test "x$prefix" = xNONE && prefix=$ac_default_prefix
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'

dnl includedir needs to be architecture dependent, so rewrite it here
dnl to be relative to exec_prefix instead of prefix
if test "x${includedir}" = 'x${prefix}/include' ; then
    includedir='${exec_prefix}/include'
fi

AC_ARG_WITH(tmpdir,
        [  --with-tmpdir=DIR             temporary files in DIR [PREFIX/tmp]],
        [tmpdir="$withval"],
        [tmpdir='${prefix}/tmp'])
AC_SUBST(tmpdir)


AC_ARG_WITH(local_tmpdir,
        [  --with-local-tmpdir=LDIR      local temporary files in LDIR [/tmp]],
        [local_tmpdir="$withval"],
        [local_tmpdir='/tmp'])
AC_SUBST(local_tmpdir)

AC_ARG_WITH(docdir,
        [  --with-docdir=LDIR            documentation in DIR [datadir/doc]],
        [docdir="$withval"],
        [docdir='${datadir}/doc'])
AC_SUBST(docdir)

AC_ARG_WITH(internal-docdir,
        [  --with-internal-docdir=LDIR   internal documentation in DIR [datadir/internal-doc]],
        [internal_docdir="$withval"],
        [internal_docdir='${datadir}/internal-doc'])
AC_SUBST(internal_docdir)
dnl The following directory is used to specify a local temporary file
dnl system.  It prefered to be a local file system for security needs.
AC_ARG_WITH(secure_tmpdir,
        [  --with-secure-tmpdir=SECDIR   local temporary files in SECDIR [LDIR]],
        [secure_tmpdir="$withval"],
        [secure_tmpdir='${local_tmpdir}'])
AC_SUBST(secure_tmpdir)

dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl dnl 


AC_ARG_WITH(globus-prefix,
	[  --with-globus-prefix=DIR      top directory of globus installation],
	[globus_prefix="$withval"],
	[globus_prefix="$prefix"])
AC_SUBST(globus_prefix)

AC_ARG_WITH(globus-services-prefix,
	[  --with-globus-services-prefix=DIR  directory for architecture-specific globus services],
	[globus_services_prefix="$withval"],
	[globus_services_prefix=""])
AC_SUBST(globus_services_prefix)

AC_ARG_WITH(globus-tools-prefix,
	[  --with-globus-tools-prefix=DIR     directory for architecture-specific globus tools],
	[globus_tools_prefix="$withval"],
	[globus_tools_prefix=""])
AC_SUBST(globus_tools_prefix)


AC_ARG_WITH(deploy-prefix,
        [  --with-deploy-prefix=DIR      root uid files in DIR [EPREFIX]],
        [deploy_prefix="$withval"],
        [deploy_prefix='${prefix}'])
AC_SUBST(deploy_prefix)


AC_ARG_WITH(globus-uid,
       [  --with-globus-uid=              user id of globus system tasks],
       [globus_uid="$withval"],
       [globus_uid=""])

AC_SUBST(globus_uid)

AC_ARG_WITH(globus-gid,
       [  --with-globus-gid=              group id of globus system tasks],
       [globus_gid="$withval"],
       [globus_gid=""])

AC_SUBST(globus_gid)


AC_ARG_ENABLE(new-mpich-makefile,
        [  --enable-new-mpich-makefile    compatiblity with post-MPICH 1.1.2],
        [lac_cv_new_mpich="$enableval"],
        [lac_cv_new_mpich="no"])

dnl 
dnl for the installed exec_prefix, replace ${globus_prefix} or ${prefix}
dnl (in that order) with non-evaluated '${GLOBUS_INSTALL_PATH}'
dnl
installed_exec_prefix="`echo ${exec_prefix} | sed \
    -e 's%^'${globus_prefix}'%${GLOBUS_INSTALL_PATH}%' \
    -e 's%^\${prefix}%${GLOBUS_INSTALL_PATH}%' \
    -e 's%^'${prefix}'%${GLOBUS_INSTALL_PATH}%'`"
AC_SUBST(installed_exec_prefix)

AC_CANONICAL_HOST
AC_CANONICAL_TARGET

arch_sysconfdir="${globus_prefix}/etc/${target}"
AC_SUBST(arch_sysconfdir)

dnl 
dnl for the installed arch_sysconfdir, replace ${prefix} or ${globus_prefix} 
dnl with non-evaluated '${GLOBUS_INSTALL_PATH}'
dnl
installed_arch_sysconfdir="`echo ${arch_sysconfdir} | sed \
    -e 's%^'${globus_prefix}'%${GLOBUS_INSTALL_PATH}%' \
    -e 's%^${prefix}%${GLOBUS_INSTALL_PATH}%' \
    -e 's%^'${prefix}'%${GLOBUS_INSTALL_PATH}%'`"
AC_SUBST(installed_arch_sysconfdir)

dnl
dnl Provide the fully resolved directory locations
dnl  eval_prefix == eval ${prefix}
dnl
for i in prefix exec_prefix bindir sbindir sysconfdir includedir docdir \
         internal_docdir libdir localstatedir libexecdir datadir tmpdir \
	 local_tmpdir secure_tmpdir arch_sysconfdir
do
  eval id="eval_$i"

  dnl initialize the value
  eval eval "$id=\${$i}"

  dnl re-eval to ensure all substitutions have been performed
  eval eval "$id=\${$id}"

  dnl  The following line does not work
  dnl   I need it to eval the $id first
  dnl  AC_SUBST(`echo $id`)
done

dnl These can be removed after problem from above
dnl is resolved
AC_SUBST(eval_prefix)
AC_SUBST(eval_exec_prefix)
AC_SUBST(eval_bindir)
AC_SUBST(eval_sbindir)
AC_SUBST(eval_sysconfdir)
AC_SUBST(eval_includedir)
AC_SUBST(eval_libdir)
AC_SUBST(eval_localstatedir)
AC_SUBST(eval_libexecdir)
AC_SUBST(eval_datadir)
AC_SUBST(eval_tmpdir)
AC_SUBST(eval_local_tmpdir)
AC_SUBST(eval_secure_tmpdir)
AC_SUBST(eval_arch_sysconfdir)
AC_SUBST(eval_docdir)
dnl End


AC_PROG_AWK

dnl Provide the option to set the domain name on the configure line
AC_ARG_WITH(domain_name,
        [  --with-domain-name=DOMAIN     only used if the FQN is unknown],
        [domain_name="$withval"],
        [domain_name="no"])


dnl Try to determine the FQN of the local host
dnl Some "hostname"s do not return the FQN

AC_PATH_PROG(GLOBUS_SH_HOSTNAME, hostname)     dnl This may be reset.

  _local_host="`$GLOBUS_SH_HOSTNAME`"

  dnl  Check to see if the `hostname` command returned a FQName
  _domain=`echo $_local_host | cut -d. -f2-`
      dnl If there are no dots (.), cut will return the original string

  if test -n "$_domain" -a $_local_host != $_domain  ; then
    dnl _local_host is fully qualified
    if test "X$domain_name" != "Xno" ; then
       AC_MSG_WARN(Ignoring the value of --with-domain-name)
    fi
    domain_name=$_domain
  fi


  dnl Try to determine the FQN
  if test -z "$_domain" -o $_local_host = $_domain  ; then
     dnl the local_host name IS NOT fully qualified.

     if test "X$domain_name" = "Xno" ; then
        dnl try to determine what the domain name is

        domain_name=""

        dnl Check the enviroment variable
        if test -n "${LOCALDOMAIN}"  ; then
           domain_name=${LOCALDOMAIN}
        fi

        if test -z "$domain_name" -a -f /etc/resolv.conf  ; then
             domain_name=`$AWK '/domain/ { print [$]2 ; exit }' \
                          /etc/resolv.conf`
        fi

        if test -z "$domain_name" ; then
           message="Cannot determine the FQN for the current domain"
           message="$message \nRerun configure with the"
           message="$message \"--with-domain-name\" option"
           AC_MSG_ERROR($message)
        fi
     fi
    
     first_char=`echo ${domain_name} | cut -c 1`
     if test $first_char = '.' ; then
         dnl Using the Nexus convention
         domain_name=`echo ${domain_name} | cut -c 2-`
     fi
     _local_host=`echo ${_local_host}.${domain_name}`

    dnl reset host name to always give the domain_name


    HOSTNAME='${bindir}/globus-hostname'
  else
    dnl the local_host name IS fully qualified.
    HOSTNAME="$GLOBUS_SH_HOSTNAME"
  fi

  AC_SUBST(HOSTNAME)

  LOCAL_HOST=$_local_host
  AC_SUBST(LOCAL_HOST)

  LOCALDOMAIN=$domain_name
  AC_SUBST(LOCALDOMAIN)

dnl end 


AC_CANONICAL_HOST
AC_CANONICAL_TARGET
service=$target
echo "checking service system type... $service"

LAC_TARGET_ARCH

AC_PROG_LN_S

dnl AC_PROG_INSTALL seems to be broken on several machines
dnl 
dnl 1. The found install program on the quad.mcs.anl.gov
dnl    (/usr/bin/installbsd) is broken.  
dnl 2. The propagation of INSTALL does not work correctly
dnl     on the SP2 at UMich or at ASC (Wright Paterson)
dnl
dnl Solution:
dnl    Always force the use of our install-sh
dnl

INSTALL="$ac_install_sh"
INSTALL_PROGRAM='${INSTALL}'
INSTALL_DATA='${INSTALL} -m 644'
AC_SUBST(INSTALL)
AC_SUBST(INSTALL_PROGRAM)
AC_SUBST(INSTALL_DATA)

AC_PATH_PROGS(MAKE, make gmake)
AC_PROG_MAKE_SET

dnl
dnl Programs defined in makefile_header
dnl

AC_PATH_PROG(RM, rm)
AC_PATH_PROG(ECHO, echo)
AC_PATH_PROG(MKDIR, mkdir)
AC_PATH_PROG(CP, cp)
AC_PATH_PROG(CAT, cat)
AC_PATH_PROG(DATE, date)
AC_PATH_PROG(SED, sed)
AC_PATH_PROG(GREP, grep)
AC_PATH_PROG(NM, nm)
AC_PATH_PROG(TOUCH, touch)
AC_PATH_PROG(TRUE, true)

AC_PATH_PROGS(SH, sh bsh, /bin/sh, /bin:/usr/bin:${PATH})
AC_PATH_PROG(TMPKSH, ksh)
AC_PATH_PROG(TMPBASH, bash)

dnl IRIX 6.3 and below the SH is broken 
dnl   so change SH to KSH
dnl BSD sh is broken so use bash
dnl CygWin32 ash is broken so force the use of bash
dnl OSF1 sh is broken, use /usr/bin/posix/sh
dnl   if it exists
case "$target" in
    mips-sgi-irix* )
	SH=${TMPKSH}
	;;
    *bsd* )
        if test -n ${TMPBASH};  then
	    SH=${TMPBASH}
	fi
	;;
    i*86-*-cygwin* )
        if test -n ${TMPBASH};  then
           SH=${TMPBASH}
	fi
	;;
    *dec* )
        if test -x /usr/bin/posix/sh; then
	   SH=/usr/bin/posix/sh
	fi
	;;
esac

AC_SUBST(SH)

dnl bash in CygWin32 has a broken exec command, so just execute
dnl the command (at present, this is only used for command-echo)
case "$target" in
    i*86-*-cygwin* )
	SH_EXEC=""
	;;
    * )
	SH_EXEC="exec"
	;;
esac
AC_SUBST(SH_EXEC)


OFILE="o"
AC_SUBST(OFILE)

case "$target" in
    i*86-*-cygwin* )
        EXECFILE=".exe"
	;;
    * )
        EXECFILE=""
	;;
esac
AC_SUBST(EXECFILE)

dnl removed to various problems on HPUX and Paragon
dnl configurationfiles=""
dnl for i in lac_config_files; do
dnl    configurationfiles="$configurationfiles ${srcdir}/$i"
dnl done
dnl AC_SUBST(configurationfiles)

dnl get/set GSSAPI/SSL config values
dnl these values are substituted into makefile_header
LAC_GSSAPI_ARGS
LAC_SSL_ARGS

dnl set the path stuff for OpenLDAP
LAC_LDAP

dnl
dnl GLOBUS_*_PATH substitutions
dnl
globus_script_initializer=${topbuilddir}/Configuration/script_includes/globus-script-initializer
AC_SUBST_FILE(globus_script_initializer)

if test "${lac_cv_build_64bit}" = "yes" ; then
    globus_ssl_path_sh="globus-ssl-path-64.sh"
    globus_ldap_path_sh="globus-ldap-path-64.sh"
else
    globus_ssl_path_sh="globus-ssl-path-32.sh"
    globus_ldap_path_sh="globus-ldap-path-32.sh"
fi
AC_SUBST(globus_ssl_path_sh)
AC_SUBST(globus_ldap_path_sh)

dnl
dnl Globus script parsing header
dnl
globus_args_parser_header=${topbuilddir}/Configuration/script_includes/globus-args-parser-header
AC_SUBST_FILE(globus_args_parser_header)

dnl
dnl set Nexus protocol configuration symbols
dnl
dnl LAC_GLOBUS_NEXUS_PROTO_XTP

makefile_default_rules=$srcdir/lac_config_path/makefile.default.rules
AC_SUBST_FILE(makefile_default_rules)

makefile_common_vars=$srcdir/lac_config_path/makefile.common.vars
AC_SUBST_FILE(makefile_common_vars)

makefile_common_rules=$srcdir/lac_config_path/makefile.common.rules
AC_SUBST_FILE(makefile_common_rules)

dnl this defines the makefile_link file subsitution
LAC_SHARED_LIB

])



dnl Fix up definintion of PROG_LEX so that it can find
dnl lex library.
AC_DEFUN(LAC_PROG_LEX,
[AC_PROVIDE([AC_PROG_LEX])
AC_CHECK_PROG(LEX, flex, flex, lex)
dnl Get full path to Lex that we are using
AC_PATH_PROG(ac_lex_path, $LEX)
ac_lex_path=`echo $ac_lex_path | sed s/$LEX//`
if test -z "$LEXLIB"
then
  case "$LEX" in
  flex*) ac_lib=fl ;;
  *) ac_lib=l 
         case "$target" in
	    *solaris2*) LEX_CXXFLAGS="-D__EXTERN_C__" ;;
	 esac
  ;;
  esac
  dnl Try to figure out correct path to lex library
  for ac_extension in a so sl; do
    for ac_dir in \
        /usr/local/lib \
        /usr/local/gnu/lib \
        /usr/gnu/lib \
        $ac_lex_path \
        $ac_lex_path/lib \
	`echo $ac_lex_path | sed s/bin/lib/` \
        ; \
    do 
      if test -r "$ac_dir/lib${ac_lib}.$ac_extension"; then
        ac_lex_lib=$ac_dir
        break
      fi
    done
  done
  AC_CHECK_LIB($ac_lib, yywrap, LEXLIB="-l$ac_lib")
fi
if test -n "$ac_lex_lib"; then 
   LEXLIB="-L$ac_lex_lib $LEXLIB"
fi
AC_SUBST(LEXLIB)
AC_SUBST(LEX_CXXFLAGS)
AC_SUBST(LEXDEFS)])

dnl Search for a library in a list of possible locations.  
dnl lex library.
AC_DEFUN(LAC_FIND_AND_CHECK_LIB,
[ac_link_save=$ac_link
 for ac_extension in a so sl; do
    for ac_dir in $3; do
      if test -r "$ac_dir/lib${ac_lib}.$ac_extension"; then
        ac_lib_dir=$ac_dir
        ac_link="$ac_link -L$ac_lib_dir"   
        break
      fi
    done
  done
  AC_CHECK_LIB($1, $2, [lac_lib_found=yes],[lac_lib_found=no]) 
  LIBS="-l$$1 $LIBS"
  if test ac_lib_found=yes -a -n "$ac_lib_dir"; then
      LIBS=-L$ac_lib_dir
 fi
])

dnl Same as AC version, but saves result of egrep in file conftest.out
dnl Because this macro is used by AC_PROG_GCC_TRADITIONAL, which must
dnl come early, it is not included in AC_BEFORE checks.
dnl LAC_EGREP_CPP(PATTERN, PROGRAM, ACTION-IF-FOUND [,
dnl              ACTION-IF-NOT-FOUND])
AC_DEFUN(LAC_EGREP_CPP_RESULT,
[AC_REQUIRE_CPP()dnl
cat > conftest.$ac_ext <<EOF
[#]line __oline__ "configure"
#include "confdefs.h"
[$2]
EOF
dnl eval is necessary to expand ac_cpp.
dnl Ultrix and Pyramid sh refuse to redirect output of eval, so use subshell.
if (eval "$ac_cpp conftest.$ac_ext") 2>&AC_FD_CC |
  egrep "$1" >conftest.out 2>&1; then
  ifelse([$3], , :, [$3
 rm -rf conftest*])
ifelse([$4], , , [else
  rm -rf conftest*
  $4
])dnl
fi
rm -f conftest*
])

dnl Use list of makefiles to include a common makefile_header
dnl into each makefile.
AC_DEFUN(LAC_MAKEFILES,
[define(lac_makefile_header,$1)dnl
 lac_makefiles=`echo '$2' | sed 's/\n/ /g'`
 lac_makefile_headers="`echo '$2' | sed 's|Makefile|makefile_header:lac_config_path/$1.in |g'`"
])


dnl Insert a standard header into a makefile.  The tricky
dnl bit is we have to run variable substitutions over the
dnl header before we insert it.  We also need to get
dnl reletive directories correct. 
AC_DEFUN(LAC_INSERT_MAKEFILE_HEADERS,[
lac_headers=`echo $lac_makefiles | sed 's/Makefile/lac_makefile_header/g'`
 while test -n "$lac_makefiles"; do
   set $lac_headers; lac_header=[$]1; shift; lac_headers=[$]*
   set $lac_makefiles; lac_makefile=[$]1; shift; lac_makefiles=[$]*
   sed "/@lac_makefile_header@/r $lac_header
        s/@lac_makefile_header@//g" $lac_makefile > conf.tmp
   mv conf.tmp $lac_makefile
 done
])

dnl LAC_PATH_PROG(VARIABLE, PROG-TO-CHECK-FOR [, VALUE-IF-NOT-FOUND [, PATH]])
dnl This is just like AC_PATH_PROG, except that a fully qualified path
dnl will simply be returned.
AC_DEFUN(LAC_PATH_PROG,
[
case $2 in
    /* )
        $1=$2
    ;;
    * )
        AC_PATH_PROG($1, $2, $3, $4)
    ;;
esac
])


dnl
dnl Set TARGET_ARCH_*
dnl
AC_DEFUN(LAC_TARGET_ARCH,
[
case "$target" in
  *sunos4* | *solaris1* )
    AC_DEFINE(TARGET_ARCH_SUNOS41)
  ;;
  *sunos5* | *solaris2* )
    AC_DEFINE(TARGET_ARCH_SOLARIS)
  ;;
  *-ibm-aix3* )
    AC_DEFINE(TARGET_ARCH_AIX)
    AC_DEFINE(TARGET_ARCH_AIX3)
  ;;
  *-ibm-aix4* )
    AC_DEFINE(TARGET_ARCH_AIX)
    AC_DEFINE(TARGET_ARCH_AIX4)
  ;;
  *-*-hpux11*)
    AC_DEFINE(TARGET_ARCH_HPUX)
    AC_DEFINE(TARGET_ARCH_HPUX11)
  ;;
  *-*-hpux* )
    AC_DEFINE(TARGET_ARCH_HPUX)
  ;;
  i860-intel-osf* )
    AC_DEFINE(TARGET_ARCH_PARAGON)
  ;;
  mips-sgi-irix5* )
    AC_DEFINE(TARGET_ARCH_SGI)
    AC_DEFINE(TARGET_ARCH_IRIX)
    AC_DEFINE(TARGET_ARCH_IRIX5)
  ;;
  mips-sgi-irix6* )
    AC_DEFINE(TARGET_ARCH_SGI)
    AC_DEFINE(TARGET_ARCH_IRIX)
    AC_DEFINE(TARGET_ARCH_IRIX6)
  ;;
  *dec* )
    AC_DEFINE(TARGET_ARCH_AXP)
    AC_DEFINE(TARGET_ARCH_OSF1)
    dnl --- more stuff to go here.. need to check with John
  ;;
  *c90* )
    AC_DEFINE(TARGET_ARCH_CRAYC90)
  ;;
  alpha*-cray-unicosmk* )
    AC_DEFINE(TARGET_ARCH_CRAYT3E)
  ;;
  *SV1* )
    AC_DEFINE(TARGET_ARCH_CRAYSV1)
  ;;
  i*86-*-linux* )
    AC_DEFINE(TARGET_ARCH_LINUX)
    AC_DEFINE(TARGET_ARCH_X86)
  ;;
  alpha-*-linux* )
    AC_DEFINE(TARGET_ARCH_LINUX)
    AC_DEFINE(TARGET_ARCH_AXP)
  ;;
  *freebsd* )
    AC_DEFINE(TARGET_ARCH_FREEBSD)
    AC_DEFINE(TARGET_ARCH_BSD)
  ;;
  *bsdi* )
    AC_DEFINE(TARGET_ARCH_BSDI)
    AC_DEFINE(TARGET_ARCH_BSD)
  ;;
  *nextstep* )
    AC_DEFINE(TARGET_ARCH_NEXTSTEP)
  ;;
  i*86-*-cygwin* )
    AC_DEFINE(TARGET_ARCH_CYGWIN)
    AC_DEFINE(TARGET_ARCH_X86)
  ;;
  sparc64-pc-linux-gnu )
    AC_DEFINE(TARGET_ARCH_LINUX)
  ;;
  * )
	echo "platform not configured with TARGET_ARCH_*"
  ;;
esac
])



dnl
dnl Like AC_CHECK_SIZEOF, but allows extra headers to be included 
dnl before the check
dnl
AC_DEFUN(LAC_CHECK_SIZEOF,
[changequote(<<, >>)dnl
dnl The name to #define.
define(<<AC_TYPE_NAME>>, translit(sizeof_$1, [a-z *], [A-Z_P]))dnl
dnl The cache variable name.
define(<<AC_CV_NAME>>, translit(ac_cv_sizeof_$1, [ *], [_p]))dnl
changequote([, ])dnl
AC_MSG_CHECKING(size of $1)
AC_CACHE_VAL(AC_CV_NAME,
[AC_TRY_RUN([$3

#include <stdio.h>

main()
{
  FILE *f=fopen("conftestval", "w");
  if (!f) exit(1);
  fprintf(f, "%d\n", sizeof($1));
  exit(0);
}], AC_CV_NAME=`cat conftestval`, AC_CV_NAME=0, ifelse([$2], , , AC_CV_NAME=$2))])dnl
AC_MSG_RESULT($AC_CV_NAME)
AC_DEFINE_UNQUOTED(AC_TYPE_NAME, $AC_CV_NAME)
undefine([AC_TYPE_NAME])dnl
undefine([AC_CV_NAME])dnl
])





