dnl Configuration file for the Heartbeat Monitor

AC_DEFUN(LAC_HBM_ARGS,
[

AC_CACHE_CHECK(HBM Data Collector host, hbm_cv_dc_host, [dnl
AC_ARG_WITH(hbm-dc-host,
	[  --with-hbm-dc-host=value      name or IP number of the host with the default HBM Data Collector [hbm.globus.org]],
	[hbm_cv_dc_host="$withval"],
	[hbm_cv_dc_host="hbm.globus.org"])
])

AC_CACHE_CHECK(HBM Data Collector command port, hbm_cv_dc_cmdport, [dnl
AC_ARG_WITH(hbm-dc-cmdport,
	[  --with-hbm-dc-cmdport=value   command (and status request) port number for default HBM Data Collector [8337]],
	[hbm_cv_dc_cmdport="$withval"],
	[hbm_cv_dc_cmdport="8337"])
])

AC_CACHE_CHECK(HBM Data Collector heartbeat port, hbm_cv_dc_hbport, [dnl
AC_ARG_WITH(hbm-dc-hbport,
	[  --with-hbm-dc-hbport=value    heartbeat port number for default HBM Data Collector [12003]],
	[hbm_cv_dc_hbport="$withval"],
	[hbm_cv_dc_hbport="12003"])
])

AC_CACHE_CHECK(HBM Data Collector evaluation and checkpoint interval, hbm_cv_dc_eval_interval, [dnl
AC_ARG_WITH(hbm-dc-eval-interval,
	[  --with-hbm-dc-eval-interval=value  interval (secs) at which HBM Data Collector evaluates clients and writes checkpoints to stable storage[10 seconds]],
	[hbm_cv_dc_eval_interval="$withval"],
	[hbm_cv_dc_eval_interval="10"])
])

AC_CACHE_CHECK(HBM Local Monitor ps executable, hbm_cv_lm_ps_executable, [dnl
AC_ARG_WITH(hbm-lm-ps-executable,
	[  --with-hbm-lm-ps-executable=value  location of ps for HBM Local Monitor to use for client evaluation [/bin/ps]],
	[hbm_cv_lm_ps_executable="$withval"],
	[hbm_cv_lm_ps_executable="/bin/ps"])
])

AC_CACHE_CHECK(HBM heartbeat report interval, hbm_cv_lm_hb_interval, [dnl
AC_ARG_WITH(hbm-lm-hb-interval,
	[  --with-hbm-lm-hb-interval=value  interval (secs) in which the HBM generates heartbeats [5 seconds]],
	[hbm_cv_lm_hb_interval="$withval"],
	[hbm_cv_lm_hb_interval="5"])
])


dnl END of LAC_HBM_ARGS
])



AC_DEFUN(LAC_HBM_PROGS,
[

AC_PATH_PROGS(PS, ps, true)

HBM_EMAIL_ADDR=$hbm_cv_email_addr


dnl Values for "globus-hbm-datacollector.conf.in"

HBM_DATACOLLECTOR_HOST=$hbm_cv_dc_host
HBM_DATACOLLECTOR_COMMAND_PORT=$hbm_cv_dc_cmdport
HBM_DATACOLLECTOR_HEARTBEAT_PORT=$hbm_cv_dc_hbport
HBM_DATACOLLECTOR_EVAL_INTERVAL=$hbm_cv_dc_eval_interval


dnl Values for "globus-hbm-localmonitor.conf.in"

HBM_LOCALMONITOR_PS=$hbm_cv_lm_ps_executable
HBM_LOCALMONITOR_HEARTBEAT_INTERVAL=$hbm_cv_lm_hb_interval


AC_SUBST(HBM_DATACOLLECTOR_HOST)
AC_SUBST(HBM_DATACOLLECTOR_COMMAND_PORT)
AC_SUBST(HBM_DATACOLLECTOR_HEARTBEAT_PORT)
AC_SUBST(HBM_DATACOLLECTOR_EVAL_INTERVAL)
AC_SUBST(HBM_LOCALMONITOR_PS)
AC_SUBST(HBM_LOCALMONITOR_HEARTBEAT_INTERVAL)

])


AC_DEFUN(LAC_HBM,
[
LAC_HBM_ARGS
LAC_HBM_PROGS

])

