AC_DEFUN(LAC_GSSAPI_ARGS,
[

AC_CHECK_LIB(crypt, crypt, [libcrypt="-lcrypt"], [libcrypt=""])

# always configure for one of the implementations
if test "$globus_cv_gssapi_ssleay_enable" = "yes" ; then
    # GSSAPI_SSLEAY must be explicitly enabled
    gssapi_cflags="\$(SSL_CFLAGS)"
    gssapi_ldflags="\$(SSL_LDFLAGS)"
    gssapi_libs="-lglobus_gss_assist -lglobus_gss \$(SSL_LIBS)"

    if test "X$globus_cv_gaa_enable" = "Xyes" ; then
       gssapi_cflags="${gssapi_cflags} \$(GLOBUS_GAA_CFLAGS)"
       gssapi_ldflags="${gssapi_ldflags} \$(GLOBUS_GAA_LDFLAGS)"
       gssapi_libs="${gssapi_libs} \$(GLOBUS_GAA_LIBS)"
    fi
else
    # GSSAPI_cleartext is the default implementation
    gssapi_cflags=""
    gssapi_ldflags=""
    gssapi_libs=" -lglobus_gss_assist -lglobus_gss ${libcrypt}"
fi

dnl these values get stuffed into makefile_header

AC_SUBST(gssapi_cflags)
AC_SUBST(gssapi_ldflags)
AC_SUBST(gssapi_libs)

])

AC_DEFUN(LAC_GSSAPI,
[
    LAC_GSSAPI_ARGS
])


