
AC_DEFUN(LAC_GRAM_ARGS,
[

AC_ARG_WITH(gram-job-manager,
	[  --with-gram-job-manager       GRAM job manager: condor, easymcs, lsf, loadleveler, poe, or fork [fork]],
	[if test "$withval" = "yes" ; then
	     globus_cv_gram_job_manager="fork"
         else
             globus_cv_gram_job_manager="$withval"
         fi
        ],
	[globus_cv_gram_job_manager="fork"])


AC_ARG_WITH(gram-gatekeeper,
	[  --with-gram-gatekeeper        Install the gram gatekeeper [yes]],
	[ globus_cv_gram_gatekeeper="$withval"],
	[ globus_cv_gram_gatekeeper="yes"])



AC_ARG_WITH(gram-port,
       [  --with-gram-port              port number of the gatekeeper [2119]],
       [lac_gram_port="$withval"],
       [lac_gram_port="2119"])


AC_ARG_ENABLE(gram-test,
        [  --disable-gram-test           don't configure GRAM test],
        [lac_enable_gram_test="$enableval"],
        [lac_enable_gram_test="yes"])

])

AC_DEFUN(LAC_GRAM_MYJOB,
[
    if test "$lac_mpl" = "yes" ; then
        GRAM_MYJOB_SHARED_PROTO_OBJS="globus_gram_myjob_mpl.\$(OFILE)"
    elif test "$lac_mpi" = "yes" ; then
        GRAM_MYJOB_SHARED_PROTO_OBJS="globus_gram_myjob_mpi.\$(OFILE)"
    elif test "$lac_inx" = "yes" ; then
        GRAM_MYJOB_SHARED_PROTO_OBJS="globus_gram_myjob_inx.\$(OFILE)"
    else
        GRAM_MYJOB_SHARED_PROTO_OBJS="globus_gram_myjob_duct.\$(OFILE)"
    fi
    AC_SUBST(GRAM_MYJOB_SHARED_PROTO_OBJS)
])

AC_DEFUN(LAC_GRAM,
[
    LAC_GRAM_ARGS

    case "$globus_cv_gram_job_manager" in
        condor )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=condor
            GRAM_JM_SHELL_DEFINE=-DGRAMI_CONDOR_MANAGER
        ;;
        easymcs )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=easymcs
            GRAM_JM_SHELL_DEFINE=-DGRAMI_EASYMCS_MANAGER
        ;;
        loadleveler )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=loadleveler
            GRAM_JM_SHELL_DEFINE=-DGRAMI_LOADLEVELER_MANAGER
        ;;
        grd )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=grd
            GRAM_JM_SHELL_DEFINE=-DGRAMI_GRD_MANAGER
        ;;
        nqe )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=nqe
            GRAM_JM_SHELL_DEFINE=-DGRAMI_NQE_MANAGER
        ;;
        lsf )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=lsf
            GRAM_JM_SHELL_DEFINE=-DGRAMI_LSF_MANAGER
        ;;
        pbs )
            GRAM_JM_METHOD=globus_i_gram_jm_shell
            GRAM_JM_SHELL_TYPE=pbs
            GRAM_JM_SHELL_DEFINE=-DGRAMI_PBS_MANAGER
        ;;
	poe )
	    GRAM_JM_METHOD=globus_i_gram_jm_fork
	    GRAM_JM_SHELL_TYPE=none
	    GRAM_JM_SHELL_DEFINE=-DGRAMI_POE_MANAGER
	;;
	prun )
	    GRAM_JM_METHOD=globus_i_gram_jm_shell
	    GRAM_JM_SHELL_TYPE=prun
	    GRAM_JM_SHELL_DEFINE=-DGRAMI_PRUN_MANAGER
	;;
        fork )
            GRAM_JM_METHOD=globus_i_gram_jm_fork
            GRAM_JM_SHELL_TYPE=none
            GRAM_JM_SHELL_DEFINE=
        ;;
        fake )
            GRAM_JM_METHOD=globus_i_gram_jm_fake
            GRAM_JM_SHELL_TYPE=none
            GRAM_JM_SHELL_DEFINE=
        ;;
	no )
	;;
        * )
            AC_MSG_ERROR([Invalid --with-gram-job-manager value: $globus_cv_gram_job_manager])
        ;;
    esac
    
    GRAM_JM_TYPE=$globus_cv_gram_job_manager

    AC_SUBST(GRAM_JM_TYPE)
    AC_SUBST(GRAM_JM_METHOD)
    AC_SUBST(GRAM_JM_SHELL_TYPE)
    AC_SUBST(GRAM_JM_SHELL_DEFINE)

    dnl Assign all of the GRAM_ERROR values
    dnl This is now in
    dnl ResourceManagement/gram/libraries/client/globus_gram_error.h

    dnl Assign all of the GRAM_STATE values
    dnl This is now in
    dnl ResourceManagement/gram/libraries/client/globus_gram_states.h
])


AC_DEFUN(LAC_LSF_DIR,
[

  if test -d $1 ; then
    LSF_DIRS="$LSF_DIRS $2 $1"
  fi
])
