
AC_DEFUN(GLOBUS_COMMON_ENABLE,
[
globus_cv_common_enable="yes"
lac_globus_any_module_enabled="yes"
])


AC_DEFUN(GLOBUS_DC_ENABLE,
[
globus_cv_dc_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_COMMON_ENABLE
])


AC_DEFUN(GLOBUS_UTP_ENABLE,
[
globus_cv_utp_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_COMMON_ENABLE
])


AC_DEFUN(GLOBUS_IO_ENABLE,
[
globus_cv_io_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_GSSAPI_ENABLE
GLOBUS_COMMON_ENABLE
])

AC_DEFUN(GLOBUS_FTP_ENABLE,
[
globus_cv_ftp_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_GSSAPI_ENABLE
GLOBUS_IO_ENABLE
GLOBUS_COMMON_ENABLE
])


AC_DEFUN(GLOBUS_NETLOGGER_ENABLE,
[
globus_cv_netlogger_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_IO_ENABLE
])


AC_DEFUN(GLOBUS_NEXUS_ENABLE,
[
globus_cv_nexus_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_IO_ENABLE
GLOBUS_DC_ENABLE
GLOBUS_UTP_ENABLE
])


AC_DEFUN(GLOBUS_HBM_ENABLE,
[
globus_cv_hbm_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_RSL_ENABLE
GLOBUS_IO_ENABLE
GLOBUS_COMMON_ENABLE
])



AC_DEFUN(GLOBUS_MDS_ENABLE,
[
globus_cv_mds_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_COMMON_ENABLE
])


AC_DEFUN(GLOBUS_GSSAPI_CLEARTEXT_TYPE,
[
globus_cv_gssapi_cleartext_enable="yes"
globus_cv_gssapi_type="cleartext"
])


AC_DEFUN(GLOBUS_GSSAPI_SSLEAY_TYPE,
[
globus_cv_gssapi_ssleay_enable="yes"
globus_cv_gssapi_type="ssleay"
GLOBUS_GAA_ENABLE
GLOBUS_PKCS12_ENABLE
])


AC_DEFUN(GLOBUS_DEFAULT_GSSAPI_TYPE,
[
GLOBUS_GSSAPI_SSLEAY_TYPE
])


AC_DEFUN(GLOBUS_GSSAPI_TYPE,
[
case "$globus_cv_gssapi_type" in
   cleartext )
      GLOBUS_GSSAPI_CLEARTEXT_TYPE
      ;;
   ssleay )
      GLOBUS_GSSAPI_SSLEAY_TYPE
      ;;
   * )
      GLOBUS_DEFAULT_GSSAPI_TYPE
      ;;
esac
])


AC_DEFUN(GLOBUS_GSSAPI_ENABLE,
[
GLOBUS_GSSAPI_TYPE
globus_cv_gssapi_enable="yes"
lac_globus_any_module_enabled="yes"
])

AC_DEFUN(GLOBUS_GAA_ENABLE,
[
globus_cv_gaa_enable="yes"
])

AC_DEFUN(GLOBUS_PKCS12_ENABLE,
[
globus_cv_pkcs12_enable="yes"
])

AC_DEFUN(GLOBUS_GASS_ENABLE,
[
globus_cv_gass_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_COMMON_ENABLE
GLOBUS_IO_ENABLE
])


AC_DEFUN(GLOBUS_RSL_ENABLE,
[
globus_cv_rsl_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_COMMON_ENABLE
])


AC_DEFUN(GLOBUS_GRAM_ENABLE,
[
globus_cv_gram_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_RSL_ENABLE
GLOBUS_IO_ENABLE
GLOBUS_DUCT_ENABLE
GLOBUS_GASS_ENABLE
GLOBUS_COMMON_ENABLE
GLOBUS_GSSAPI_ENABLE
])

AC_DEFUN(GLOBUS_DUCT_ENABLE,
[
globus_cv_duct_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_NEXUS_ENABLE
GLOBUS_COMMON_ENABLE
])

AC_DEFUN(GLOBUS_DUROC_ENABLE,
[
globus_cv_duroc_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_RSL_ENABLE
GLOBUS_NEXUS_ENABLE
GLOBUS_GRAM_ENABLE
GLOBUS_GASS_ENABLE
GLOBUS_DUCT_ENABLE
GLOBUS_COMMON_ENABLE
])


AC_DEFUN(GLOBUS_GLOBUSRUN_ENABLE,
[
globus_cv_globusrun_enable="yes"
lac_globus_any_module_enabled="yes"
GLOBUS_MDS_ENABLE
GLOBUS_DUROC_ENABLE
GLOBUS_GASS_ENABLE
GLOBUS_COMMON_ENABLE
])

AC_DEFUN(GLOBUS_ALPHA_ENABLE,
[
GLOBUS_STARTUP_ENABLE
GLOBUS_COMMON_ENABLE
GLOBUS_IO_ENABLE
GLOBUS_DC_ENABLE
GLOBUS_UTP_ENABLE
GLOBUS_GSSAPI_ENABLE
GLOBUS_NEXUS_ENABLE
GLOBUS_DUCT_ENABLE
GLOBUS_GRAM_ENABLE
GLOBUS_RSL_ENABLE
GLOBUS_GASS_ENABLE
GLOBUS_MDS_ENABLE
GLOBUS_DUROC_ENABLE
GLOBUS_FTP_ENABLE
GLOBUS_GLOBUSRUN_ENABLE
])

AC_DEFUN(GLOBUS_STARTUP_ENABLE,
[
globus_cv_startup_enable="yes"
lac_globus_any_module_enabled="yes"
])

AC_DEFUN(GLOBUS_BETA_ENABLE,
[
GLOBUS_ALPHA_ENABLE
])

AC_DEFUN(GLOBUS_DEFAULT_ENABLE,
[
GLOBUS_ALPHA_ENABLE
])


dnl Check for explicit enables
dnl Choose a default set if none enabled
dnl order is important for the first couple unusual ones
dnl
AC_DEFUN(GLOBUS_ENABLE_ARGS,
[

dnl Set this before enabling anything
dnl
lac_globus_any_module_enabled="no"

dnl Must process this arg before enabling anything else
dnl so that the correct implementation is enabled
dnl by recursive enables using the generic GSSAPI macro
dnl
AC_ARG_WITH(gssapi,
        [  --with-gssapi                 select "cleartext" or "ssleay" [ssleay]],
        [globus_cv_gssapi_type="$withval"],
        [globus_cv_gssapi_type="notset"])


case "$globus_cv_gssapi_type" in 
    notset )
      ;;
    cleartext )
      GLOBUS_GSSAPI_CLEARTEXT_TYPE
      ;;
    ssleay )
      GLOBUS_GSSAPI_SSLEAY_TYPE
      ;;
    * )
      AC_MSG_WARN("Unrecognized GSSAPI type \"$globus_cv_gssapi_type\" using default")
      globus_cv_gssapi_type="notset"
      GLOBUS_GSSAPI_ENABLE
      ;;
esac


AC_ARG_ENABLE(alpha,
        [  --enable-alpha                include Alpha components ],
        [lac_enable_alpha="$enableval"],
        [lac_enable_alpha="no"])
if test "$lac_enable_alpha" = "yes" ; then
  GLOBUS_ALPHA_ENABLE
fi

AC_ARG_ENABLE(beta,
        [  --enable-beta                 include Beta components ],
        [lac_enable_beta="$enableval"],
        [lac_enable_beta="no"])
if test "$lac_enable_beta" = "yes" ; then
  GLOBUS_BETA_ENABLE
fi 

AC_ARG_ENABLE(globusrun,
        [  --enable-globusrun            configure globusrun and dependents ],
        [lac_enable_globusrun="$enableval"],
        [lac_enable_globusrun="no"])
if test "$lac_enable_globusrun" = "yes" ; then
  GLOBUS_GLOBUSRUN_ENABLE
fi

AC_ARG_ENABLE(globus_common,
        [  --enable-globus-common        configure globus_common ],
        [lac_enable_globus_common="$enableval"],
        [lac_enable_globus_common="no"])
if test "$lac_enable_globus_common" = "yes" ; then
  GLOBUS_COMMON_ENABLE
fi

AC_ARG_ENABLE(dc,
        [  --enable-dc                   configure DC (data conversion)],
        [lac_enable_dc="$enableval"],
        [lac_enable_dc="no"])
if test "$lac_enable_dc" = "yes" ; then
  GLOBUS_DC_ENABLE
fi

AC_ARG_ENABLE(utp,
        [  --enable-utp                  configure UTP (timers)],
        [lac_enable_utp="$enableval"],
        [lac_enable_utp="no"])
if test "$lac_enable_utp" = "yes" ; then
  GLOBUS_UTP_ENABLE
fi

AC_ARG_ENABLE(gssapi,
        [  --enable-gssapi               configure GSSAPI],
        [lac_enable_gssapi="$enableval"],
        [lac_enable_gssapi="no"])
if test "$lac_enable_gssapi" = "yes" ; then
  GLOBUS_GSSAPI_ENABLE
fi

AC_ARG_ENABLE(gaa,
        [  --enable-gaa                  configure GAA],
        [lac_enable_gaa="$enableval"],
        [lac_enable_gaa="no"])
if test "$lac_enable_gaa" = "yes" ; then
  GLOBUS_GAA_ENABLE
fi

AC_ARG_ENABLE(globus_io,
        [  --enable-globus-io            configure globus_io ],
        [lac_enable_globus_io="$enableval"],
        [lac_enable_globus_io="no"])
if test "$lac_enable_globus_io" = "yes" ; then
  GLOBUS_IO_ENABLE
fi

AC_ARG_ENABLE(netlogger,
        [  --enable-netlogger            configure netlogger],
        [lac_enable_netlogger="$enableval"],
        [lac_enable_netlogger="no"])
if test "$lac_enable_netlogger" = "yes" ; then
  GLOBUS_NETLOGGER_ENABLE
fi

AC_ARG_ENABLE(nexus,
        [  --enable-nexus                configure Nexus],
        [lac_enable_nexus="$enableval"],
        [lac_enable_nexus="no"])
if test "$lac_enable_nexus" = "yes" ; then
  GLOBUS_NEXUS_ENABLE
fi

AC_ARG_ENABLE(rsl,
        [  --enable-rsl                  configure RSL],
        [lac_enable_rsl="$enableval"],
        [lac_enable_rsl="no"])
if test "$lac_enable_rsl" = "yes" ; then
  GLOBUS_RSL_ENABLE
fi

AC_ARG_ENABLE(gram,
        [  --enable-gram                 configure GRAM],
        [lac_enable_gram="$enableval"],
        [lac_enable_gram="no"])
if test "$lac_enable_gram" = "yes" ; then
  GLOBUS_GRAM_ENABLE
fi

AC_ARG_ENABLE(gass,
        [  --enable-gass                 configure GASS (remote file access) ],
        [lac_enable_gass="$enableval"],
        [lac_enable_gass="no"])
if test "$lac_enable_gass" = "yes" ; then
  GLOBUS_GASS_ENABLE
fi

AC_ARG_ENABLE(ftp,
        [  --enable-ftp                  configure FTP (ftp file access) ],
        [lac_enable_ftp="$enableval"],
        [lac_enable_ftp="no"])
if test "$lac_enable_ftp" = "yes" ; then
  GLOBUS_FTP_ENABLE
fi

AC_ARG_ENABLE(duct,
        [  --enable-duct                 configure DUCT],
        [lac_enable_duct="$enableval"],
        [lac_enable_duct="no"])
if test "$lac_enable_duct" = "yes" ; then
  GLOBUS_DUCT_ENABLE
fi

AC_ARG_ENABLE(duroc,
        [  --enable-duroc                configure DUROC],
        [lac_enable_duroc="$enableval"],
        [lac_enable_duroc="no"])
if test "$lac_enable_duroc" = "yes" ; then
  GLOBUS_DUROC_ENABLE
fi

AC_ARG_ENABLE(hbm,
        [  --enable-hbm                  configure Heartbeat Monitor],
        [lac_enable_hbm="$enableval"],
        [lac_enable_hbm="no"])
if test "$lac_enable_hbm" = "yes" ; then
  GLOBUS_HBM_ENABLE
fi

AC_ARG_ENABLE(mds,
        [  --enable-mds                  configure MDS],
        [lac_enable_mds="$enableval"],
        [lac_enable_mds="no"])
if test "$lac_enable_mds" = "yes" ; then
  GLOBUS_MDS_ENABLE
fi



AC_ARG_ENABLE(startup,
        [  --enable-startup              configure RC startup scripts],
        [lac_enable_startup="$enableval"],
        [lac_enable_startup="no"])
if test "$lac_enable_startup" = "yes" ; then
  GLOBUS_STARTUP_ENABLE
fi



dnl If no enable macro toggled this flag from "no",
dnl enable a default set
dnl
if test "$lac_globus_any_module_enabled" = "no" ; then
  AC_MSG_WARN("Enabling default component set")
  GLOBUS_DEFAULT_ENABLE
fi

])
