
AC_DEFUN(LAC_CCXX_ARGS,
[

AC_ARG_ENABLE(purify,
	[  --enable-purify              use purify],
	[lac_cv_purify="$enableval"],
	[lac_cv_purify=${lac_cv_purify='no'}])

AC_ARG_ENABLE(ccxx,
	[  --disable-ccxx              don't support CC++ extensions],
	[lac_cv_ccxx_extensions="$enableval"],
	[lac_cv_ccxx_extensions=${lac_cv_ccxx_extensions='yes'}])

AC_ARG_ENABLE(checking,
	[  --disable-checking          don't do consistancy checking in parser],
	[lac_cv_edg_checking="$enableval"],
	[lac_cv_edg_checking=${lac_cv_edg_checking='yes'}])

AC_ARG_ENABLE(stand-alone,
	[  --enable-stand-alone        compile standalone edgcpfe],
	[lac_cv_edg_standalone="$enableval"],
	[lac_cv_edg_standalone=${lac_cv_edg_standalone='no'}])

AC_ARG_ENABLE(cp-backend,
	[  --enable-cp-backend         generate c++ code as output],
	[lac_cv_cxx_backend="$enableval"],
	[lac_cv_cxx_backend=${lac_cv_cxx_backend='no'}])

AC_ARG_ENABLE(sage-backend,
	[  --enable-sage-backend        generate sage++ tree],
	[lac_cv_sage_backend="$enableval"],
	[lac_cv_sage_backend=${lac_cv_sage_backend='no'}])

AC_ARG_ENABLE(stl,
	[  --disable-stl                don't use STL lists],
	[lac_cv_stl="$enableval"],
	[lac_cv_stl=${lac_cv_stl='yes'}])

AC_ARG_WITH(nexus-library,
        [  --with-nexus-library=PATH    path to nexus library files],
        [lac_nexus_library_path="$withval"],
        [lac_nexus_library_path=${lac_nexus_library_path=''}])
AC_ARG_WITH(nexus-includes,
        [  --with-nexus-includes=PATH   path to nexus include files],
        [lac_nexus_include_path="$withval"],
	[lac_nexus_include_path=${lac_nexus_library_path=''}])
])


AC_DEFUN(LAC_CCXX,
[

LAC_CCXX_ARGS

if test "$lac_cv_purify" = "yes" ; then
    AC_DEFINE(USING_PURIFY)
    AC_CHECK_PROG(PURIFY,purify,purify) 	
fi

if test "$lac_cv_ccxx_extensions" = "yes" ; then
    AC_DEFINE(CCPP_EXTENSIONS_ALLOWED)
fi

if test "$lac_cv_edg_checking" = "yes" ; then
    AC_DEFINE(CHECKING)
fi

if test "$lac_cv_stl" = "yes" ; then
    AC_DEFINE(USE_STL)
    SAGE2_SHARED_LIST_OBJS=EMPTY
else
    SAGE2_SHARED_LIST_OBJS=SAGE2_SHARED_LIST_OBJS
fi
AC_SUBST(SAGE2_SHARED_LIST_OBJS)	


if test "$cp_backend" = "yes" -a "$sage_backend" = "yes"; then 
    AC_MSG_ERROR(Cannot have both sage and c++ backend)
fi

if test "$cp_backend" = "yes"; then 
    AC_DEFINE(BACK_END_IS_CP_GEN_BE,1)
    GEN_BE="cp_gen_be.o"
else
    AC_DEFINE(BACK_END_IS_SAGE_GEN_BE,1)
    GEN_BE="sage_gen_be.o"
    if test "$standalone"="no"; then
	AC_DEFINE(BUILDING_PARSER_AS_LIB)
    fi
fi
AC_SUBST(GEN_BE)	

dnl
dnl Figure out all of the startup and protocol modules
dnl
shared_startup_objs=""
static_startup_objs=""

NEXUS_SHARED_PROTO_OBJS="$shared_proto_objs"
AC_SUBST(NEXUS_SHARED_PROTO_OBJS)

NEXUS_MD_MODULE="md_unix"
AC_SUBST(NEXUS_MD_MODULE)
])


AC_DEFUN(LAC_HAVE_STL,
[ AC_MSG_CHECKING(for STL)
  AC_CACHE_VAL(lac_cv_stl, [dnl
  AC_EGREP_CPP(zowie,
[#include <stl.h>
#ifdef SIGWAITING
 zowie
#endif
], lac_cv_stl="yes",
lac_cv_stl="no")
])
  AC_MSG_RESULT($lac_cv_stl)
  if test "$lac_cv_stl" = "yes"; then
    AC_DEFINE(HAVE_STL)
  fi
])

dnl Check the type of the C++ compiler
AC_DEFUN(LAC_CXX_TYPE,
[  AC_MSG_CHECKING(C++ compiler type)
   AC_CACHE_VAL(lac_cv_cxx_type, [dnl
   AC_LANG_SAVE
   AC_LANG_CPLUSPLUS
   LAC_EGREP_CPP_RESULT(type,
[#if defined(__CLCC__) || defined(CENTERLINE_CLPP)
  type centerline
#elif (defined(sgi) && defined(mips) && defined(_LANGUAGE_C_PLUS_PLUS))
  type sgiCC
#elif __GNUG__
  type gnu
#elif __DECCXX
  type deccxx
#elif __xlC__
  type xlC
#elif __SUNPRO_CC
  type sunCC4
#elif __PGC__
  type pgc
#endif], lac_cv_cxx_type=`sed -e '/type/ {s/ *type[ ]*//;s/ *//g;}' conftest.out`,
  # The compiler doen't seem to identify itself.  Lets try some other methods...
  echo "int main() { return 0; }" > conftest.$ac_ext
  if `($CXX -F conftest.$ac_ext | egrep 'HP C++' > /dev/null) 2> /dev/null` ; then
  # HP C++ puts a comment into the output file
    lac_cv_cxx_type=HPCC
  elif `($CXX -F conftest.$ac_ext | egrep 'USL C++' > /dev/null) 2> /dev/null` ; then
  # USL Cfront puts a comment into the output file
    lac_cv_cxx_type=USL
  # See if it is a pre version 4 Sun compiler by looking at the banner
  elif `$CXX -V -dryrun conftest.$ac_ext 2>&1 | egrep 'Sun C++' > /dev/null` ; then
    lac_cv_cxx_type=sunCC
  else
    lac_cv_cxx_type=unknown
  fi 
  rm conftest*
     ) dnl -- End of AC_EGREP_CPP
 ]) dnl --End AC_CACHE_VAL()
 AC_MSG_RESULT($lac_cv_cxx_type)
 CXX_TYPE=$lac_cv_cxx_type 
 AC_SUBST(CXX_TYPE)dnl
 AC_PROVIDE([AC_CXX_TYPE])dnl 
]) dnl --End AC_CXX_TYPE()

dnl Check the type of the C++ compiler
AC_DEFUN(LAC_CXX_VERSION,
[ AC_REQUIRE([LAC_CXX_TYPE])dnl
  AC_REQUIRE_CPP 
  AC_MSG_CHECKING(C++ compiler version)
  AC_CACHE_VAL(lac_cv_cxx_version, [dnl
  AC_LANG_SAVE
  AC_LANG_CPLUSPLUS
  LAC_EGREP_CPP_RESULT(version,
[#if defined(__CLCC__) || defined(CENTERLINE_CLPP)
  type centerline
#elif __GNUG__
  version __VERSION__
#elif __xlC__
version __xlC__
#elif __SUNPRO_CC
version __SUNPRO_CC
#endif], lac_cv_cxx_version=`sed -e '/version/ {s/ *version[ ]*//;s/ *//;}' conftest.out`,[
  # No predefined version macro, got to poke around looking for it...
  case "${lac_cv_cxx_type}" in
  sunCC)
	# The version number of this compiler is printed by the -V option on stderr.
	# look for the string Sun C++ x.y.z
	echo "int main() { return 0; }" > conftest.$ac_ext
	lac_cv_cxx_version=`$CXX -V -E $conftest.$ac_ext 2>/dev/null | grep version | \
		sed -e '{s/.*Sun C++ *//;}'`
	rm -f conftest*
	;;
  USL)
	# USL Cfront puts the version number in a comment in 
	# output file.
	echo "int main() { return 0; }" > conftest.$ac_ext
	cpp_version=`$CXX -F conftest.$ac_ext | grep USL | \
		sed -e '/USL/ {s/.*<//; s/>.*$//;}'`
	rm -f conftest*
	;;
  HPCC)
	# HP C++ puts the version number in a comment in output file.
  	# String looks like: /* <<HP C++ B2402  A.03.50>> */
	echo "int main() { return 0; }" > conftest.$ac_ext
	lac_cv_cxx_version=`$CXX -F conftest.$ac_ext | grep HP | \
	    sed -e '/HP/ {s/.* A\.//;s/>.*//;}'`
	rm -f conftest*
	;;
  centerline)
	# Centerline Cfront puts the version number in a comment in output file.
	echo "int main() { return 0; }" > conftest.$ac_ext
	lac_cv_cxx_version=`$CXX -F conftest.$ac_ext.C | grep 'ObjectCenter Version' | \
	    sed -e 's/.*ObjectCenter Version *\([0-9.]*\).*/\1/'`
	rm -f conftest*
	;;
  deccxx)
	lac_cv_cxx_version=`$CXX -V 2>/dev/null | grep "DEC C++ V" |
	    $AWK '{ print $3; }'`
    	;;
  *) 
	lac_cv_cxx_version='0'
	;;
  esac]dnl
     ) dnl -- End of AC_EGREP_CPP
 ]) dnl --End AC_CACHE_VAL()
 # We use the hex type version string rather than the x.y.z
 # version string.  This way we can test for version within the preprocessor.
 # Remove dots hyphens and double quotes and spaces.
 lac_cv_cxx_version="`echo $lac_cv_cxx_version | \
   sed -e 's/\.//g' -e 's/\-//g' -e 's/\"//g' -e 's/ //g'"
 case $lac_cv_cxx_version in
   0x???) lac_cv_cxx_version=`echo $lac_cv_cxx_version | sed -e 's/0x/0x0/'` 	;;
   0x*)	  ;;
   ??) 	  lac_cv_cxx_version="0x00$lac_cv_cxx_version";;
   ???)	  lac_cv_cxx_version="0x0$lac_cv_cxx_version" ;;
   *)     lac_cv_cxx_version="0x$lac_cv_cxx_version" ;;
 esac
 AC_MSG_RESULT($lac_cv_cxx_version)
 CXX_VERSION=$lac_cv_cxx_version
 AC_SUBST(CXX_VERSION)dnl
]) dnl --End AC_CXX_VERSION()

AC_DEFUN(LAC_CXX_PREDEFINED_INCLUDES,
[AC_REQUIRE([AC_PROG_AWK])dnl
 AC_REQUIRE([LAC_CXX_VERSION])
 AC_REQUIRE([LAC_CXX_TYPE])
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 echo "int main() { return 0; }" > conftest.$ac_ext
 cxx_cmd="$CXX -v"
 case "$target_alias-$CXX_TYPE_$CXX_VERSION" in
 *) ac_cxx_predefined_includes="`$cxx_cmd -v conftest.$ac_ext 2>&1 | \
      ${AWK} '{for(i=1;i<=NF;i++) if ($i ~ /-I/) printf(\"%s \",$i);}'`"
 esac
 rm -f conftest.* a.out
 AC_LANG_RESTORE
])

AC_DEFUN(LAC_CXX_PREDEFINED_DEFINES,
[AC_REQUIRE([AC_PROG_AWK])dnl
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 echo "int main() { return 0; }" > conftest.$ac_ext
 cxx_cmd="$CXX -v"
 ac_cxx_predefined_defines="`$cxx_cmd -v conftest.$ac_ext 2>&1 | \
    ${AWK} '{for(i=1;i<=NF;i++) if ($i ~ /-D/) printf(\"%s \",$i);}'`"
 rm -f conftest.* 
 AC_LANG_RESTORE
])

AC_DEFUN(LAC_CXX_INCLUDE_PATHS,
[AC_REQUIRE([AC_PROG_AWK])dnl
 AC_MSG_CHECKING(C++ system includes)
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 LAC_CXX_PREDEFINED_INCLUDES
 ac_config_includedirs=$topsrcdir/includedirs.awk
cat > conftest.$ac_ext <<EOF
 ac_predefined_includes "$ac_cxx_predefined_includes"
 ac_include_file_list "$1"
EOF
for ac_hdr in $1
do
echo "#include <$ac_hdr>" >> conftest.$ac_ext
done
dnl eval is necessary to expand ac_cpp.
dnl Ultrix and Pyramid sh refuse to redirect output of eval, so use subshell.
CXX_INCLUDE_PATHS=`(eval "$ac_cpp conftest.$ac_ext") 2>&AC_FD_CC |
  $AWK -f $ac_config_includedirs` 
rm -rf conftest*
AC_LANG_RESTORE
AC_MSG_RESULT($CXX_INCLUDE_PATHS)
AC_SUBST(CXX_INCLUDE_PATHS)
])

AC_DEFUN(LAC_CXX_DEFINES,
[AC_REQUIRE([AC_PROG_AWK])dnl
 AC_REQUIRE([AC_CANONICAL_SYSTEM]) 
 AC_REQUIRE([LAC_CXX_INCLUDE_PATHS])
 AC_MSG_CHECKING(C++ compiler defines)
 LAC_CXX_PREDEFINED_DEFINES
 AC_CACHE_VAL(lac_cv_cxx_defines, [dnl
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS

 case "$target_alias-$CXX_TYPE-$CXX_VERSION" in
 sparc-sun-solaris2.5-sunCC4-0x0410)
   lac_cv_cxx_defines="-Dsun=1 -D__SUNPRO_CC=0x410 -Dsparc=1 -D__SunOS_5_5=1 -D__STDC__=0 -D_WCHAR_T -D__unix=1 -D__sparc=1 -Dunix=1 -D__cplusplus=1 -D__SVR4=1 -D__BUILTIN_VA_ARG_INCR=1 -D__sun=1"
    ;;
 sparc-sun-solaris2.3-sunCC4-0x0401)
   lac_cv_cxx_defines="-D__SUNPRO_CC=0x401 -Dsun=1 -Dsparc=1 -D__STDC__=0 -D_WCHAR_T -D__unix=1 -D__sparc=1 -Dunix=1 -D__cplusplus=1 -D__SVR4=1 -D__BUILTIN_VA_ARG_INCR=1 -D__sun=1"  
    ;;
 *-ibm-aix3.2.5-xlC-0x0201)
   lac_cv_cxx_defines="-D_AIX=1 -D__STDC__=1 -D__MATH__=1 -D_IBMR2=1 -D__cplusplus=1 -D__xlC__=0x0201 -D__STR__=1"  
    ;;
 *)	
   ac_config_ifnames=$topsrcdir/ifnames
   echo $ac_n "scaning include files ... $ac_c" 1>&AC_FD_MSG
   echo $ac_cxx_predefined_defines | ${AWK} '
    { gsub("-D",""); gsub("=[[^ ]]+",""); split([$]0,sym);
      for (i in sym) 
        printf("#if defined(%s)\n define\"%s\" %s\n#endif\n", 
	  sym[[i]],sym[[i]],sym[[i]]);
    }' > conftest.$ac_ext
   AWK=${AWK} $ac_config_ifnames $CXX_INCLUDE_PATHS >> conftest.$ac_ext
   lac_cv_cxx_defines=`(eval "$ac_cpp conftest.$ac_ext") 2>&AC_FD_CC |
     ${AWK} '/^define/ {sym=[$]2; gsub("\"","",sym); syms[[sym]]=[$]3;}
	END {for (sym in syms) {
	  printf("-D" sym);
	  if (syms[[sym]] != "" ) printf("=" syms[[sym]]);
	  printf(" ");}}'`
 esac 
 rm -rf conftest*
 AC_LANG_RESTORE
 ])
 AC_MSG_RESULT($lac_cv_cxx_defines)
 CXX_DEFINES=$lac_cv_cxx_defines 
 AC_SUBST(CXX_DEFINES)
])


AC_DEFUN(LAC_CXX_WCHAR_T,
[AC_CACHE_CHECK(for C++ wchar, ac_cv_cxx_wchar_t_double,
 AC_LANG_SAVE
 AC_LANG_CPLUSPLUS
 AC_TRY_COMPILE(
	[wchar_t foo = 0.0;]
	[exit(sizeof(wchar_t) < sizeof(char));],
	ac_cv_cxx_wchar_t=yes, ac_cv_cxx_wchar_t=no)
if test $ac_cv_c_wchar_t = yes; then
  AC_DEFINE(HAVE_CXX_WCHAR_T)
fi
AC_LANG_RESTORE
])

AC_DEFUN(LAC_NEXUS_PATH,
[  AC_MSG_CHECKING(path to nexus configuration directory....)
if test -z "$NEXUS_PATH"; then
  for lac_nexus_path in nexus_src ../nexus_src ../../nexus_src; do
    if test -d $lac_nexus_path; then
       NEXUS_PATH=$lac_nexus_path
       break
    fi
  done
fi
AC_SUBST(NEXUS_PATH)
test -z "$NEXUS_PATH" && AC_MSG_ERROR([not found])
])
