/*
 * test_nx.c
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/tests/miscellaneous/test_nx.c,v 1.42 1999/09/09 04:52:19 bresnaha Exp $";

#undef  CONDITION_TEST
#undef  LOCAL_COMM_TEST
#define ATTACH_COMM_TEST
#undef  GRAM_MYJOB_COMM_TEST
#undef TIME_GLOBUS_POLL
#define USE_THREADED_HANDLER

#ifndef GLOBUS_NEXUS_TEST_WITH_GRAM
#undef GRAM_MYJOB_COMM_TEST
#endif

#include "globus_nexus.h"

#include "stdio.h"
#include "errno.h"

#ifdef CONDITION_TEST
static void condition_test(void);
#endif /* CONDITION_TEST */

#ifdef LOCAL_COMM_TEST
#ifndef COMM_TEST
#define COMM_TEST
#endif
static void local_comm_test(void);
#endif /* LOCAL_COMM_TEST */

#ifdef TIME_GLOBUS_POLL
static void time_globus_poll(void);
#endif /* TIME_GLOBUS_POLL */

#ifdef GRAM_MYJOB_COMM_TEST
#include "globus_gram_myjob.h"
static void gram_myjob_comm_test(void);
#ifndef COMM_TEST
#define COMM_TEST
#endif
#endif /* GRAM_MYJOB_COMM_TEST */

#ifdef ATTACH_COMM_TEST
#ifndef COMM_TEST
#define COMM_TEST
#endif
static globus_bool_t		attach_server_arg = GLOBUS_FALSE;
static globus_bool_t		attach_client_arg = GLOBUS_FALSE;
static char *			attach_client_url;
static globus_bool_t		attach_client_leave_server = GLOBUS_FALSE;
static globus_bool_t		attach_client_die = GLOBUS_FALSE;

static void attach_client(void);
static void attach_server(void);

#endif /* ATTACH_COMM_TEST */


#ifdef COMM_TEST

static void comm_test(globus_nexus_startpoint_t *startpoint);

static void comm_test_remote_handler(globus_nexus_endpoint_t *endpoint,
				globus_nexus_buffer_t *buffer,
				globus_bool_t called_from_non_threaded_handler);
#define COMM_TEST_REMOTE_HANDLER_ID 0
static void comm_test_finish_handler(globus_nexus_endpoint_t *endpoint,
				globus_nexus_buffer_t *buffer,
				globus_bool_t called_from_non_threaded_handler);
#define COMM_TEST_FINISH_HANDLER_ID 1


#ifdef USE_THREADED_HANDLER
#define COMM_TEST_HANDLER_TYPE GLOBUS_NEXUS_HANDLER_TYPE_THREADED
#else
#define COMM_TEST_HANDLER_TYPE GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED
#endif

static globus_nexus_handler_t comm_test_remote_handler_table[] =
{
  {COMM_TEST_HANDLER_TYPE,
   comm_test_remote_handler},
  {GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED,
   comm_test_finish_handler},
  {GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED,
   (nexus_handler_func_t) NULL},
};

#define COMM_TEST_REMOTE_HANDLER_TABLE_SIZE 2

static void comm_test_reply_handler(globus_nexus_endpoint_t *endpoint,
				globus_nexus_buffer_t *buffer,
				globus_bool_t called_from_non_threaded_handler);
#define COMM_TEST_REPLY_HANDLER_ID 0

static globus_nexus_handler_t comm_test_reply_handler_table[] =
{
  {GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED,
   comm_test_reply_handler},
  {GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED,
   (nexus_handler_func_t) NULL},
};

#define COMM_TEST_REPLY_HANDLER_TABLE_SIZE 1


static void comm_test_finish_init();
static void comm_test_finish_destroy();
static void comm_test_finish_wait();
static void comm_test_finish_send(globus_nexus_startpoint_t *sp);

#endif /* COMM_TEST */


#ifndef MAX
#define MAX(V1,V2) (((V1) > (V2)) ? (V1) : (V2))
#define MIN(V1,V2) (((V1) < (V2)) ? (V1) : (V2))
#endif


/*
 * unknown_handler()
 */
void
unknown_handler(globus_nexus_endpoint_t *endpoint,
		globus_nexus_buffer_t *buffer,
		int handler_id)
{
    globus_libc_printf("unknown_handler(): handler_id=%d\n", handler_id);
    globus_libc_printf("unknown_handler(): exiting\n");
} /* unknown_handler() */


/*
 * fault_callback()
 */
int fault_callback(void *user_arg, int fault_code)
{
    globus_libc_printf("fault_callback(): fault_code=%d\n",
		 fault_code);
    return(0);
} /* fault_callback() */


/*****************************************************************
 *		MAIN
 *****************************************************************/

/*
 * main()
 */
int main(int argc, char **argv)
{
    int i;
    int rc;

    i = 1;
    while (i < argc)
    {
	if (   (strcmp(argv[i], "-h") == 0)
	    || (strcmp(argv[i], "-help") == 0)
	    || (strcmp(argv[i], "--h") == 0)
	    || (strcmp(argv[i], "--help") == 0) )
	{
	    globus_libc_printf("Usage: %s <args>\n", argv[0]);
	    globus_libc_printf("Where <args> is:\n");
#ifdef ATTACH_COMM_TEST
	    globus_libc_printf("    -s                        : Attach test server\n");
	    globus_libc_printf("    -c <URL>                  : Attach test client\n");
	    globus_libc_printf("                                <URL> is server's URL\n");
	    globus_libc_printf("    -cl                       : Client leaves server running\n");
	    globus_libc_printf("    -cdie                     : Force client failure\n");
#endif /* ATTACH_COMM_TEST */
	    exit(0);
	}
	
#ifdef ATTACH_COMM_TEST
	else if (strcmp(argv[i], "-s") == 0)
	{
	    attach_server_arg = GLOBUS_TRUE;
	    i++;
	}
	else if ((strcmp(argv[i], "-c") == 0) && (i + 1 < argc))
	{
	    attach_client_arg = GLOBUS_TRUE;
	    attach_client_url = argv[i + 1];
	    i += 2;
	}
	else if (strcmp(argv[i], "-cl") == 0)
	{
	    attach_client_leave_server = GLOBUS_TRUE;
	    i++;
	}
	else if (strcmp(argv[i], "-cdie") == 0)
	{
	    attach_client_die = GLOBUS_TRUE;
	    i++;
	}
#endif /* ATTACH_COMM_TEST */
	else
	{
	    globus_libc_printf("Invalid argument: %s\n", argv[i]);
	    globus_libc_printf("For help, run: %s -help\n", argv[0]);
	    exit(1);
	}
    }
    
#ifdef ATTACH_COMM_TEST
    if (!attach_server_arg && !attach_client_arg)
    {
	printf("Error: Either -s or -c must be used with the attach test.\n");
	printf("For help, run: %s -help\n", argv[0]);
	exit(1);
    }
#endif /* ATTACH_COMM_TEST */

    rc = globus_module_activate(GLOBUS_NEXUS_MODULE);
    if (rc != GLOBUS_SUCCESS)
    {
	printf("globus_module_activate() failed with rc=%d\n", rc);
	exit(0);
    }

    globus_libc_printf("main(): After globus_module_activate()\n");

    globus_nexus_enable_fault_tolerance(fault_callback, NULL);
    
#ifdef CONDITION_TEST
    condition_test();
#endif /* CONDITION_TEST */

#ifdef LOCAL_COMM_TEST
    local_comm_test();
#endif /* LOCAL_COMM_TEST */

#ifdef GRAM_MYJOB_COMM_TEST
    gram_myjob_comm_test();
#endif /* GRAM_MYJOB_COMM_TEST */
    
#ifdef ATTACH_COMM_TEST
    if (attach_server_arg)
    {
	attach_server();
	goto alldone;
    }
    else if (attach_client_arg)
    {
	attach_client();
    }
#endif /* ATTACH_COMM_TEST */
    
#ifdef TIME_GLOBUS_POLL
    time_globus_poll();
#endif /* TIME_GLOBUS_POLL */

 alldone:
    
    globus_libc_printf("main(): calling globus_module_deactivate()\n");
    globus_module_deactivate(GLOBUS_NEXUS_MODULE);
    return(0);

} /* main() */


/*****************************************************************
 *		CONDITION_TEST
 *****************************************************************/
#ifdef CONDITION_TEST

static globus_mutex_t	condition_test_mutex;
static globus_mutex_t    busy_mutex;
static globus_cond_t	condition_test_cond;
/*
static int  cond_flag1 = 0;
static int  cond_flag2 = 0;
*/
void *condition_test_thread2(void *arg)
{
    int rc;

    globus_libc_printf("condition_test(): thread2: entering\n");

    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread2: waiting for signal \n");
    globus_cond_wait(&condition_test_cond, &condition_test_mutex);
    globus_libc_printf("condition_test(): thread2: awoken\n");
    globus_mutex_unlock(&condition_test_mutex);
    
    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread2: waiting for broadcast\n");
    globus_cond_wait(&condition_test_cond, &condition_test_mutex);
    globus_libc_printf("condition_test(): thread2: awoken\n");
    globus_mutex_unlock(&condition_test_mutex);

    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread2: waiting for sync\n");
    globus_cond_wait(&condition_test_cond, &condition_test_mutex);
    globus_mutex_unlock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread2: trying to acquire busy lock\n");
    rc = globus_mutex_trylock(&busy_mutex);
    if (rc != EBUSY)
    {
	globus_nexus_fatal("condition_test(): lock returned %d instead of %d (EBUSY)\n", rc, EBUSY);
    }
    globus_cond_signal(&condition_test_cond);
    globus_libc_printf("condition_test(): thread2: busy lock not acquired\n");

    globus_libc_printf("condition_test(): thread2: exiting\n");

    return (NULL);
} /* condition_test_thread2() */

/*
 * condition_test()
 */
static void condition_test(void)
{
    globus_nexus_thread_t thread;
    int rc;
    
    globus_libc_printf("condition_test(): starting\n");
    
    globus_mutex_init(&condition_test_mutex, (globus_mutexattr_t *) NULL);
    globus_mutex_init(&busy_mutex, (globus_mutexattr_t *) NULL);
    globus_cond_init(&condition_test_cond, (globus_condattr_t *) NULL);
    
    globus_nexus_thread_create(&thread,
			(nexus_thread_attr_t *) NULL,
			condition_test_thread2,
			(void *) NULL);

    sleep(3); globus_nexus_thread_yield();
    
    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread1: signaling\n");
    globus_mutex_unlock(&condition_test_mutex);
    globus_cond_signal(&condition_test_cond);
    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread1: done signaling\n");
    globus_mutex_unlock(&condition_test_mutex);

    sleep(3); globus_nexus_thread_yield();
    
    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread1: broadcasting\n");
    globus_mutex_unlock(&condition_test_mutex);
    globus_cond_broadcast(&condition_test_cond);
    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread1: done broadcasting\n");
    globus_mutex_unlock(&condition_test_mutex);

    sleep(3); globus_nexus_thread_yield();

    globus_libc_printf("condition_test(): thread1: trying to acquire busy lock\n");
    rc = globus_mutex_trylock(&busy_mutex);
    if (rc != 0)
    {
	globus_nexus_fatal("condition_test(): trylock returned %d instead of 0 (success)\n", rc);
    }
    globus_libc_printf("condition_test(): thread1: busy lock acquired\n");
    globus_cond_signal(&condition_test_cond);
    globus_mutex_lock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread1: waiting for thread2\n");
    globus_cond_wait(&condition_test_cond, &condition_test_mutex);
    globus_mutex_unlock(&condition_test_mutex);
    globus_libc_printf("condition_test(): thread1: unlocking busy lock\n");
    globus_mutex_unlock(&busy_mutex);

    sleep(3); globus_nexus_thread_yield();

    globus_mutex_destroy(&condition_test_mutex);
    globus_mutex_destroy(&busy_mutex);
    globus_cond_destroy(&condition_test_cond);
    
    globus_libc_printf("condition_test(): complete\n");
} /* condition_test() */

#endif /* CONDITION_TEST */


/*****************************************************************
 *		COMM_TEST
 *****************************************************************/
#ifdef COMM_TEST

typedef struct _comm_test_reply_done_t
{
    globus_mutex_t	mutex;
    globus_cond_t	cond;
    globus_bool_t		done;
} comm_test_reply_done_t;
static comm_test_reply_done_t comm_test_reply_done;

static int			comm_test_int_data = 42;


/*
 * comm_test()
 *
 * Invoke comm_test_remote_handler() in the context pointed to
 * by 'remote_sp'.  The remote handler will bounce a message
 * back to the original context using comm_test_reply_handler().
 * The reply handler will signal the original thread via a monitor.
 */
static void comm_test(globus_nexus_startpoint_t *remote_sp)
{
    globus_nexus_endpointattr_t reply_epattr;
    globus_nexus_endpoint_t reply_ep;
    globus_nexus_startpoint_t reply_sp;
    globus_nexus_buffer_t buffer;
    int buf_size;
    int proto_count;
    globus_nexus_proto_info_udp_t   udp_proto;
    int                             localport;
    char                            localhost[16];
    int                             remoteport;
    char                            remotehost[16];
   

    globus_libc_printf("comm_test(): starting\n");

    /*
     * Initialize the monitor that will be used for signaling
     * completion of the reply handler.
     */
    globus_mutex_init(&(comm_test_reply_done.mutex),
		     (globus_mutexattr_t *) NULL);
    globus_cond_init(&(comm_test_reply_done.cond), (globus_condattr_t *) NULL);
    globus_mutex_lock(&(comm_test_reply_done.mutex));
    comm_test_reply_done.done = GLOBUS_FALSE;
    globus_mutex_unlock(&(comm_test_reply_done.mutex));

    /*
     * Set up a reply endpoint/startpoint, and point
     * it at the reply done monitor
     */
    globus_nexus_endpointattr_init(&reply_epattr);
    globus_nexus_endpointattr_set_handler_table(&reply_epattr,
					 comm_test_reply_handler_table,
					 COMM_TEST_REPLY_HANDLER_TABLE_SIZE);
    globus_nexus_endpointattr_set_unknown_handler(&reply_epattr,
					   unknown_handler,
					   GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED);
    globus_nexus_endpoint_init(&reply_ep, &reply_epattr);
    globus_nexus_endpoint_set_user_pointer(&reply_ep,
				    (void *)&comm_test_reply_done);
   
    globus_nexus_proto_info_udp_init(&udp_proto);


    nexus_endpointattr_set_protocol(&reply_epattr,
                                    GLOBUS_NEXUS_PROTO_TYPE_UDP,
                                    &udp_proto,
                                    sizeof(udp_proto));

    globus_nexus_startpoint_bind(&reply_sp, &reply_ep);

    /*
     * Test nexus_startpoint_*() equality functions
     */
    if (globus_nexus_startpoint_to_current_context(&reply_sp))
    {
	globus_nexus_endpoint_t *tmp_ep;
	globus_libc_printf("comm_test(): globus_nexus_startpoint_to_current_context() works\n");
	globus_nexus_startpoint_get_endpoint(&reply_sp, &tmp_ep);
	if (tmp_ep && (tmp_ep == &reply_ep))
	{
	    globus_libc_printf("comm_test(): globus_nexus_startpoint_get_endpoint() works\n");
	}
	else
	{
	    globus_libc_printf("comm_test(): ERROR: globus_nexus_startpoint_get_endpoint() failed\n");
	}
    }
    else
    {
	globus_libc_printf("comm_test(): ERROR: globus_nexus_startpoint_to_current_context() failed\n");
    }
    
    /*
     * Do the RSR
     */
    buf_size = globus_nexus_sizeof_startpoint(&reply_sp, 1);
    buf_size += globus_nexus_sizeof_int(1);
    globus_nexus_buffer_init(&buffer, buf_size, 0);
    globus_nexus_put_startpoint_transfer(&buffer, (&reply_sp), 1);
    globus_nexus_put_int(&buffer, &comm_test_int_data, 1);

    globus_libc_printf("comm_test(): sending rsr\n");
    if (globus_nexus_send_rsr(&buffer,
		       remote_sp,
		       COMM_TEST_REMOTE_HANDLER_ID,
		       GLOBUS_TRUE,
		       GLOBUS_FALSE) != GLOBUS_SUCCESS)
    {
	globus_libc_printf("comm_test(): WARNING: send failed\n");
    }

    globus_nexus_startpoint_flush(remote_sp);
    if(!globus_i_nexus_get_host_port_pairs(
           remote_sp,
           localhost,
           &localport,
           remotehost,
           &remoteport))
    {
        globus_libc_printf("@@@@@ **ERROR**\n");
    }

    globus_libc_printf("@@@@@@@@@ lh=%s lp=%d rh=%s rp=%d\n", 
                       localhost, localport, remotehost, remoteport);

#ifdef ATTACH_COMM_TEST
    /*
     * Die (exit) unexpectedly to test fault tolerance
     */
    if (attach_client_die)
    {
	globus_libc_printf("comm_test(): client simulating death\n");
	exit(0);
    }
#endif /* ATTACH_COMM_TEST */

    /*
     * Suspend main thread until handler completes
     */
    globus_libc_printf("comm_test(): entering monitor\n");
    globus_mutex_lock(&(comm_test_reply_done.mutex));
    globus_libc_printf("comm_test(): waiting on monitor\n");
    while (!comm_test_reply_done.done)
    {
	globus_cond_wait(&(comm_test_reply_done.cond),
			&(comm_test_reply_done.mutex));
    }
    globus_libc_printf("comm_test(): awoke from monitor and exiting\n");
    globus_mutex_unlock(&(comm_test_reply_done.mutex));

    globus_mutex_destroy(&(comm_test_reply_done.mutex));
    globus_cond_destroy(&(comm_test_reply_done.cond));
    globus_nexus_startpoint_destroy(&reply_sp);
    globus_nexus_endpoint_destroy(&reply_ep);
    globus_nexus_endpointattr_destroy(&reply_epattr);
    
    globus_libc_printf("comm_test(): complete\n");
    
} /* comm_test() */


/*
 * comm_test_remote_handler()
 */
static void comm_test_remote_handler(globus_nexus_endpoint_t *endpoint,
				 globus_nexus_buffer_t *buffer,
				 globus_bool_t called_from_non_threaded_handler)
{
    int int_data;
    globus_nexus_startpoint_t reply_sp;
    globus_nexus_buffer_t reply_buffer;
    
    globus_libc_printf("comm_test_remote_handler(): entering\n");

    /* Get the reply global pointer */
    globus_nexus_get_startpoint(buffer, &reply_sp, 1);
    
    /* Test nexus_startpoint_*() equality functions */
    globus_libc_printf("comm_test(): globus_nexus_startpoint_to_current_context(&reply_sp)==%s (should be TRUE for local_comm_test(), and FALSE for attach_comm_test(), and depentent upon the context for gram_myjob_comm_test())\n", (globus_nexus_startpoint_to_current_context(&reply_sp) ? "TRUE" : "FALSE"));
    
    /* Get the data and check to see if it made it ok */
    globus_nexus_get_int(buffer, &int_data, 1);
    if (int_data == comm_test_int_data)
    {
	globus_libc_printf("comm_test_remote_handler(): got int_data ok\n");
    }
    else
    {
	globus_libc_printf("comm_test_remote_handler(): ERROR: bad int_data %d, should be %d\n",
		     int_data, comm_test_int_data);
    }

    if (!called_from_non_threaded_handler)
    {
        globus_libc_printf("comm_test_remote_handler(): freeing saved buffer\n");
	globus_nexus_buffer_destroy(buffer);
    }
    
    /* Reply to the original context */
    globus_libc_printf("comm_test_remote_handler(): sending reply rsr\n");
    globus_nexus_buffer_init(&reply_buffer, 0, 0);
    if (globus_nexus_send_rsr(&reply_buffer,
		       &reply_sp,
		       COMM_TEST_REPLY_HANDLER_ID,
		       GLOBUS_TRUE,
		       called_from_non_threaded_handler) != GLOBUS_SUCCESS)
    {
	globus_libc_printf("comm_test_remote_handler(): WARNING: send failed\n");
	globus_libc_printf("comm_test_remote_handler(): globus_nexus_startpoint_test()=%d\n",
		     globus_nexus_startpoint_test(&reply_sp));
    }

} /* comm_test_remote_handler() */


/*
 * comm_test_reply_handler()
 */
static void comm_test_reply_handler(globus_nexus_endpoint_t *endpoint,
				 globus_nexus_buffer_t *buffer,
				 globus_bool_t called_from_non_threaded_handler)
{
    struct _comm_test_reply_done_t *reply_done;
    void *address;
    
    globus_libc_printf("comm_test_reply_handler(): entering\n");

    address = globus_nexus_endpoint_get_user_pointer(endpoint);
    /* The address should be to the comm_test_reply_done structure */
    if (address == (void *) (&comm_test_reply_done))
    {
	reply_done = (comm_test_reply_done_t *) address;
	globus_libc_printf("comm_test_reply_handler(): address ok\n");
    }
    else
    {
	reply_done = &comm_test_reply_done;
	globus_libc_printf("comm_test_reply_handler(): ERROR: bad address %x, should be %x\n",
		     address,
		     (&comm_test_reply_done));
    }
    
    /* Awaken the main thread */
    globus_libc_printf("comm_test_reply_handler(): entering monitor\n");
    globus_mutex_lock(&(reply_done->mutex));
    reply_done->done = GLOBUS_TRUE;
    globus_libc_printf("comm_test_reply_handler(): signaling monitor\n");
    globus_cond_signal(&(reply_done->cond));
    globus_mutex_unlock(&(reply_done->mutex));
   
    globus_libc_printf("comm_test_reply_handler(): exiting\n");

} /* comm_test_reply_handler() */



typedef struct
{
    globus_mutex_t	mutex;
    globus_cond_t	cond;
    globus_bool_t	done;
} comm_test_finish_monitor_t;

static comm_test_finish_monitor_t comm_test_finish_monitor;

/*
 * comm_test_finish_init()
 */
static void comm_test_finish_init()
{
    globus_mutex_init(&(comm_test_finish_monitor.mutex),
		     (globus_mutexattr_t *) NULL);
    globus_cond_init(&(comm_test_finish_monitor.cond),
		    (globus_condattr_t *) NULL);
    comm_test_finish_monitor.done = GLOBUS_FALSE;
} /* comm_test_finish_init() */


/*
 * comm_test_finish_destroy()
 */
static void comm_test_finish_destroy()
{
    globus_mutex_destroy(&(comm_test_finish_monitor.mutex));
    globus_cond_destroy(&(comm_test_finish_monitor.cond));
} /* comm_test_finish_destroy() */


/*
 * comm_test_finish_wait()
 */
static void comm_test_finish_wait()
{
    globus_libc_printf("comm_test_finish_wait(): waiting on monitor\n");
    globus_mutex_lock(&(comm_test_finish_monitor.mutex));
    while (!(comm_test_finish_monitor.done))
    {
	globus_cond_wait(&(comm_test_finish_monitor.cond),
			&(comm_test_finish_monitor.mutex));
    }
    globus_mutex_unlock(&(comm_test_finish_monitor.mutex));
    globus_libc_printf("comm_test_finish_wait(): awoke from monitor\n");
} /* comm_test_finish_wait() */


/*
 * comm_test_finish_send()
 */
static void comm_test_finish_send(globus_nexus_startpoint_t *sp)
{
    globus_nexus_buffer_t buffer;
    
    globus_libc_printf("comm_test_finish_send(): sending finish message\n");
    
    globus_nexus_buffer_init(&buffer, 0, 0);
    if (globus_nexus_send_rsr(&buffer, sp,
		       COMM_TEST_FINISH_HANDLER_ID,
		       GLOBUS_TRUE, GLOBUS_FALSE) != 0)
    {
	globus_libc_printf("comm_test_finish_send(): WARNING: send failed\n");
    }
} /* comm_test_finish_send() */


/*
 * comm_test_finish_handler()
 */
static void comm_test_finish_handler(globus_nexus_endpoint_t *endpoint,
				 globus_nexus_buffer_t *buffer,
				 globus_bool_t called_from_non_threaded_handler)
{
    globus_libc_printf("comm_test_finish_handler(): signaling\n");
    globus_mutex_lock(&(comm_test_finish_monitor.mutex));
    comm_test_finish_monitor.done = GLOBUS_TRUE;
    globus_cond_signal(&(comm_test_finish_monitor.cond));
    globus_mutex_unlock(&(comm_test_finish_monitor.mutex));
    globus_libc_printf("comm_test_finish_handler(): done signaling\n");
} /* comm_test_finish_handler() */

#endif /* COMM_TEST */



/*****************************************************************
 *		LOCAL_COMM_TEST
 *****************************************************************/
#ifdef LOCAL_COMM_TEST

/*
 * local_comm_test()
 */
static void local_comm_test(void)
{
    globus_nexus_endpointattr_t epattr;
    globus_nexus_endpoint_t ep;
    globus_nexus_startpoint_t sp;
    
    globus_libc_printf("local_comm_test(): starting\n");

    globus_nexus_endpointattr_init(&epattr);
    globus_nexus_endpointattr_set_handler_table(&epattr,
					 comm_test_remote_handler_table,
					 COMM_TEST_REMOTE_HANDLER_TABLE_SIZE);
    globus_nexus_endpointattr_set_unknown_handler(&epattr,
					   unknown_handler,
					   GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED);
    globus_nexus_endpoint_init(&ep, &epattr);
    globus_nexus_startpoint_bind(&sp, &ep);
    
    comm_test(&sp);
    
    globus_nexus_startpoint_destroy(&sp);
    globus_nexus_endpoint_destroy(&ep);
    globus_nexus_endpointattr_destroy(&epattr);
    
    globus_libc_printf("local_comm_test(): complete\n");
} /* local_comm_test() */

#endif /* LOCAL_COMM_TEST */



/*****************************************************************
 *		GRAM_MYJOB_COMM_TEST
 *****************************************************************/
#ifdef GRAM_MYJOB_COMM_TEST

/*
 * gram_myjob_comm_test()
 */
static void gram_myjob_comm_test(void)
{
    globus_nexus_endpointattr_t epattr;
    globus_nexus_endpoint_t ep;
    globus_nexus_startpoint_t sp;
    int rc;
    int job_size;
    int rank;
    globus_byte_t array[GLOBUS_GRAM_MYJOB_MAX_BUFFER_LENGTH];
    globus_byte_t *a;
    int length;
    
    globus_libc_printf("gram_myjob_comm_test(): starting\n");

    /* Initialize gram_myjob */
    if ((rc = globus_module_activate(GLOBUS_GRAM_MYJOB_MODULE)) != GLOBUS_SUCCESS)
    {
	globus_libc_printf("gram_myjob_comm_test(): ERROR: globus_module_activate() returned %d\n", rc);
	return;
    }

    /* Get my rank and the job size */
    if ((rc = globus_gram_myjob_size(&job_size)) != GLOBUS_GRAM_MYJOB_SUCCESS)
    {
	globus_libc_printf("gram_myjob_comm_test(): ERROR: globus_gram_myjob_size() returned %d\n", rc);
	goto done;
    }
    if ((rc = globus_gram_myjob_rank(&rank)) != GLOBUS_GRAM_MYJOB_SUCCESS)
    {
	globus_libc_printf("gram_myjob_comm_test(): ERROR: globus_gram_myjob_rank() returned %d\n", rc);
	goto done;
    }
    globus_libc_printf("gram_myjob_comm_test(): size=%d, rank=%d\n", job_size, rank);

    /* Create an endpoint */
    globus_nexus_endpointattr_init(&epattr);
    globus_nexus_endpointattr_set_handler_table(&epattr,
					 comm_test_remote_handler_table,
					 COMM_TEST_REMOTE_HANDLER_TABLE_SIZE);
    globus_nexus_endpointattr_set_unknown_handler(&epattr,
					   unknown_handler,
					   GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED);
    globus_nexus_endpoint_init(&ep, &epattr);

    if (rank == 0)
    {
	globus_nexus_startpoint_t *sp_array;
	int format;
	int source;
	int i;

	sp_array = (globus_nexus_startpoint_t *)
	    globus_malloc(sizeof(globus_nexus_startpoint_t) * job_size);

	globus_nexus_startpoint_bind(&(sp_array[0]), &ep);
	
	for (i = 1; i < job_size; i++)
	{
	    globus_libc_printf("gram_myjob_comm_test(): Calling globus_gram_myjob_receive()\n");
	    if ((rc = globus_gram_myjob_receive(array, &length)) != GLOBUS_GRAM_MYJOB_SUCCESS)
	    {
		globus_libc_printf("gram_myjob_comm_test(): ERROR: globus_gram_myjob_send() returned %d\n", rc);
		goto done;
	    }
	    globus_libc_printf("gram_myjob_comm_test(): globus_gram_myjob_receive() returned length=%d\n", length);
	    
	    a = array;
	    format = (int) (*a++);
	    globus_nexus_user_get_int(&a, &source, 1, format);
	    if (source < 1 || source >= job_size)
	    {
		globus_libc_printf("gram_myjob_comm_test(): ERROR: got invalid source = %d\n", source);
		globus_module_deactivate(GLOBUS_GRAM_MYJOB_MODULE);
		exit(1);
	    }
	    globus_nexus_user_get_startpoint(&a, &(sp_array[source]), 1, format);
	    globus_libc_printf("gram_myjob_comm_test(): Got startpoint()\n");
	}

	/* Shutdown gram_myjob */
	globus_module_deactivate(GLOBUS_GRAM_MYJOB_MODULE);

	for (i = 0; i < job_size; i++)
	{
	    globus_libc_printf("gram_myjob_comm_test(): running comm_test() to job process %d\n", i);
	    comm_test(&(sp_array[i]));
	}

	
	globus_nexus_startpoint_destroy(&(sp_array[0]));
	for (i = 1; i < job_size; i++)
	{
	    globus_libc_printf("gram_myjob_comm_test(): shutting down job process %d\n", i);
	    comm_test_finish_send(&(sp_array[i]));
	    globus_nexus_startpoint_destroy(&(sp_array[i]));
	}

    }
    else
    {
	comm_test_finish_init();

	/* Send a startpoint to rank 0 */
	globus_nexus_startpoint_bind(&sp, &ep);
	a = array;
	*a++ = (globus_byte_t) globus_nexus_user_format();
	globus_nexus_user_put_int(&a, &rank, 1);
	globus_nexus_user_put_startpoint_transfer(&a, &sp, 1);
	length = a - array;
	
	globus_libc_printf("gram_myjob_comm_test(): globus_gram_myjob_send() sending length=%d\n", length);
	if ((rc = globus_gram_myjob_send(0, array, length)) != GLOBUS_GRAM_MYJOB_SUCCESS)
	{
	    globus_libc_printf("gram_myjob_comm_test(): ERROR: globus_gram_myjob_send() returned %d\n", rc);
	    goto done;
	}

	/* Shutdown gram_myjob */
	globus_module_deactivate(GLOBUS_GRAM_MYJOB_MODULE);

	/* Wait for the communication test to complete */
	comm_test_finish_wait();
	comm_test_finish_destroy();
    }

    globus_nexus_endpoint_destroy(&ep);
    globus_nexus_endpointattr_destroy(&epattr);
    
    globus_libc_printf("gram_myjob_comm_test(): complete\n");

    return;
    
  done:
    globus_module_deactivate(GLOBUS_GRAM_MYJOB_MODULE);
    
} /* gram_myjob_comm_test() */

#endif /* GRAM_MYJOB_COMM_TEST */



/*****************************************************************
 *		ATTACH_COMM_TEST
 *****************************************************************/
#ifdef ATTACH_COMM_TEST

/*
 * attach_requested()
 */
int attach_requested(void *user_arg, char *url, globus_nexus_startpoint_t *sp)
{
    globus_nexus_endpoint_t *ep = (globus_nexus_endpoint_t *) user_arg;
    char *host;
    unsigned short port;
    char **specs;
    int i;
    
    globus_libc_printf("attach_requested(): entering\n");
    globus_libc_printf("attach_requested(): url=\"%s\"(run-tests-ignore)\n", url);

    globus_nexus_split_url(url, &host, &port, &specs);
    globus_libc_printf("attach_requested(): host=\"%s\"(run-tests-ignore)\n", host);
    globus_libc_printf("attach_requested(): port=\"%hu\"(run-tests-ignore)\n", port);
    for (i = 0; specs[i]; i++)
    {
	globus_libc_printf("attach_requested(): spec %d: <%s>\n", i, specs[i]);
    }
    globus_nexus_split_url_free(&host, &specs);

    globus_nexus_startpoint_bind(sp, ep);
    
    globus_libc_printf("attach_requested(): exiting\n");
    return(0);
} /* attach_requested() */


/*
 * attach_server()
 */
static void attach_server(void)
{
    globus_nexus_endpointattr_t epattr;
    globus_nexus_endpoint_t ep;
    globus_nexus_startpoint_t sp;
    unsigned short port;
    char *host, *host2;
    int rc;
    
    globus_libc_printf("attach_server(): entering\n");

    /*
     * Create an endpoint that will be used for attachments
     */
    globus_nexus_endpointattr_init(&epattr);
    globus_nexus_endpointattr_set_handler_table(&epattr,
					 comm_test_remote_handler_table,
					 COMM_TEST_REMOTE_HANDLER_TABLE_SIZE);
    globus_nexus_endpointattr_set_unknown_handler(&epattr,
					   unknown_handler,
					   GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED);
    globus_nexus_endpoint_init(&ep, &epattr);

    comm_test_finish_init();
    
    globus_libc_printf("attach_server(): allowing attachment\n");
    port = 0;
    if ((rc = globus_nexus_allow_attach(&port, &host,
				 &attach_requested,
				 (void *) &ep)) != 0)
    {
	globus_libc_printf("ERROR: globus_nexus_allow_attach() returned non-0: rc=%d\n",
		     rc);
    }
    if ((rc = globus_nexus_allow_attach(&port, &host2, &attach_requested, NULL)) != 1)
    {
	globus_libc_printf("ERROR: second globus_nexus_allow_attach() did not return 1: rc=%d\n\n", rc);
    }
    
    globus_libc_printf("attach_server(): ATTACH TO: \"x-nexus://%s:%hu\"(run-tests-ignore)\n",
		 host, port);

    globus_libc_lock();
    fflush(stdout);
    globus_libc_unlock();

    comm_test_finish_wait();
    
    globus_nexus_disallow_attach(port);

    comm_test_finish_destroy();
    globus_nexus_endpoint_destroy(&ep);
    globus_nexus_endpointattr_destroy(&epattr);

    globus_libc_printf("attach_server(): exiting\n");
    
} /* attach_server() */


/*
 * attach_client()
 */
static void attach_client(void)
{
    char url[1024];
    globus_nexus_startpoint_t sp;
    globus_nexus_buffer_t buffer;
    int rc;

    globus_libc_printf("attach_client(): entering\n");

    globus_nexus_enable_fault_tolerance(fault_callback, NULL);

    sprintf(url, "%s/spec1//spec\\/3/spec4", attach_client_url);

    globus_libc_printf("attach_client(): attaching to url <%s>(run-tests-ignore)\n", url);
    rc = globus_nexus_attach(url, &sp);
    if (rc == 0)
    {
	globus_libc_printf("attach_client(): running comm_test() to server\n");
	comm_test(&sp);
	globus_libc_printf("attach_client(): done running comm_test() to server\n");

	if (!attach_client_leave_server)
	{
	    /* Send rsr to shut the server down */
	    comm_test_finish_send(&sp);
	}

	globus_nexus_startpoint_destroy(&sp);
    }
    else
    {
	globus_libc_printf("attach_client(): ERROR: globus_nexus_attach() failed with rc=%d\n", rc);
    }
    
    globus_libc_printf("attach_client(): exiting\n");
    
} /* attach_client() */

#endif /* ATTACH_COMM_TEST */


/*****************************************************************
 *		TIME_GLOBUS_POLL
 *****************************************************************/
#ifdef TIME_GLOBUS_POLL

#define TIME_GLOBUS_POLL_ITERS 10000

/*
 * time_globus_poll()
 */
static void time_globus_poll(void)
{
    double start, stop, elapse;
    int i;

    globus_libc_printf("time_globus_poll(): starting\n");

    start = globus_nexus_wallclock();
    for (i = 0; i < TIME_GLOBUS_POLL_ITERS; i++)
    {
	globus_poll();
    }
    stop = globus_nexus_wallclock();
    elapse = stop - start;
    globus_libc_printf("time_globus_poll(): iters=%d, elapse=%f, elapse/iters=%f\n",
		 TIME_GLOBUS_POLL_ITERS,
		 elapse, 
		 (elapse/TIME_GLOBUS_POLL_ITERS) );
    
    globus_libc_printf("time_globus_poll(): complete\n");
} /* time_globus_poll() */

#endif /* TIME_GLOBUS_POLL */
