/*
 * startup.h
 */

#ifndef STARTUP_H
#define STARTUP_H

#include <nexus.h>
#include "cmd_line.h"
#include "sp_list.h"
#include "test_harness.h"

/*
 * startup_init()
 *
 * Must be called first.
 *	o Start Nexus
 *	o Create endpoint
 */
int startup_init(int *argc, char ***argv);

/*
 * startup_local()
 *
 * Master waits for startpoints.
 * Slaves send single copy for master.
 *
 * sp_list is filled in for master.
 */
int startup_local(int *argc, char ***argv,
		  sp_list_t *sp_list,
		  int local_dbg_lvl,
		  int test_dbg_lvl);

/*
 * startup_listen()
 *
 * Waits for n_attaches to occur, 
 * returns with sp_list filled in.
 */
int startup_listen(int n_attaches,
		   sp_list_t *sp_list,
		   int global_dbg_lvl,
		   int test_dbg_lvl);

/*
 * startup_attach()
 *
 * Connect to the url and send the list of sps.
 */
int startup_attach(char *url,
		   sp_list_t *sp_list);

/*
 * startup_done()
 *
 * On master, sp_list will be moved to sp_group[HARNESS_GROUP_ID].
 * Internal startup stuff will be cleaned up.
 */
void startup_done(sp_list_t *sp_list);

#endif
