/*
 * sp_group.h
 *
 * 
 */

#ifndef SP_GROUP_H
#define SP_GROUP_H

#include "globus_nexus.h"
#include "harness_options.h"
#include "sp_list.h"
#include "ep_list.h"

/*
 * sp_group_startup()
 * sp_group_shutdown()
 */
int sp_group_startup();
void sp_group_shutdown(int aborted);

/*
 * sp_group_size()
 * sp_group_rank()
 * sp_group_sp()
 *
 * Get the size, rank, or an SP.
 */
int sp_group_size(int group_id);
int sp_group_rank(int group_id);
globus_nexus_startpoint_t *sp_group_sp(int group_id, int sp_num);

/*
 * sp_group_bootstrap()
 *
 * This gives the startup code a way to set the initial
 * startpoints for the harness group.  The slaves' lists
 * will contain only 1 startpoint (to the master), while
 * the master will have a complete list.  This is enough
 * for sp_group_create() to complete the first group.
 */
int sp_group_bootstrap(int group_id, int ep_id,
		       int size, int rank,
		       sp_list_t *sp_list);

/*
 * sp_group_create()
 *
 * Must be called from main thread.  When it returns, the group
 * is ready for use.
 *
 * master : initiates distribution
 * ep_id  : which endpoint?
 * who    : which nodes? NULL => all
 *                       list ended by -1 => subset (not implemented)
 */
int sp_group_create(int master, int ep_id, int *who);
int sp_group_delete(int gr_id);

globus_nexus_startpoint_t **sp_group_list(int gr_id);
			   
#endif
