/*
 * null_test.c
 */

#include "globus_nexus.h"

#undef PrintHooks
#define Generic_TestParams	\
globus_mutex_t	mutex;		\
globus_cond_t	cond;		\
volatile int	done;		\
int		trips;

#include "generic_test.h"

#define Generic_CleanupEpFunc(ep)

#define Generic_UsageString()				\
	pingpong_usage()

#define Generic_Startup()				\
	(0)

#define Generic_ParseOptions(arg_list)			\
	pingpong_parse_options(arg_list)

#define Generic_TestInit(options, test_params)		\
	pingpong_init(options, test_params)

#define Generic_TestRun_BegRep(test_params)

#define Generic_TestRun_Once(test_params, dest)		\
	pingpong_once(test_params, dest)

#define Generic_TestRun_EndRep(test_params)

#define Generic_TestDone(test_params)			\
	pingpong_done(test_params)

#define Generic_Cleanup()

#define Generic_HandlerTable				\
{ GLOBUS_NEXUS_HANDLER_TYPE_NON_THREADED, pingpong_handler	}

#define PINGPONG_HANDLER_ID		0
/*
 * int	src
 * int	dst
 * int	seq
 * int	ttl
 */

/*
 *
 */

static void
pingpong_usage()
{
    printf("    PingPong test:\n"
	   "\ttrips=<n>\t\tnumber of round trips\n"
	   "\t\t\t\t\t0 = one way (1)\n");
}

static int
pingpong_parse_options(arg_list_t *arg_list)
{
    int		trips;
    static char	tmp_buf[20];

    parse_option(arg_list, "trips", "%i", "1", (char *) &trips);
    if (trips < 0) trips = 0;
    sprintf(tmp_buf, "trips=%i", trips);
    add_option_str(tmp_buf);

    return 0;
}

static void
pingpong_init(char *options, test_params_t *tp)
{
    if (sscanf(options, "trips=%i", &tp->trips) != 1)
    {
	globus_libc_printf("pingpong_init(): bad option string '%s'\n",
		     options);
	harness_abort();
    }
    if ((tp->reliable_proto == GLOBUS_FALSE) &&
	(tp->trips > 0))
	globus_libc_printf("pingpong_init(): warning! unreliable proto\n");
    if (globus_mutex_init(&(tp->mutex), NULL) != GLOBUS_SUCCESS) {
	globus_libc_printf("pingpong_init(): mutex_init failed\n");
	harness_abort();
    }
    if (globus_cond_init(&(tp->cond), NULL) != GLOBUS_SUCCESS) {
	globus_libc_printf("pingpong_init(): cond_init failed\n");
	harness_abort();
    }
    tp->done = GLOBUS_FALSE;
    globus_nexus_endpoint_set_user_pointer(tp->endpoint, (void *) tp);
}

static void
pingpong_once(test_params_t *tp, int dest)
{
    globus_nexus_buffer_t	buffer;
    int			seq, ttl;

    if (globus_nexus_buffer_init(&buffer, 4 * globus_nexus_sizeof_int(1), 0)
	!= GLOBUS_SUCCESS) {
	globus_libc_printf("pingpong_once(): buffer init failed\n");
	harness_abort();
    }
    seq = 23;
    if (tp->trips == 0)
	ttl = -1;
    else
	ttl = (tp->trips * 2) - 1;
    globus_nexus_put_int(&buffer, &(tp->rank), 1);
    globus_nexus_put_int(&buffer, &dest, 1);
    globus_nexus_put_int(&buffer, &seq, 1);
    globus_nexus_put_int(&buffer, &ttl, 1);
    if (globus_nexus_send_rsr(&buffer,
		       tp->sp_list[dest],
		       PINGPONG_HANDLER_ID,
		       GLOBUS_TRUE, GLOBUS_FALSE)
	!= GLOBUS_SUCCESS) {
	globus_libc_printf("pingpong_once(): send_rsr failed\n");
	harness_abort();
    }
    if (ttl > 0) {
	if (tp->debug_level > 1)
	    globus_libc_printf("pingpong_once(): %i blocking\n",
			 tp->rank);
	globus_mutex_lock(&(tp->mutex));
	while (tp->done == GLOBUS_FALSE)
	    globus_cond_wait(&(tp->cond), &(tp->mutex));
	tp->done = GLOBUS_FALSE;
	globus_mutex_unlock(&(tp->mutex));
	if (tp->debug_level > 1)
	    globus_libc_printf("pingpong_once(): %i awake\n",
			 tp->rank);
    }
}

static void
pingpong_done(test_params_t *tp)
{
    globus_mutex_destroy(&(tp->mutex));
    globus_cond_destroy(&(tp->cond));
}

/*
 *
 */
static void
pingpong_handler(globus_nexus_endpoint_t *endpoint,
		 globus_nexus_buffer_t *buffer,
		 globus_bool_t is_non_threaded_handler)
{
    globus_nexus_buffer_t	reply_buf;
    test_params_t	*tp;
    int			src, dst, seq, ttl;

    tp = (test_params_t *) globus_nexus_endpoint_get_user_pointer(endpoint);
    globus_nexus_get_int(buffer, &src, 1);
    globus_nexus_get_int(buffer, &dst, 1);
    globus_nexus_get_int(buffer, &seq, 1);
    globus_nexus_get_int(buffer, &ttl, 1);
    if (dst != tp->rank)
	globus_libc_printf("pingpong_handler(): %i rcvd from %i, "
		     "dst=%i\n", tp->rank, dst, src);
    if (ttl == -1) {
	if (tp->debug_level > 1)
	    globus_libc_printf("pingpong_handler(): %i rcvd from %i, "
			 "one way\n", dst, src);
    } else if (ttl > 0) {
	if (tp->debug_level == 3)
	    globus_libc_printf("pingpong_handler(): %i rcvd from %i, "
			 "replying\n", dst, src);
	if (globus_nexus_buffer_init(&reply_buf, 4 * globus_nexus_sizeof_int(1), 0)
	    != GLOBUS_SUCCESS) {
	    globus_libc_printf("pingpong_handler(): buffer_init failed\n");
	    harness_abort();
	}
	ttl--;
	globus_nexus_put_int(&reply_buf, &dst, 1);
	globus_nexus_put_int(&reply_buf, &src, 1);
	globus_nexus_put_int(&reply_buf, &seq, 1);
	globus_nexus_put_int(&reply_buf, &ttl, 1);
	if (globus_nexus_send_rsr(&reply_buf,
			   tp->sp_list[src],
			   PINGPONG_HANDLER_ID,
			   GLOBUS_TRUE, is_non_threaded_handler)
	    != GLOBUS_SUCCESS) {
	    globus_libc_printf("pingpong_handler(): send_rsr failed\n");
	    harness_abort();
	}
    } else {
	if (tp->debug_level > 1)
	    globus_libc_printf("pingpong_handler(): %i rcvd from %i, "
			 "signalling\n", dst, src);
	globus_mutex_lock(&(tp->mutex));
	tp->done = GLOBUS_TRUE;
	globus_cond_signal(&(tp->cond));
	globus_mutex_unlock(&(tp->mutex));
    }
}
	    
#include "generic_test.c"
