/*
 * harness_options.h
 */

#ifndef HARNESS_OPTIONS_H
#define HARNESS_OPTIONS_H

/* */

#define MAX_N_ENDPOINTS		2
#define MAX_N_GROUPS		2
#define MAX_N_BARRIERS		2

#define HARNESS_GROUP_ID	0
#define A_TEST_GROUP_ID		1

#define HARNESS_ENDPOINT_ID	0
#define A_TEST_ENDPOINT_ID	1

#define HARNESS_BARRIER_ID	0
#define A_TEST_BARRIER_ID	1

/*
 * Debug stuff
 */

/* #define DEBUG_STARTUP */
/* #define DEBUG_EP_LIST */
/* #define DEBUG_SP_GROUP */
/* #define DEBUG_BARRIER */
/* #define DEBUG_TEST_HARNESS */

/* #define SKIP_CHECKS */

/*
 * harness_debug_level()
 * harness_set_debug_level()
 *
 * Defined in test_harness.c
 * Setting the level will only increase it.
 */
int harness_debug_level();
void harness_set_debug_level(int harness, int test);

/*
 * debug output
 *
 * HelloXX -> major state transitions
 * TraceXX -> minor state transitions, send_rsr's, mutex_lock's
 * DebugXX -> everything else
 */

/* startup.c */
#ifdef DEBUG_STARTUP
#  define HelloStu(x)	if (harness_debug_level() > 0) x
#  define TraceStu(x)	if (harness_debug_level() > 1) x
#  define DebugStu(x)	if (harness_debug_level() > 2) x
#else
#  define HelloStu(x)
#  define TraceStu(x)
#  define DebugStu(x)
#endif

/* ep_list.c */
#ifdef DEBUG_EP_LIST
#  define HelloEpl(x)	if (harness_debug_level() > 0) x
#  define TraceEpl(x)	if (harness_debug_level() > 1) x
#  define DebugEpl(x)	if (harness_debug_level() > 2) x
#else
#  define HelloEpl(x)
#  define TraceEpl(x)
#  define DebugEpl(x)
#endif

/* sp_group.c */
#ifdef DEBUG_SP_GROUP
#  define HelloSpg(x)	if (harness_debug_level() > 0) x
#  define TraceSpg(x)	if (harness_debug_level() > 1) x
#  define DebugSpg(x)	if (harness_debug_level() > 2) x
#else
#  define HelloSpg(x)
#  define TraceSpg(x)
#  define DebugSpg(x)
#endif

/* barrier.c */
#ifdef DEBUG_BARRIER
#  define HelloBar(x)	if (harness_debug_level() > 0) x
#  define TraceBar(x)	if (harness_debug_level() > 1) x
#  define DebugBar(x)	if (harness_debug_level() > 2) x
#else
#  define HelloBar(x)
#  define TraceBar(x)
#  define DebugBar(x)
#endif

/* test_harness.c */
#ifdef DEBUG_TEST_HARNESS
#  define HelloTst(x)	if (harness_debug_level() > 0) x
#  define TraceTst(x)	if (harness_debug_level() > 1) x
#  define DebugTst(x)	if (harness_debug_level() > 2) x
#else
#  define HelloTst(x)
#  define TraceTst(x)
#  define DebugTst(x)
#endif

#endif
