/*
 * harness_endpoint.h
 */

#ifndef HARNESS_ENDPOINT_H
#define HARNESS_ENDPOINT_H

#include "globus_nexus.h"

/*
 * startup/shutdown stuff
 *
 * startup.c
 */
#define ATTACH_STARTPOINTS_HANDLER_ID	0
void attach_startpoints_handler(globus_nexus_endpoint_t *endpoint,
				globus_nexus_buffer_t *buffer,
				globus_bool_t non_threaded_handler);
	/*
	 *	sp_list
	 */

#define HARNESS_STARTUP_HANDLER_ID	1
void startup_handler(globus_nexus_endpoint_t *endpoint,
		     globus_nexus_buffer_t *buffer,
		     globus_bool_t non_threaded_handler);
	/*
	 * int	size
	 * int	rank
	 * sp	master
	 */

#define HARNESS_SHUTDOWN_HANDLER_ID	2
void shutdown_handler(globus_nexus_endpoint_t *endpoint,
		      globus_nexus_buffer_t *buffer,
		      globus_bool_t non_threaded_handler);
	/*
	 * int	sayswho
	 * int	reason
	 */
#define SHUTDOWN_ABORT		0
#define SHUTDOWN_ALLDONE	1

/*
 * startpoint distribution stuff
 *
 * distrib.c
 */
#define REQUEST_SP_COPIES_HANDLER_ID	3
void request_sp_copies_handler(globus_nexus_endpoint_t *endpoint,
			       globus_nexus_buffer_t *buffer,
			       globus_bool_t is_non_threaded_handler);
	/*
	 * int	reply_to
	 * int	endpoint_id
	 * int	group_id
	 * int	rank
	 * int	n_copies
	 */

#define COLLECT_SP_COPIES_HANDLER_ID	4
void collect_sp_copies_handler(globus_nexus_endpoint_t *endpoint,
			       globus_nexus_buffer_t *buffer,
			       globus_bool_t is_non_threaded_handler);
	/*
	 * int	sender_rank
	 * int	group_id	XXX
	 *	sp_list
	 */

#define SCATTER_SP_COPIES_HANDLER_ID	5
void scatter_sp_copies_handler(globus_nexus_endpoint_t *endpoint,
			       globus_nexus_buffer_t *buffer,
			       globus_bool_t is_non_threaded_handler);
	/*
	 * int	group_id
	 *	sp_list
	 */

/*
 * harness endpoint testing
 *
 * harness_endpoint.c
 */
#define PING_HANDLER_ID			6
void ping_handler(globus_nexus_endpoint_t *endpoint,
		  globus_nexus_buffer_t *buffer,
		  globus_bool_t is_non_threaded_handler);
	/*
	 * int	src
	 * int	dst
	 * int	ping_id
	 * int	ttl
	 */

/*
 * barrier
 */
#define BARRIER_HANDLER_ID		7
void barrier_handler(globus_nexus_endpoint_t *endpoint,
		     globus_nexus_buffer_t *buffer,
		     globus_bool_t is_non_threaded_handler);
	/*
	 * int	barrier_id
	 * int	sender_id
	 * int	receiver_id
	 * int	stage_count
	 * int	state
	 */

/*
 * pass option strings
 */
#define OPTION_STRING_HANDLER_ID	8
	/*
	 * int	opt_str_len
	 * char	opt_str
	 */
void option_string_handler(globus_nexus_endpoint_t *endpoint,
			   globus_nexus_buffer_t *buffer,
			   globus_bool_t is_non_threaded_handler);

/*
 * debug level, error code
 */
#define SET_DEBUG_LEVEL_HANDLER_ID	9
	/*
	 * int	harness_dbg_lvl
	 * int	test_dbg_lvl
	 * int	err_code
	 */
void set_debug_level_handler(globus_nexus_endpoint_t *endpoint,
			     globus_nexus_buffer_t *buffer,
			     globus_bool_t is_non_threaded_handler);

/*
 * harness_endpoint_init()
 */
int harness_endpoint_init();

/*
 * harness_send_ping()
 *
 * trips == 0 -> one-way
 * trips >= 1 -> #round trips
 */
void harness_send_ping(int dest, int trips,
		       globus_bool_t is_non_threaded_handler);

void harness_ping_test(int n_trips, int n_rounds);

#endif
