/*
 * ep_list.h
 */

#ifndef EP_LIST_H
#define EP_LIST_H

#include "globus_nexus.h"
#include "harness_options.h"

int ep_list_startup();
void ep_list_shutdown(int aborted);

/*
 * ep_list_new_ep()
 *
 * Add another endpoint to the list.
 * If non-NULL, cleanup_func will be called before the endpoint
 * is destroyed.
 * Set free_ep if the endpoint was dynamically allocated.
 */
int ep_list_new_ep(globus_nexus_endpoint_t *ep,
		   globus_bool_t free_ep,
		   void (*cleanup_func)(globus_nexus_endpoint_t *));

globus_nexus_endpoint_t *ep_list_get_ep(int ep_id);

void ep_list_destroy_ep(int ep_id);

#endif
