/*
 * ep_list.c
 */

#include "ep_list.h"
#include "harness_options.h"

typedef struct
{
    globus_nexus_endpoint_t	*endpoint;
    void			(*cleanup)(globus_nexus_endpoint_t *ep);
    int				free_ep;
} ep_info_t;

static ep_info_t	ep_list[MAX_N_ENDPOINTS];
static int		next_ep;

static int
unique_ep_id()
{
    int		e;

    e = next_ep++;
    if (e >= MAX_N_ENDPOINTS) {
	globus_libc_printf("ran out of endpoints!\n");
	next_ep--;
	return (-1);
    }
    return (e);
}

int
ep_list_startup()
{
    int	i;
    
    HelloEpl(globus_libc_printf("ep_list_startup(): hello\n"));
    next_ep = 0;
    for (i = 0; i < MAX_N_ENDPOINTS; i++) {
	ep_list[i].endpoint = NULL;
	ep_list[i].cleanup = NULL;
    }
    return (0);
}

void
ep_list_shutdown(int aborted)
{
    int		i;

    HelloEpl(globus_libc_printf("ep_list_shutdown(): hello\n"));
    for (i = 0; i < MAX_N_ENDPOINTS; i++)
	if (ep_list[i].endpoint != NULL) {
	    if (aborted == GLOBUS_FALSE)
		globus_libc_printf("warning: ep_list[%i] != NULL\n", i);
	    ep_list_destroy_ep(i);
	}
}

int
ep_list_new_ep(globus_nexus_endpoint_t *ep,
	       globus_bool_t free_ep,
	       void (*cleanup_func)(globus_nexus_endpoint_t *))
{
    int r = unique_ep_id();

    if (ep == NULL) {
	globus_libc_printf("ep_list_new_ep(): ep = NULL\n");
	return (1);
    }
    TraceEpl(globus_libc_printf("Adding endpoint[%i]\n", r));
    ep_list[r].endpoint = ep;
    ep_list[r].free_ep = free_ep;
    ep_list[r].cleanup = cleanup_func;
    return (r);
}

globus_nexus_endpoint_t *
ep_list_get_ep(int ep_id)
{
    if ((ep_id >= 0) && (ep_id < next_ep))
	return (ep_list[ep_id].endpoint);
    else {
	globus_libc_printf("FATAL ERROR: ep_list_get_ep(%i)\n", ep_id);
	globus_silent_fatal();
	return (NULL); /* don't get here */
    }
}

void
ep_list_destroy_ep(int ep_id)
{
    if ((ep_id < 0) || (ep_id >= next_ep) ||
	(ep_list[ep_id].endpoint == NULL)) {
	globus_libc_printf("FATAL ERROR: ep_list_delete(%i)\n", ep_id);
	globus_silent_fatal();
    } else {
	if (ep_list[ep_id].cleanup != NULL)
	    (ep_list[ep_id].cleanup)(ep_list[ep_id].endpoint);
	globus_nexus_endpoint_destroy(ep_list[ep_id].endpoint);
	if (ep_list[ep_id].free_ep != GLOBUS_FALSE)
	    globus_free(ep_list[ep_id].endpoint);
	ep_list[ep_id].endpoint = NULL;
	ep_list[ep_id].cleanup = NULL;
	ep_list[ep_id].free_ep = GLOBUS_FALSE;
    }
}
