/*
 * cmd_line.h
 */

#ifndef CMD_LINE_H
#define CMD_LINE_H

typedef struct
{
    int		argc;
    char	**argv;
} arg_list_t;

/*
 * arg_list_find()
 *
 * Searches the arg_list for first instance of "tag=xxx",
 * and returns a pointer to "xxx"; returns default if not
 * found.
 */
char *arg_list_find(arg_list_t *al, char *tag, char *def);

/*
 * split_cmd_line()
 *
 * First searches for --help; returns -1 if found
 * leading arguments are ignored, then:
 *	-debug
 *	-startup
 *	-selftest
 *	-testep
 *	-runtest (repeatable)
 *	-endtest (ignore rest of args)
 * may appear (must be in order).
 * return 0 for success, else the index of offending arg.
 */
int split_cmd_line(int	      argc,
		   char	      **argv,
		   arg_list_t *debug,
		   arg_list_t *startup,
		   arg_list_t *selftest,
		   arg_list_t *testep,
		   int	      *n_tests,
		   arg_list_t **test_list);

void arg_list_destroy(arg_list_t *al);

#endif
