/*
 * cmd_line.c
 */

#include <stdio.h>
#include <string.h>

#ifndef TESTING
#  include "nexus.h"
#endif

#include <stdlib.h>
#include "cmd_line.h"

/* #include <stdio.h> */
#define TRACE(x)	/* printf("trace(arg): " x "\n") */

char *
arg_list_find(arg_list_t *al, char *tag, char *def)
{
    int		i, l;

    l = strlen(tag);
    for (i = 0; i < al->argc; i++)
	if (strncmp(al->argv[i], tag, l) == 0)
	    if (al->argv[i][l] == '=')
		return (&(al->argv[i][l + 1]));
    return (def);
}

/*
 * single copy of arg[cv] so we don't have
 * to keep passing by reference
 */
static int	my_argc;
static char	**my_argv;
static int	curr_arg;

/*
 * reserved tags to look for
 */
static char	*cmd_tags[] =
{
    "-debug",
    "-startup",
    "-selftest",
    "-ep",
    "-run",
    "-end"
};
#define NUM_TAGS	6
#define NULL_TAG	0
#define DEBUG_TAG	1
#define STARTUP_TAG	2
#define SELFTEST_TAG	3
#define TESTEP_TAG	4
#define RUNTEST_TAG	5
#define ENDTEST_TAG	6

/*
 * get_tag()
 *
 * compare the arg at pos to known tags
 */
static int
get_tag(int pos)
{
    int	i;

    if (pos < my_argc)
	for (i = 0; i < NUM_TAGS; i++)
	    if (strcmp(my_argv[pos], cmd_tags[i]) == 0)
		return (i + 1);
    return (NULL_TAG);
}

/*
 * count_args()
 *
 * move curr_arg to first arg, count until next tag
 */
static int
count_args()
{
    int	i;
    
    curr_arg++;
    for (i = curr_arg; i < my_argc; i++) {
	if (get_tag(i) != NULL_TAG)
	    break;
    }
    return (i - curr_arg);
}

/*
 * copy_args()
 *
 * copy and skip past, leaving curr_arg at next tag
 */
static void
copy_args(arg_list_t *al, int n_args)
{
    int	i;

    TRACE("copy_args()");
    al->argc = n_args;
    if (n_args > 0) {
	al->argv = (char **) malloc(n_args * sizeof(char *));
	if (al->argv == NULL) {
	    fprintf(stderr, "cmd_line copy_args(): malloc failed\n");
	    exit(1);
	}
    } else
	al->argv = (char **) NULL;
    for (i = 0; i < n_args; i++)
	al->argv[i] = my_argv[curr_arg++];
									
}

/*
 * count_runtest_tags()
 *
 * check occurrences of '-runtest'
 */
static int
count_runtest_tags()
{
    int	i;
    int	r = 0;

    for (i = curr_arg; i < my_argc; i++)
	if (get_tag(i) == RUNTEST_TAG)
	    r++;
    return (r);
}

int
backtracked(int next_tag, int last_tag)
{
    if (next_tag > last_tag)
	return (0);
    if ((next_tag == last_tag) && (next_tag == RUNTEST_TAG))
	return (0);
    if (next_tag == NULL_TAG)
	return (0);
    return (1);
}

/*
 * split_cmd_line()
 *
 * XXX what happens to MPI startup options?
 */
int
split_cmd_line(int        usr_argc,
	       char       **usr_argv,
	       arg_list_t *debug,
	       arg_list_t *startup,
	       arg_list_t *selftest,
	       arg_list_t *testep,
	       int        *n_tests,
	       arg_list_t **test_list)
{
    int	n, r, t;

    TRACE("hello");

    /* make a local copy */
    my_argc = usr_argc;
    my_argv = usr_argv;

    /* default values for all */
    debug->argc = -1;
    debug->argv = (char **) NULL;
    startup->argc = -1;
    startup->argv = (char **) NULL;
    selftest->argc = -1;
    selftest->argv = (char **) NULL;
    testep->argc = -1;
    testep->argv = (char **) NULL;
    *n_tests = 0;
    *test_list = (arg_list_t *) NULL;

    for (n = 1; n < my_argc; n++)
	if (strcmp(my_argv[n], "--help") == 0)
	    return (-1);

    /* throw away leading args */
    for (curr_arg = 0; curr_arg < my_argc; curr_arg++) {
	t = get_tag(curr_arg);
	if (t != NULL_TAG)
	    break;
    }
    TRACE("looking for -debug");
    if (t == DEBUG_TAG) {
	TRACE("found -debug");
	/* copy args */
	n = count_args();
	copy_args(debug, n);
	/* next tag */
	TRACE("copied, looking...");
	t = get_tag(curr_arg);
	if (backtracked(t, DEBUG_TAG))
	    return (curr_arg);
    }
    TRACE("looking for -startup");
    if (t == STARTUP_TAG) {
	TRACE("found -startup");
	/* copy args */
	n = count_args();
	copy_args(startup, n);
	/* next tag */
	TRACE("copied, looking...");
	t = get_tag(curr_arg);
	if (backtracked(t, STARTUP_TAG))
	    return (curr_arg);
    }
    TRACE("looking for -selftest");
    if (t == SELFTEST_TAG) {
	TRACE("found -selftest");
	n = count_args();
	copy_args(selftest, n);
	TRACE("copied, looking...");
	t = get_tag(curr_arg);
	if (backtracked(t, SELFTEST_TAG))
	    return (curr_arg);
    }
    TRACE("looking for -testep");
    if (t == TESTEP_TAG) {
	/* copy args */
	n = count_args();
	copy_args(testep, n);
	/* next tag */
	t = get_tag(curr_arg);
	if (backtracked(t, TESTEP_TAG))
	    return (curr_arg);
    }
    TRACE("counting -runtest's");
    r = count_runtest_tags();
    if (r > 0) {
	*n_tests = r;
	*test_list = (arg_list_t *) malloc(r * sizeof(arg_list_t));
	if (test_list == NULL) {
	    fprintf(stderr, "split_cmd_line(): malloc failed\n");
	    exit(1);
	}
	for (t = 0; t < r; t++)	{
	    n = count_args();
	    copy_args(&((*test_list)[t]), n);
	}
	t = get_tag(curr_arg);
    }
    if ((t == ENDTEST_TAG) || (t == NULL_TAG))
	return (0);
    else
	return (curr_arg);
}

void arg_list_destroy(arg_list_t *al)
{
    free(al->argv);
    al->argc = -1;
    al->argv = NULL;
}
