/*
 * barrier.h
 */

#ifndef BARRIER_H
#define BARRIER_H

#include "nexus.h"

int barrier_startup();
void barrier_shutdown(int aborted);

/*
 * Create a new barrier and synchronize.
 */
int barrier_create(int group, int *who);

int barrier_delete(int barrier_id);

/*
 * Wait udelay microseconds before sending
 * out synchronization RSRs.  This should
 * help prevent the barrier RSRs from
 * interfering with the test load.
 */
int barrier_set_udelay(int barrier_id,
		       int udelay);

/*
 * Test's main thread goes to sleep until test ends,
 * while still allowing active nodes to use the
 * barrier.
 */
int barrier_passive(int barrier_id);

/*
 * Block the test's main thread until all
 * active nodes have sent a message.
 * Returns the new stage number.
 */
int barrier_block(int barrier_id);

/*
 * Check and see what the current stage is.
 * Used by the main test thread.
 */
int barrier_get_stage(int barrier_id);

/*
 * The test can put the stage number in RSRs it
 * sends, and the handler can check it to see
 * if it has received a current RSR.
 */
int barrier_validate(int barrier_id, int stage);
#define BARRIER_STAGE_ERROR	-1
#define BARRIER_STAGE_UNKNOWN	0
#define BARRIER_STAGE_EARLY	1
#define BARRIER_STAGE_CURRENT	2
#define BARRIER_STAGE_OLD	3
#define BARRIER_STAGE_INVALID	4

/*
 * Send a message to the barrier's event loop
 * so the main thread can break out.
 */
void barrier_wakeup(int whatfor);

#endif
