/*
 * wrappers.h
 */

#ifndef WRAPPERS_H
#define WRAPPERS_H

#include <nexus.h>
#include <stdio.h>
#include "big_test.h"

int SendContextDestroyMsg(nexus_startpoint_t *startpoint);

int InitTesting(nexus_endpoint_t *master,
		nexus_startpoint_t *slave,
		test_node_t **nd, int is_non_threaded_handler);
int DoneTesting(ep_data_t *epd,
		test_node_t **nd, int is_non_threaded_handler);

int AllocNode(ep_data_t *epd, int node_type, int *node_num);
int FreeNode(ep_data_t *epd, int node_type, int node_num);

int WaitForStopWaitingMsg(ep_data_t *epd);

int SendStopWaitingMsg(nexus_startpoint_t *startpoint);

/* S_ functions BLOCKING: */

int M_InitMsg(test_node_t *nd, int msg_num);
int S_InitMsg(test_node_t *nd, int msg_num, int inth);

int M_KillMsg(test_node_t *nd, int msg_num);
int S_KillMsg(test_node_t *nd, int msg_num, int inth);

int M_MallocData(test_node_t *nd, int msg_num);
int S_MallocData(test_node_t *nd, int msg_num, int inth);

int M_FreeData(test_node_t *nd, int msg_num);
int S_FreeData(test_node_t *nd, int msg_num, int inth);

int M_SendType(test_node_t *nd, int msg_num, int inth);
int S_SendType(test_node_t *nd, int msg_num, int inth);

int M_SendData(test_node_t *nd, int msg_num, int inth);
int S_SendData(test_node_t *nd, int msg_num, int inth);

/* S_ functions NON_BLOCKING: */

int WaitForReply(test_node_t *nd, int *result);

int M_GenType(test_node_t *nd, int msg_num, int type_g, int x);
int S_GenType(test_node_t *nd, int msg_num, int type_g, int x, int inth);

int M_GenData(test_node_t *nd, int msg_num, int data_g, int x);
int S_GenData(test_node_t *nd, int msg_num, int data_g, int x, int inth);

int M_CmpType(test_node_t *nd, int ctrl_msg_num, int test_msg_num, int *errors);
int S_CmpType(test_node_t *nd, int ctrl_msg_num, int test_msg_num, int inth);

int M_CmpData(test_node_t *nd, int ctrl_msg_num, int test_msg_num,
	      int *errors, FILE *f);
int S_CmpData(test_node_t *nd, int ctrl_msg_num, int test_msg_num, int inth);

#endif
