/*
 * testnode.h
 */

#ifndef TESTNODE_H
#define TESTNODE_H

#include <nexus.h>
#include "report.h"
#include "message.h"

/*
 * Options: 
 */

/* Number of messages to work with */
#define NUM_MSGS	2
#define MAX_MSG_NUM	(NUM_MSGS - 1)
/*
 * test_node_t
 *
 * Data for a single test node.
 */

/* Node Types */
#define NT_FREE		0
#define NT_MASTER	1
#define NT_SLAVE	2
#define NT_MAX		2

typedef struct _test_node_t
{
    /* info about this node */
    int			my_num;
    int			node_type;
    /* keep statistics */
    report_t		report;
    /* remote startpoint & node_num  to talk to */
    nexus_startpoint_t	startpoint;
    int			node_num;
    /* messages for this node */
    message_t		message[NUM_MSGS];
    /* mutex and condition for waiting */
    nexus_mutex_t	mutex;
    nexus_cond_t	cond;
    volatile int	done;
    /* reply_handler puts answer here */
    int			wait_op;
    int			status;
    int			result;
} test_node_t;

report_t *TN_GetReportPtr(test_node_t *tn);
message_t *TN_GetMsgPtr(test_node_t *tn, int msg_num);

int TN_Init(test_node_t *tn);
int TN_Done(test_node_t *tn);

int TN_PreWait(test_node_t *tn, int wait_op);
int TN_WaitResult(test_node_t *tn, int *result);
int TN_SignalResult(test_node_t *tn, int wait_op, int status, int result);

#endif
