/*
 * testnode.c
 */

#include "testnode.h"

#include "everything.h"

/*
 * -- TN_GetReportPtr() --
 */
report_t *TN_GetReportPtr(test_node_t *tn)
{
    return(&(tn->report));
}
/* -- TN_GetReportPtr() -- */

/*
 * -- TN_GetMsgPtr() --
 *
 * Return a ptr if in valid range, else NULL.
 */
message_t *TN_GetMsgPtr(test_node_t *tn, int msg_num)
{
    if ((msg_num < 0) || (msg_num > MAX_MSG_NUM))
    {
	nexus_printf("TN_GetMsgPtr(): illegal num %i\n", msg_num);
	return(NULL);
    }
    return(&(tn->message[msg_num]));
}
/* -- TN_GetMsgPtr()-- */

/*
 * -- TN_Init() --
 *
 * Initialize test_node for use.  Mutex, condition, report.
 * 
 */
int TN_Init(test_node_t *tn /*, int node_type? */)
{
    if (nexus_mutex_init(&(tn->mutex), NULL) != NEXUS_SUCCESS)
    {
	nexus_printf("AllocNode(): mutex_init failed\n");
	return(0);
    }
    if (nexus_cond_init(&(tn->cond), NULL) != NEXUS_SUCCESS)
    {
	nexus_printf("AllocNode(): cond_init failed\n");
	return(0);
    }
    ReportInit(&(tn->report));
    tn->done = 0;
    tn->status = -1;
    tn->result = -1;
    return(1);
}
/* -- TN_Init() -- */

/*
 * -- TN_Done() --
 */
int TN_Done(test_node_t *tn)
{
    int ok = 1;
    
    if (nexus_mutex_destroy(&(tn->mutex)) != NEXUS_SUCCESS)
    {
	nexus_printf("FreeNode(): mutex_done failed\n");
	ok = 0;
    }
    if (nexus_cond_destroy(&(tn->cond)) != NEXUS_SUCCESS)
    {
	nexus_printf("FreeNode(): cond_destroy failed\n");
	ok = 0;
    }
    tn->node_type = NT_FREE;
    ReportDone(&(tn->report));
    return (ok);
}
/* -- TN_Done() -- */

/*
 * -- TN_PreWait() --
 */
int TN_PreWait(test_node_t *tn, int wait_op)
{
    tn->wait_op = wait_op;
    return(1);
}
/* -- TN_PreWait() -- */

/*
 * -- TN_WaitResult() --
 */
int TN_WaitResult(test_node_t *tn, int *result)
{
    int status;
    
    nexus_mutex_lock(&(tn->mutex));
    while (tn->done == 0)
    {
	nexus_cond_wait(&(tn->cond), &(tn->mutex));
    }

#ifdef TRC_WaitResult
    nexus_printf("WaitResult(): status = %i, result = %i\n",
		 tn->status, tn->result);
#endif
    
    status = tn->status;

    if (result != NULL)
	*result = tn->result;

    tn->done = 0;
    tn->status = 0;
    tn->result = 0;
    
    nexus_mutex_unlock(&(tn->mutex));

    return(status);
}
/* -- TN_WaitResult() -- */

/*
 * -- TN_SignalResult() --
 */
int TN_SignalResult(test_node_t *tn, int wait_op, int status, int result)
{
    if (tn->node_type != NT_MASTER)
    {
	nexus_printf("TN_SignalResult(): node_type is %i\n", tn->node_type);
	return(0);
    }
    
    nexus_mutex_lock(&(tn->mutex));
    if (wait_op != tn->wait_op)
    {
	nexus_printf("result_handler(): sleeping on %i, awakened by %i\n",
		     tn->wait_op, wait_op);
    }
    tn->status = status;
    tn->result = result;
    tn->wait_op = -1;
    tn->done = 1;
    nexus_cond_signal(&(tn->cond));
    nexus_mutex_unlock(&(tn->mutex));
    return(1);
}
/* -- TN_SignalResult() -- */
