typedef struct _run_test_args
{
    nexus_endpoint_t	*endpoint;
    nexus_startpoint_t	slaveSP, leaderSP;
    int			test_id;
    int			reps;
    int			verbose;
} run_test_args;

/*
 * -- run_test_thread() --
 *
 * typedef void *(*nexus_thread_func_t)(void *user_arg);
 */
static void *run_test_thread(void *user_arg)
{
    run_test_args	*rta;
    ep_data_t		*epd;
    report_t		report;
    nexus_buffer_t	reply_buf;

    rta = (run_test_args*)user_arg;
    
    epd = nexus_endpoint_get_user_pointer(rta->endpoint);
    if (epd == NULL)
    {
	nexus_printf("run_test_thread(): epd = NULL\n");
	return;
    }
    if (nexus_startpoint_is_null(&(rta->leaderSP)))
	nexus_printf("rtt(): leaderSP is null\n");
    else
	nexus_printf("rtt(): leaderSP is not null\n");

    if (nexus_startpoint_is_null(&(rta->slaveSP)))
	nexus_printf("rtt(): slaveSP is null\n");
    else
	nexus_printf("rtt(): slaveSP is not null\n");

    nexus_printf("rtt(): test_id = %i, reps = %i, verb = %i\n",
		 rta->test_id, rta->reps, rta->verbose);
    
    if (rta->verbose < epd->verbose)
	rta->verbose = epd->verbose;
    
    ReportInit(&report);
    for (; rta->reps > 0; rta->reps--)
    {
	nexus_printf("rth(): pass %i\n", rta->reps);
	RunTests(rta->endpoint, &(rta->slaveSP),
		 rta->verbose, NEXUS_FALSE, &report);
    }
    
    nexus_buffer_init(&reply_buf, nexus_sizeof_startpoint(&(rta->slaveSP), 1) +
		      nexus_sizeof_int(1) + ReportSize(&report), 0);
    nexus_printf("rtt(): buffer_init'd\n");
    nexus_send_rsr(&reply_buf,
		   &(rta->leaderSP),
		   REPORT_HANDLER_ID,
		   NEXUS_TRUE, NEXUS_FALSE);
    nexus_printf("rtt(): rsr sent\n");
    ReportDone(&report);
    nexus_startpoint_destroy(&(rta->leaderSP));
    nexus_printf("rtt(): auugh!\n");
}
/* -- run_test_thread() -- */

