/*
 * run_test.c
 */

#include "run_test.h"
#include "Random/random.h"
#include "gen_type.c"
#include "gen_data.c"

#include "everything.h"

#define TRY_THIS(stuff) \
    if (stuff == 0) \
    { \
        ok = 0; \
        if (verbose > 0)\
	    nexus_printf("Test(%s): " #stuff ": bad\n", name); \
    } \
    else \
        if (verbose > 2)\
            nexus_printf("Test(%s): " #stuff ": OK\n", name);

#define SEND_THIS(stuff) \
    if (stuff == 0) \
    { \
        ok = 0; \
	if (verbose > 0)\
            nexus_printf("Test(%s): " #stuff ": failed\n", name);\
    } \
    else \
        if (verbose > 2)\
            nexus_printf("Test(%s): " #stuff ": sent\n", name);

#define WAIT_THIS(stuff, what) \
    if (stuff == 0) \
    { \
        ok = 0; \
	if (verbose > 0) \
            nexus_printf("Test(%s): " #what ": bad\n", name); \
    } \
    else \
        if (verbose > 2)\
            nexus_printf("Test(%s): " #what ": OK\n", name);

/*
 * SINGLE_TEST
 */

int SingleTest(const char *name,
	       int verbose,
	       test_node_t *nd,
	       int inth,
	       int type_g, int type_x,
	       int data_g, int data_x)
{
    int e, ok;    
    if (verbose > 2)
	nexus_printf("=== begin %s ===\n", name);
    e = 0;
    ok = 1;
/* Init msgs */
    TRY_THIS(M_InitMsg(nd, 0));
    TRY_THIS(M_InitMsg(nd, 1));
    TRY_THIS(S_InitMsg(nd, 0, inth));
    TRY_THIS(S_InitMsg(nd, 1, inth));
    if (verbose > 2)
	nexus_printf("--- Init Msgs done ---\n");
/* Gen types */
    SEND_THIS(S_GenType(nd, 1, type_g, type_x, inth));
    TRY_THIS(M_GenType(nd, 1, type_g, type_x));
    WAIT_THIS(WaitForReply(nd, NULL), S_GenType(1));
    if (verbose > 2)
	nexus_printf("--- Gen Types done ---\n");
/* Send types */
    TRY_THIS(M_SendType(nd, 1, inth));
    TRY_THIS(S_SendType(nd, 1, inth));
    if (verbose > 2)
	nexus_printf("--- Send Types done ---\n");
/* Cmp types */
    SEND_THIS(S_CmpType(nd, 1, 0, inth));
    TRY_THIS(M_CmpType(nd, 1, 0, &e));
    if (e != 0)
	nexus_printf("Test(%s): master got %i type errors\n", name, e);
    WAIT_THIS(WaitForReply(nd, &e), S_CmpType(nd, 1, 0));
    if (e != 0)
	nexus_printf("Test(%s): slave got %i type errors\n", name, e);
/* Malloc data */
    TRY_THIS(M_MallocData(nd, 0));
    TRY_THIS(S_MallocData(nd, 0, inth));
    TRY_THIS(M_MallocData(nd, 1));
    TRY_THIS(S_MallocData(nd, 1, inth));
    if (verbose > 2)
	nexus_printf("--- Malloc data done --- \n");
/* Gen data */
    SEND_THIS(S_GenData(nd, 1, data_g, data_x, inth));
    TRY_THIS(M_GenData(nd, 1, data_g, data_x));
    WAIT_THIS(WaitForReply(nd, NULL), S_GenData(1));
    if (verbose > 2)
	nexus_printf("--- Gen data done ---\n");
/* Send data */
    TRY_THIS(M_SendData(nd, 1, inth));
    TRY_THIS(S_SendData(nd, 1, inth));
    if (verbose > 2)
	nexus_printf("--- Send data done ---\n");
/* Cmp data */
    SEND_THIS(S_CmpData(nd, 1, 0, inth));
    TRY_THIS(M_CmpData(nd, 1, 0, &e, NULL));
    if (e != 0)
        nexus_printf("Test(%s): master got %i data errors\n", name, e);
    WAIT_THIS(WaitForReply(nd, &e), S_CmpData(1));
    if (e != 0)
        nexus_printf("Test(%s): slave got %i data errors\n", name, e);
/* Free data */
    TRY_THIS(M_FreeData(nd, 0));
    TRY_THIS(S_FreeData(nd, 0, inth));
    TRY_THIS(M_FreeData(nd, 1));
    TRY_THIS(S_FreeData(nd, 1, inth));
    if (verbose > 2)
	nexus_printf("--- Free data done ---\n");
/* Kill msgs */
    TRY_THIS(M_KillMsg(nd, 0));
    TRY_THIS(M_KillMsg(nd, 1));
    TRY_THIS(S_KillMsg(nd, 0, inth));
    TRY_THIS(S_KillMsg(nd, 1, inth));
    if (verbose > 2)
	nexus_printf("--- Kill msg done ---\n");
    return(ok);
}

int RunTests(nexus_endpoint_t *master_ep, nexus_startpoint_t *slave_sp,
	     int verbose, int is_non_threaded_handler, report_t *report)
{
    test_node_t	*nd;
    int		i, ok;
    ep_data_t	*epd;

    ok = 1;
    
    epd = nexus_endpoint_get_user_pointer(master_ep);
    if (epd == NULL)
    {
	nexus_printf("RunTests(): epd = NULL\n");
	return(0);
    }
    
    if (InitTesting(master_ep, slave_sp, &nd, is_non_threaded_handler))
    {
	if (verbose > 2)
	    nexus_printf("RunTests(): InitTesting OK\n");

	if (SingleTest("each_test", verbose, nd,
		       is_non_threaded_handler,
		       GEN_TYPE_EACH, 50,
		       GEN_DATA_STEP, 5) == 0)
	    ok = 0;
	if (SingleTest("geom_test", verbose, nd,
		       is_non_threaded_handler,
		       GEN_TYPE_GEOM, 50,
		       GEN_DATA_GEOM, 0) == 0)
	    ok = 0;
	if (SingleTest("rand_test", verbose, nd,
		       is_non_threaded_handler,
		       GEN_TYPE_RAND, 50,
		       GEN_DATA_RAND, 42) == 0)
	    ok = 0;
	ReportSum(report, &(nd->report));	
	if (DoneTesting(epd, &nd, is_non_threaded_handler) == 0)
	{
	    nexus_printf("RunTests(): DoneTesting bad\n");
	    ok = 0;
	}
	else
	    if (verbose > 2)
		nexus_printf("RunTests(): DoneTesting OK\n");
	return(ok);
    }
    else
    {
	nexus_printf("RunTests(): InitTesting failed\n");
	return(0);
    }
}
