/*
 * report.h
 */

#ifndef REPORT_H
#define REPORT_H

#include <nexus.h>
#include <stdio.h>

typedef struct _report_t
{
    nexus_mutex_t	mutex;
    int			misc_msgs;
    int			misc_bytes;
    int			type_msgs;
    int			type_bytes;
    int			data_msgs;
    int			data_bytes;
} report_t;

int ReportInit(report_t *r);
int ReportDone(report_t *r);
void ReportSum(report_t *total, report_t *add_me);
void ReportAddMisc(report_t *r, int b);
void ReportAddType(report_t *r, int b);
void ReportAddData(report_t *r, int b);
void ReportPrint(FILE *f, report_t *r);
int ReportSize(report_t *r);
void PutReport(nexus_buffer_t *buffer, report_t *r);
void GetReport(nexus_buffer_t *buffer, report_t *r);

#endif
