/*
 * report.c
 */

#include "report.h"

int ReportSize(report_t *r)
{
    return(6 * nexus_sizeof_int(1));
}

void PutReport(nexus_buffer_t *buffer, report_t *r)
{
    nexus_put_int(buffer, &(r->misc_msgs), 1);
    nexus_put_int(buffer, &(r->misc_bytes), 1);

    nexus_put_int(buffer, &(r->type_msgs), 1);
    nexus_put_int(buffer, &(r->type_bytes), 1);

    nexus_put_int(buffer, &(r->data_msgs), 1);
    nexus_put_int(buffer, &(r->data_bytes), 1);
}

void GetReport(nexus_buffer_t *buffer, report_t *r)
{
    nexus_get_int(buffer, &(r->misc_msgs), 1);
    nexus_get_int(buffer, &(r->misc_bytes), 1);
    
    nexus_get_int(buffer, &(r->type_msgs), 1);
    nexus_get_int(buffer, &(r->type_bytes), 1);
    
    nexus_get_int(buffer, &(r->data_msgs), 1);
    nexus_get_int(buffer, &(r->data_bytes), 1);
}

int ReportInit(report_t *r)
{
    r->misc_msgs = 0;
    r->misc_bytes = 0;
    
    r->type_msgs = 0;
    r->type_bytes = 0;
    
    r->data_msgs = 0;
    r->data_bytes = 0;
    
    if (nexus_mutex_init(&(r->mutex), NULL) == NEXUS_SUCCESS)
	return(1);
    else
    {
	nexus_printf("ReportInit(): mutex_init failed\n");
	return(0);
    }
}

int ReportDone(report_t *r)
{
    r->misc_msgs = -1;
    r->misc_bytes = -1;
    
    r->type_msgs = -1;
    r->type_bytes = -1;
    
    r->data_msgs = -1;
    r->data_bytes = -1;
    
    if (nexus_mutex_destroy(&(r->mutex)) != NEXUS_SUCCESS)
    {
	nexus_printf("ReportDone(): mutex_destroy failed\n");
	return(0);
    }
    else
	return(1);
}

void ReportSum(report_t *total, report_t *add_me)
{
    nexus_mutex_lock(&(total->mutex));
    nexus_mutex_lock(&(add_me->mutex));
    
    total->misc_msgs += add_me->misc_msgs;
    total->misc_bytes += add_me->misc_bytes;

    total->type_msgs += add_me->type_msgs;
    total->type_bytes += add_me->type_bytes;

    total->data_msgs += add_me->data_msgs;
    total->data_bytes += add_me->data_bytes;

    nexus_mutex_unlock(&(add_me->mutex));
    nexus_mutex_unlock(&(total->mutex));
}

void ReportAddMisc(report_t *r, int b)
{
    nexus_mutex_lock(&(r->mutex));
    
    r->misc_msgs += 1;
    r->misc_bytes += b;
    
    nexus_mutex_unlock(&(r->mutex));
}

void ReportAddType(report_t *r, int b)
{
    nexus_mutex_lock(&(r->mutex));
		     
    r->type_msgs += 1;
    r->type_bytes += b;
    
    nexus_mutex_unlock(&(r->mutex));
}

void ReportAddData(report_t *r, int b)
{
    nexus_mutex_lock(&(r->mutex));
    
    r->data_msgs += 1;
    r->data_bytes += b;
    
    nexus_mutex_unlock(&(r->mutex));
}

void ReportPrint(FILE *f, report_t *r)
{
    nexus_stdio_lock();
    nexus_mutex_lock(&(r->mutex));
    
    fprintf(f, "misc_msgs  : %i\n", r->misc_msgs);
    fprintf(f, "misc_bytes : %i\n", r->misc_bytes);
    
    fprintf(f, "type_msgs  : %i\n", r->type_msgs);
    fprintf(f, "type_bytes : %i\n", r->type_bytes);
    
    fprintf(f, "data_msgs  : %i\n", r->data_msgs);
    fprintf(f, "data_bytes : %i\n", r->data_bytes);
    
    nexus_mutex_unlock(&(r->mutex));
    nexus_stdio_unlock();
}
