/*
 * remote.c
 *
 * Tests nexus_allow_attach, nexus_attach.
 */

#include "remote.h"

#include "everything.h"

/* define to get a message when an attach is attempted */
#define	TRC_approve_attach_func

/*
 * -- approve_attach_func() --
 *
 * This function is passed to nexus_allow_attach.  Each
 * time an attach is attempted, this function gets called
 * to decide if the attach should  be allowed.
 */
int approve_attach_func(void *user_arg, char *url, nexus_startpoint_t *sp)
{    
#ifdef TRC_approve_attach_func
    nexus_printf("approve_attach_func(): hello\n");
#endif

    if (nexus_startpoint_bind(sp, ((nexus_endpoint_t*)user_arg))
	!= NEXUS_SUCCESS)
    {
	nexus_printf("approve_attach_func(): startpoint_bind failed\n");
	return(1); /* error */
    }

    return(0); /* no error */
}
/* -- approve_attach_func() -- */

/*
 * -- RemoteListen() --
 *
 * Do a nexus_allow_attach, return the url.
 */
int RemoteListen(nexus_endpoint_t *ep, char *url)
{
    unsigned short	port;
    char		*host;

    url[0] = '\0';
    port = 0;

    if (nexus_allow_attach(&port, &host, approve_attach_func, ep)
	!= NEXUS_SUCCESS)
    {
	nexus_printf("RemoteListen(): nexus_allow_attach failed\n");
	return(0);
    }

    nexus_stdio_lock();
    sprintf(url, "x-nexus://%s:%hu/\0", host, port);
    nexus_stdio_unlock();

    return(1);
}
/* -- RemoteListen() -- */

/*
 * -- RemoteAttach() --
 *
 * Do a nexus_attach() to the given url, and set the
 * startpoint.
 */
int RemoteAttach(char *url, nexus_startpoint_t *sp)
{
    if (nexus_attach(url, sp) != 0)
    {
	nexus_printf("RemoteAttach(): nexus_attach failed\n");
	return(0);
    }
    return(1);
}
/* -- RemoteAttach() -- */
