/*
 * message.h
 */

#ifndef MESSAGE_H
#define MESSAGE_H

#include <stdio.h>

#ifndef WITHOUT_NEXUS
#include <nexus.h>
#endif

/*
 * options
 */

#define MAX_TYPES_PER_MSG	200
#define MAX_DATA_COUNT		50000
#define CHECK_CONSISTENCY
#undef	SHOW_MSG_TYPE

/*
 * different data types to check
 */

#define VOID_DATA		0
#define CHAR_DATA		1
#define UCHAR_DATA		2
#define SHORT_DATA		3
#define USHORT_DATA		4
#define	INT_DATA		5
#define UINT_DATA		6
#define LONG_DATA		7
#define ULONG_DATA		8
#define FLOAT_DATA		9
#define DOUBLE_DATA		10

#define MIN_VALID_TYPE		1
#define MAX_VALID_TYPE		10

/*
 * data_array
 */

typedef struct _data_array_t
{
    int		data_type;
    int		data_count;
    int		as_array;
    int		test_info;
    void	*data_ptr;
} data_array_t;

/*
 * message
 */

typedef struct _message_t
{
    data_array_t	*data_array;
    int			num_arrays;
    int			have_data;
} message_t;

/*
 * One-time initialization and memory management for messages
 */

int MessageInit(message_t *msg);
int MessageAddArray(message_t *msg, int type, int count);
int MessageDataMalloc(message_t *msg);
int MessageDataFree(message_t *msg);
int MessageDestroy(message_t *msg);

/*
 * changeable message options
 */

int MessageResetOptions(message_t *msg);
int MessageSetXmitOption(message_t *msg, int array_num, int send_as_array);
int MessageSetTestInfo(message_t *msg, int array_num, int test_info);
int MessageGetTestInfo(message_t *msg, int array_num, int *test_info);
int MessageGetDataPtr(message_t *msg, int array_num, void* *data_ptr);
int MessageGetDataCount(message_t *msg, int array_num, int *data_count);
int MessageGetDataType(message_t *msg, int array_num, int *data_type);

/*
 * Check the parts of a message, count the number of errors found,
 * and print differences if non-null FILE*
 */

int CheckMessageType(message_t *ctrl_msg, message_t *test_msg,
		     int *errors);
int CheckMessageData(message_t *ctrl_msg, message_t *test_msg,
		     int *errors, FILE *f);

/*
 * Initialize a buffer and put data in, or
 * read from buffer into waiting message
 */

#ifndef WITHOUT_NEXUS

int MessageGetTypeSize(message_t *msg, int *size);
int MessageGetDataSize(message_t *msg, int *size);

int PutMessageType(nexus_buffer_t *buffer, message_t *msg);
int GetMessageType(nexus_buffer_t *buffer, message_t *msg);
int PutMessageData(nexus_buffer_t *buffer, message_t *msg);
int GetMessageData(nexus_buffer_t *buffer, message_t *msg);

#endif /* !WITHOUT_NEXUS */

/*
 * Miscellaneous
 */

int SizeofType(int data_type);

#ifndef WITHOUT_NEXUS

int NexusSizeofType(int data_type, int data_count);

#endif /* !WITHOUT_NEXUS */

int ZeroMessageData(message_t *msg);

int MessageFilePut(FILE *f, message_t *msg);
int MessageFileGet(FILE *f, int dc_format, message_t *msg);

#endif
