/*
 * matches.h
 *
 * Given a number of nodes, this code produces a table which
 * will pair them all off so that they each are matched up
 * with every other node exactly once.  Each node can only be
 * used in one match per round.  Idea is to minimize the
 * number of rounds to keep all the nodes busy and finish sooner.
 */

#ifndef MATCHES_H
#define MATCHES_H

#include <nexus.h>

typedef struct
{
    int		t1;
    int		t2;
} match_t;

typedef struct
{
    int		rounds; /* Number of rounds  */
    int		mpr;	/* Matches Per Round */
    match_t	*match; /* Table of matches  */
} tourn_t;

int InitTourn(tourn_t *t, int n_nodes);
int MatchesThisRound(tourn_t *t, int round);
match_t *GetMatch(tourn_t *t, int round, int match);
void KillTourn(tourn_t *t);

void PrintTourn(tourn_t *t);

#endif
