/*
 * matches.c
 */

#include "matches.h"

#define NORM(i) \
    if (i < 0) \
        i = (i + n); \
    if (i >= n) \
	i = (i - n);

/*
 * Make t1, t2 in the range 0..n-1, make the smaller one first.
 */
void NormalizeMatch(match_t *p, int n)
{
    int i;

    NORM(p->t1);
    NORM(p->t2);
    if (p->t2 < p->t1)
    {
	i = p->t1;
	p->t1 = p->t2;
	p->t2 = i;
    }
}

/*
 * Return a pointer to match# in round#.
 */
match_t *GetMatch(tourn_t *t, int round, int match)
{
    if ((round < 0) || (round >= t->rounds))
    {
	nexus_printf("GetMatch(): round %i out of bounds\n", round);
	return(NULL);
    }
    if ((match < 0) || (match >= t->mpr))
    {
	nexus_printf("GetMatch(): match %i out of bounds\n", match);
	return(NULL);
    }
    
    return(&(t->match[round * t->mpr + match]));
}

/*
 * Delete all matches involving n.
 */
void CancelTeam(tourn_t *t, int n)
{
    int		i, j;
    match_t	*m;

    for (i = 0; i < t->rounds; i++)
	for (j = 0; j < t->mpr; j++)
	{
	    m = GetMatch(t, i, j);
	    if ((m->t1 == n) || (m->t2 == n))
	    {
		m->t1 = -1;
		m->t2 = -1;
	    }
	}
}

/*
 * Malloc memory, fill in the matches.
 */
int InitTourn(tourn_t *t, int n_teams)
{
    int		i, j;
    match_t	*m;
    int		c;

    nexus_printf("InitTourn(): n_teams = %i\n", n_teams);

    c = 0;
    /* Even # teams?  Make it odd, and cancel the unused one later */
    if ((n_teams % 2) == 0)
    {
	n_teams++;
	c = 1;
    }
    
    t->mpr = (n_teams / 2);
    t->rounds = (n_teams * (n_teams - 1)) / (2 * t->mpr);
    t->match = (match_t*)nexus_malloc(t->mpr * t->rounds * sizeof(match_t));
    if (t->match == NULL)
    {
	nexus_printf("InitTourn(): malloc failed\n");
	return(0);
    }

    for (i = 0; i < t->rounds; i++)
    {
	for (j = 0; j < t->mpr; j++)
	{
	    m = GetMatch(t, i, j);
	    m->t1 = (i - j - 1);
	    m->t2 = (i + j + 1);
	    NormalizeMatch(m, n_teams);
	}
    }
    if (c == 1)
    {
	nexus_printf("Cancelling %i\n", n_teams - 1);
	CancelTeam(t, n_teams - 1);
    }
    return(1);
}

/*
 * Free memory.
 */
void KillTourn(tourn_t *t)
{
    t->rounds = 0;
    t->mpr = 0;
    free(t->match);
    t->match = NULL;
}

/*
 * Figure out how many are actually used.
 */
int MatchesThisRound(tourn_t *t, int round)
{
    match_t	*m;
    int		i, n;

    n = 0;
    for (i = 0; i < t->mpr; i++)
    {
	m = GetMatch(t, round, i);
	if (m->t1 != -1)
	    n++;
    }
    return(n);
}

void PrintTourn(tourn_t *t)
{
    int		i, j;
    match_t	*m;

    printf("mpr = %i, rounds = %i\n", t->mpr, t->rounds);
    for (i = 0; i < t->rounds; i++)
    {
	printf("Round %i\t", i);
	for (j = 0; j < t->mpr; j++)
	{
	    m = GetMatch(t, i, j);
	    printf("(%i,%i)\t", m->t1, m->t2);
	}
	printf("\n");
    }
    printf("\n");
}

/*
 * Old stuff to test.
 */

/* void main(int argc, char *argv[]) */
/* { */
/*     tourn_t	t; */
/*     int		i; */
/*     int		n; */

/*     for (i = 1; i < argc; i++) */
/*     { */
/* 	if (sscanf(argv[i], "%i", &n)) */
/* 	{ */
/* 	    printf("n_teams = %i\n", n); */
/* 	    if ((n % 2) == 0) */
/* 	    { */
/* 		InitTourn(&t, n + 1); */
/* 		CancelTeam(&t, n); */
/* 	    } */
/* 	    else */
/* 	    { */
/* 		InitTourn(&t, n); */
/* 	    } */
/* 	    PrintTourn(&t); */
/* 	    KillTourn(&t); */
/* 	} */
/* 	else */
/* 	    printf("Can't scan %s\n", argv[i]); */
/*     } */
/* } */
