/*
 * group.h
 *
 * Group testing allows the test program to be started on several
 * different machines, have them all connect to one leader, which
 * can then pair them off to run tests.
 */

#ifndef GROUP_H
#define GROUP_H

#include <nexus.h>
#include "big_test.h"

/*
 * Initialization, wait for group to connect, and cleanup stuff.
 * The leader must explicitly join its own group.
 */
int LeaderInit(ep_data_t *epd, int max_eps);
int LeaderDone(ep_data_t *epd);
int WaitForFollowers(ep_data_t *epd);
int JoinGroup(nexus_endpoint_t *ep, int n_nodes, nexus_node_t *nodes,
	      nexus_startpoint_t *leader);

/*
 * Basic all-to-all testing.  Match each pair of nodes together
 * twice, once with each as master.
 */
int BasicGroupTest(nexus_endpoint_t *epd, int verb, int reps, report_t *r);

/*
 * functions used by the test scheduler
 * Each round consists of some number of tests between master/slave pairs.
 * 1) Set the number of tests this round
 * 2) Schedule each pair
 * 3) Wait for them all to report back
 */
int SetNumPairs(ep_data_t *epd, int n);
int ScheduleTest(nexus_endpoint_t *epd, int master, int slave,
		 int verb, int reps);
int WaitForTests(ep_data_t *epd);

/*
 * functions used by the rsr handlers
 * Each follower checks in with a list of startpoints to its contexts.
 * AllocFollwerSPs() will get memory for the list.  The handler then
 * gets the SPs from the buffer into the list, and calls
 * GotFollowers() to notify the endpoint.  If this is the last one
 * we're waiting for, a signal is sent to wake a thread in
 * WaitForFollowers().
 */
nexus_startpoint_t *AllocFollowerSPs(ep_data_t *epd, int num_sps);
void GotFollowers(ep_data_t *epd);
nexus_startpoint_t *GetFollowerSP(ep_data_t *epd, int n);

#endif
