/*
 * gen_type.c
 */

#undef	TRC_UserGenType

/*
 * -- UserGenType() --
 */

int UserGenType(message_t *msg, int type_g, int x)
{
    int i;
    
#ifdef TRC_UserGenType
    nexus_printf("UserGenType(): type = %i, x = %i\n", type_g, x);
#endif

    switch(type_g)
    {
    case GEN_TYPE_EACH:
	return(GenTypeEach(msg, x));
    case GEN_TYPE_GEOM:
	return(GenTypeGeom(msg, x));
    case GEN_TYPE_RAND:
	return(GenTypeRand(msg, x));
    }

    nexus_printf("UserGenType(): unknown type_g %i\n", type_g);
	
    return(0);
}
/* -- UserGenType() -- */


int GenTypeEach(message_t *msg, int x)
{
    int i;
    
    for (i = CHAR_DATA; i <= DOUBLE_DATA; i++)
    {
	if (MessageAddArray(msg, i, x) == 0)
	    return(0);
    }

    return(1);
}

int GenTypeGeom(message_t *msg, int x)
{
    int i;

    for (i = CHAR_DATA; i <= ULONG_DATA; i++)
    {
	if (MessageAddArray(msg, i, x) == 0)
	    return(0);
    }

    return(1);
}

int GenTypeRand(message_t *msg, int x)
{
    random_t	r;
    int		i;
    
    random_seed(&r, SEED_HI ^ x, SEED_LO ^ x);

    for (i = 0; i < MAX_TYPES_PER_MSG; i++)
    {
	if (MessageAddArray(msg, random_char(&r) % DOUBLE_DATA + 1, x) == 0)
	    return(0);
    }

    return(1);
}

