/*
 * gen_data.c
 */

#undef	TRC_UserGenData

/*
 * -- UserGenData() --
 */

int UserGenData(message_t *msg, int data_g, int x)
{
#ifdef TRC_UserGenData
    nexus_printf("UserGenData(): hello\n");
#endif

    switch(data_g)
    {
    case GEN_DATA_STEP:
	return(GenDataStep(msg, x));
    case GEN_DATA_GEOM:
	return(GenDataGeom(msg, x));
    case GEN_DATA_RAND:
	return(GenDataRand(msg, x));
    }
    
    nexus_printf("UserGenData(): unknown data_g %i\n", data_g);

    return(1);
}
/* -- UserGenData() -- */

/*
 * -- GenDataStep() --
 */

#define STEP_LOOP(type, lim) \
    for (j = 0; j < c; j++) \
    { \
        ((type *)p)[j] = d; \
	d = (d + x) % lim; \
    }
	  
int GenDataStep(message_t *msg, int x)
{
    int		i, j;
    int		t, c;
    void	*p;
    int		d;
    float	fd;
    double	dd;
    
    d = 0;

    for (i = 0; i < msg->num_arrays; i++)
    {
	MessageGetDataType(msg, i, &t);
	MessageGetDataCount(msg, i, &c);
	MessageGetDataPtr(msg, i, &p);

	switch (t)
	{
	case CHAR_DATA:
	case UCHAR_DATA:
	    STEP_LOOP(char, 123);
	    break;
	    
	case SHORT_DATA:
	case USHORT_DATA:
	    STEP_LOOP(short, 32123);
	    break;

	case INT_DATA:
	case UINT_DATA:
	    STEP_LOOP(int, 2123123123);
	    break;

	case LONG_DATA:
	case ULONG_DATA:
	    STEP_LOOP(long, 2123123123);
	    break;

	case FLOAT_DATA:
	    fd = 0.0;
	    for (j = 0; j < c; j++)
	    {
		((float *)p)[j] = fd;
		fd = fd + x;
	    }
	    break;

	case DOUBLE_DATA:
	    dd = 0.0;
	    for (j = 0; j < c; j++)
	    {
		((double *)p)[j] = dd;
		dd = dd + x;
	    }
	    break;
	    
	default:
	    return(0);
	}
    }
    return(1);
}

/*
 * -- GenDataGeom() --
 */

#define GEOM_LOOP(type) \
    for (j = 0; j < c; j++) \
    { \
        ((type *)p)[j] = d; \
	d = d << 1; \
	if (d == 0) \
	    d = 1; \
    }

int GenDataGeom(message_t *msg, int x)
{
    int		i, j;
    int		c, t, d;
    void	*p;
    
    d = 1;

    for (i = 0; i < msg->num_arrays; i++)
    {
	MessageGetDataType(msg, i, &t);
	MessageGetDataCount(msg, i, &c);
	MessageGetDataPtr(msg, i, &p);

	switch (t)
	{
	case CHAR_DATA:
	case UCHAR_DATA:
	    GEOM_LOOP(char);
	    break;
	    
	case SHORT_DATA:
	case USHORT_DATA:
	    GEOM_LOOP(short);
	    break;

	case INT_DATA:
	case UINT_DATA:
	    GEOM_LOOP(int);
	    break;

	case LONG_DATA:
	case ULONG_DATA:
	    GEOM_LOOP(long);
	    break;
	default:
	    return(0);
	}
    }
    return(1);
}

/*
 * -- GenDataRand() --
 */

#define RAND_LOOP(type) \
    for (j = 0; j < c; j++) \
    { \
        ((type *)p)[j] = random_ ## type(&r); \
    }

int GenDataRand(message_t *msg, int x)
{
    random_t	r;
    int		i, j;
    int		c, t;
    void	*p;

    random_seed(&r, SEED_HI ^ x, SEED_LO ^ x);
    
    for (i = 0; i < msg->num_arrays; i++)
    {
	MessageGetDataType(msg, i, &t);
	MessageGetDataCount(msg, i, &c);
	MessageGetDataPtr(msg, i, &p);

	switch (t)
	{
	case CHAR_DATA:
	case UCHAR_DATA:
	    RAND_LOOP(char);
	    break;
	    
	case SHORT_DATA:
	case USHORT_DATA:
	    RAND_LOOP(short);
	    break;

	case INT_DATA:
	case UINT_DATA:
	    RAND_LOOP(int);
	    break;

	case LONG_DATA:
	case ULONG_DATA:
	    RAND_LOOP(long);
	    break;

	case FLOAT_DATA:
	    RAND_LOOP(float);
	    break;

	case DOUBLE_DATA:
	    RAND_LOOP(double);
	    break;
	    
	default:
	    return(0);
	}
    }
    return(1);
}
