/*
 * epdata.h
 *
 * ep_data_t (endpoint data)
 */

#ifndef EPDATA_H
#define EPDATA_H

#include "big_test.h"

/*
 * test_info_t
 */
typedef struct _test_info_t
{
    struct _test_info_t	*next;
    nexus_startpoint_t	slaveSP;
    nexus_startpoint_t	leaderSP;
    int			verb;
    int			reps;
    int			test_id;
} test_info_t;

/*
 * ep_data_t
 *
 * Data for an endpoint.
 */

typedef struct _ep_data_t
{
    /* test_nodes for this endpoint */
    struct
    {
	nexus_mutex_t	mutex;
	int		num_nodes;
	int		nodes_used;
	test_node_t	*test_node;
    } nodes;

    /* group leader stuff */
    struct
    {
	int			am_leader;
	nexus_mutex_t		mutex;
	int			num_left;
	int			num_eps;
	int			num_sps;
	int			*sps_per_ep;
	nexus_startpoint_t	**follower;
	report_t		report;
    } group;

    /* Condition for main thread to wait on. */
    struct
    {
	nexus_mutex_t	mutex;
	nexus_cond_t	cond;
	int		done;
	
	int		context_destroy;
	int		service_queue;
	int		stop_waiting;
    } wait;

    /* Queue of tests to be run. */
    struct
    {
	nexus_mutex_t	mutex;
	test_info_t	*first, *last;
    } test_Q;

    /* minimum verbose level for this context */
    int		verbose;
    /* total of all communications from this context */
    report_t	report;

    nexus_endpoint_t	*endpoint;

} ep_data_t;

/* create and destroy */
int EPD_Create(ep_data_t **epd, int num_nodes, int verbose);
int EPD_Destroy(ep_data_t **epd);

/* alloc, free, and get test_nodes */
test_node_t *EPD_GetNodePtr(ep_data_t *epd, int node_num);
int EPD_AllocNode(ep_data_t *epd, int node_type, int *node_num);
int EPD_FreeNode(ep_data_t *epd, int node_type, int node_num);

/* Main thread in master context waits here after */
/* listening to allow others to attach.           */
int EPD_StopWaiting(ep_data_t *epd);

/*
 * Rest of these functions put a layer of abstraction in
 * to allow the same handlers to be used in threaded and
 * BUILD_LITE versions of Nexus.  Threaded version would
 * create new thread for each test instead of queueing
 * them up for the main thread to handle.
 */

/* Main thread in slave contexts always wait here,  */
/* and should call context_destroy when it returns. */
/* Main thread in master context waits here after   */
/* joining a group, can continue after it returns.  */
/* Main thread in leader context waits here until   */
/* all tests have returned.                         */
int EPD_MainLoop(ep_data_t *epd);

/* allow handlers to pass test_info to the main thread */
int EPD_NQ_Test(ep_data_t *epd, test_info_t *ti);

/* and the main thread takes them out */
int EPD_DQ_Test(ep_data_t *epd, test_info_t **ti);

/* Handler calls this when ContextDestroyMsg is */
/* received.  Causes EPD_MainLoop() to return. */
void EPD_ContextDestroy(ep_data_t *epd);

#endif
