/*
 * random_test.c
 */

#include <stdio.h>
#include "random.h"

int main(int argc, char *argv[])
{
    char		c;
    unsigned char	uc;
    short		s;
    unsigned short	us;
    int			i;
    unsigned int	ui;
    long		l;
    unsigned long	ul;
    float		f;
    double		d;

    random_t		r;

    int j;

    random_seed(&r, 123456789, 987654321);

    printf("\n\n--float---------\n");
    for (j = 0; j < 10; j++)
	printf("%E\n", random_float(&r));

    printf("\n\n--double--------\n");
    for (j = 0; j < 10; j++)
	printf("%E\n", random_double(&r));

    printf("\n--char----------\n");
    for (j = 0; j < 10; j++)
    {
	c = random_char(&r);
	uc = c;
	printf("%i\t%u\n", c, uc);
    }

    printf("\n\n--short---------\n");
    for (j = 0; j < 10; j++)
    {
	s = random_short(&r);
	us = s;
	printf("%i\t%u\n", s, us);
    }

    printf("\n\n--int----------\n");
    for (j = 0; j < 10; j++)
    {
	i = random_int(&r);
	ui = i;
	printf("%i\t%u\n", i, ui);
    }

    printf("\n\n--long----------\n");
    for (j = 0; j < 10; j++)
    {
	l = random_long(&r);
	ul = l;
	printf("%i\t%u\n", l, ul);
    }

#ifdef DO_INF_NAN
    printf("\n\n--Inf/NaN-------\n");
    printf("+Inf\t%E\t%E\n", float_PosInf(), double_PosInf());
    printf("-Inf\t%E\t%E\n", float_NegInf(), double_NegInf());
    printf("+NaN\t%E\t%E\n", float_PosNaN(), double_PosNaN());
    printf("-NaN\t%E\t%E\n", float_NegNaN(), double_NegNaN());
#endif
   
    printf("\n\n");
    
    return(0);
}
