/*
 * Random.c
 */

#include "random.h"
#include "random_cfg.h"

#define a	175

#define random_cycle_0\
    if (r->x[0] < 0)\
        r->x[0] = (r->x[0] << 1) ^ a;\
    else\
        r->x[0] = (r->x[0] << 1);

#define random_cycle_1\
    if (r->x[1] < 0)\
        r->x[1] = (r->x[1] << 1) ^ a;\
    else\
        r->x[1] = (r->x[1] << 1);

#ifdef RAND_LE
  #define random_cycle_lo random_cycle_0
  #define random_cycle_hi random_cycle_1
#else
  #define random_cycle_lo random_cycle_1
  #define random_cycle_hi random_cycle_0
#endif

int random_seed(random_t *r, int seed_hi, int seed_lo)
{
#ifdef RAND_LE
    r->x[0] = seed_lo;
    r->x[1] = seed_hi;
#else
    r->x[0] = seed_hi;
    r->x[1] = seed_lo;
#endif
    return(1);
}

char random_char(random_t *r)
{
#ifndef ALLOW_8BIT_CHAR
    return(random_int(r) & 0x7f);
#else
    return(random_int(r) & 0xff);
#endif    
}

short random_short(random_t *r)
{
    return(random_int(r) & 0xffff);
}

int random_int(random_t *r)
{
    random_cycle_lo;
#ifdef RAND_LE
    return(r->x[0]);
#else
    return(r->x[1]);
#endif
}

#ifndef ALLOW_64BIT_LONG
    long random_long(random_t *r)
    {
	return(random_int(r));
    }
#else
  #ifndef RAND_64
    #error 64 bit long not supported
  #else
    long random_long(random_t *r)
    {
	random_cycle_lo;
	random_cycle_hi;
      #ifdef RAND_LE
        return(*((long*)&(r->x_lo)));
      #else
        return(*((long*)&(r->x_hi)));
      #endif
    }
  #endif
#endif

float random_float(random_t *r)
{
    /* clear LSB of exponent to avoid INF and NaN */
    int i = random_int(r) & 0xff7fffff;    
    return(*((float*)&(i)));
}

double random_double(random_t *r)
{
    int i[2];

    random_cycle_hi;
    random_cycle_lo;
    i[0] = r->x[0];
    i[1] = r->x[1];
    /* clear LSB of exponent to avoid INF and NaN */
#ifdef RAND_LE
    i[1] &= 0xffefffff;
#else
    i[0] &= 0xffefffff;
#endif
    return(*((double*)i));
}

float float_PosNaN()
{
    int	i = 0x7f800001;
    return(*((float*)&i));
}

float float_NegNaN()
{
    int i = 0xff800001;
    return(*((float*)&i));
}

float float_PosInf()
{
    int i = 0x7f800000;
    return(*((float*)&i));
}

float float_NegInf()
{
    int i = 0xff800000;
    return(*((float*)&i));
}

double double_PosNaN()
{
    int i[2];
#ifdef RAND_LE
    i[0] = 0;
    i[1] = 0x7ff00001;
#else
    i[0] = 0x7ff00001;
    i[1] = 0;
#endif
    return(*((double*)i));
}

double double_NegNaN()
{
    int i[2];
#ifdef RAND_LE
    i[0] = 0;
    i[1] = 0xfff00001;
#else
    i[0] = 0xfff00001;
    i[1] = 0;
#endif
    return(*((double*)i));
}

double double_PosInf()
{
    int i[2];
#ifdef RAND_LE
    i[0] = 0;
    i[1] = 0x7ff00000;
#else
    i[0] = 0x7ff00000;
    i[1] = 0;
#endif
    return(*((double*)i));
}

double double_NegInf()
{
    int i[2];
#ifdef RAND_LE
    i[0] = 0;
    i[1] = 0xfff00000;
#else
    i[0] = 0xfff00000;
    i[1] = 0;
#endif
    return(*((double*)i));
}

