/*
 * rand_config.c
 */

#include <stdio.h>

#define PS(x, z) \
    printf("/*\tsizeof(" #x ")\t%i", sizeof(x)); \
    if (sizeof(x) != z) \
    { \
	printf("\t!!\t*/\n"); \
        fprintf(stderr, "sizeof" #x " = %i, expected " #z "\n", sizeof(x)); \
	rc = 1; \
    }\
    else \
        printf("\tOK\t*/\n");

int main()
{
    short i[2];
    int   rc = 0;
    
    printf("\n");

    if (sizeof(int) != 4)
    {
	fprintf(stderr, "int is not 32 bits, RandomLib will not work\n");
	rc = 1;
    }
    
    if (sizeof(short) != 2)
    {
	fprintf(stderr, "short is not 16 bits, can't figure endian type\n");
	rc = 1;
    }

    printf("/*\n");
    printf(" * random_cfg.h\n");
    printf(" * \n");
    printf(" * generated by rand_config\n");
    printf(" */\n\n");
    
    PS(char, 1);
    PS(short, 2);
    PS(int, 4);

    printf("/*\tsizeof(long)\t%i\tOK\t*/\n", sizeof(long));
    
    PS(float, 4);
    PS(double, 8);

    printf("\n");
    
    i[0] = 0;
    i[1] = -1;

    if (*((int*)i) == 0xffff0000)
	printf("#define RAND_LE\t/* endian = LE */\n\n");
    else
	if (*((int*)i) == 0x0000ffff)
	    printf("#undef RAND_LE\t/* endian = BE */\n\n");
	else
	{
	    fprintf(stderr, "can't figure endian format\n");
	    rc = 1;
	}

    if (sizeof(long) < 8)
    {
	printf("/* 64 bit longs are not supported by this machine */\n\n");
    }
    else
	if (sizeof(long) == 8)
	{
	    printf("/*\t64 bit longs are supported by this machine\t*/\n");
	    printf("#define RAND_64\n\n");
	    printf("/*\tuncomment to generate longs > 32 bits\t*/\n");
	    printf("/* #define ALLOW_64BIT_LONG */\n\n");
	}

    printf("/*\tuncomment to allow 8 bit chars\t*/\n");
    printf("/*\tmay cause sign confusion\t*/\n");
    printf("/* #define ALLOW_8BIT_CHAR */\n\n");
    
    return(rc);
}
