#include <stdio.h>
#include <errno.h>
#include "globus_config.h"

#ifdef TARGET_ARCH_SUNOS41
#include <stdlib.h>
#endif


/*
 * read_msg_sizes()
 *
 * Return zero on failure, or non-zero on success.
 */
int
read_msg_sizes(char *msg_size_file,
	       void *(*malloc_func)(size_t size),
	       int allow_zero_length_message,
	       int *n_tests,
	       double *test_run_time,
	       int *n_msg_sizes,
	       int **msg_size_array,
	       int *max_msg_size)
{
    FILE *fp;
    int i;
    
    if ((fp = fopen(msg_size_file, "r")) == (FILE *) NULL)
    {
	return(0);
    }

    fscanf(fp, "%d", n_tests);
    fscanf(fp, "%lf", test_run_time);
    fscanf(fp, "%d", n_msg_sizes);

    *msg_size_array = (int *) (*malloc_func)(sizeof(int) * *n_msg_sizes);
    if (*msg_size_array == (int *) NULL)
    {
	return(0);
    }

    *max_msg_size = 1;
    for(i = 0; i < *n_msg_sizes; i++)
    {
	if (fscanf(fp, "%d", &((*msg_size_array)[i])) != 1)
	{
	    return(0);
	}
	if (!allow_zero_length_message
	    && ((*msg_size_array)[i] == 0))
	{
	    (*msg_size_array)[i] = 1;
	}
	if ((*msg_size_array)[i] > *max_msg_size)
	{
	    *max_msg_size = (*msg_size_array)[i];
	}
    }
    
    fclose(fp);
    return(1);
} /* read_msg_sizes() */


/*
 * start_remote_node()
 *
 * Startup the command on the specified host, in the
 * current_directory.
 */
int
start_remote_node(char *host,
		  char *command,
		  char *current_directory)
{
    int child;
    FILE *fp;
    int p[2];

    if (pipe(p) < 0)
    {
	printf("Fatal error: start_remote_node(): pipe() failed with errno=%i\n", errno);
	exit(1);
    }

    if ((child = fork()) == 0)
    {
	close(0);
	dup2(p[0], 0);
	close(p[0]);
	close(p[1]);

	execl(PP_RSH, PP_RSH_BASE, host, "/bin/sh", NULL);
	printf("Fatal error: start_remote_Node(): exec() failed with errno=%i\n", errno);
	exit(1);
    }
    else if (child < 0)
    {
	printf("Fatal error: start_remote_node(): fork() failed with errno=%i\n", errno);
	exit(1);
    }

    close(p[0]);

    fp = fdopen(p[1], "w");
    
    fprintf(fp, "cd %s; %s < /dev/null &\n", current_directory, command);
    
    fclose(fp);

    return 1;
} /* start_remote_node() */


/*
 * strip_tmp_mnt_from_path()
 *
 * Modify the passed directory name, 'dir', to remove a leading "/tmp_mnt".
 * This is a common prefixes that is used by
 * NFS automounters, which sometimes get in the way.
 */
void strip_tmp_mnt_from_path(char *dir)
{
    if (strncmp(dir, "/tmp_mnt", 8) == 0)
    {
	memmove(dir, dir+8, strlen(dir) - 7);
    }
} /* strip_tmp_mnt_from_path() */
