/*
 * pptcp.c
 *
 * TCP ping-pong
 *
 * Usage: pptcp host
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/performance/pptcp.c,v 1.7 1998/06/11 00:28:12 tuecke Exp $";

#include "globus_config.h"

/*
*/
#ifndef DISPLAY_TIMES
#define DISPLAY_TIMES
#endif

#define PP_SNDBUF_SIZE 32768
/*
#define PP_SNDBUF_SIZE 0
#define PP_SNDBUF_SIZE 262144
*/

#ifdef TARGET_ARCH_AIX
#define _ALL_SOURCE
#endif

#ifdef SSL
#include "ssl.h"
#include "ssllib.h"
typedef SSLHandle * fd_t;
void read_certificate(int is_server);
#define KEYDIR "foobar"
#define KEY "foobar\n"
extern int pptcp_do_timings;
extern int pptcp_write_timer;
extern int pptcp_read_timer;
#else  /* SSL */
typedef int fd_t;
#endif /* SSL */

#include <stddef.h>
#include <stdlib.h>
#include <errno.h>

#include <stdio.h>
#include <ctype.h>

#ifdef TARGET_ARCH_NEXTSTEP
#include <libc.h>
#endif

#if defined(TARGET_ARCH_SOLARIS) || defined(TARGET_ARCH_AXP)
#include <unistd.h>
#endif

#ifdef TARGET_ARCH_AXP
#include <stdlib.h>
#endif

#ifdef TARGET_ARCH_SUNOS41
#include <malloc.h>
#include <unistd.h>
#include <sys/param.h>
#define NO_MEMMOVE
#endif

#ifdef TARGET_ARCH_AIX
#include <sys/param.h>
#include <sys/access.h>
#endif

#ifdef TARGET_ARCH_PARAGON
#include <sys/param.h>
#include <sys/access.h>
#include <sys/errno.h>
#endif

#ifdef TARGET_ARCH_SGI
#include <sys/param.h>
#endif

#ifdef TARGET_ARCH_HPUX
#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>
#endif

#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <fcntl.h>
#include <sys/param.h>
#include <math.h>

#ifdef TARGET_ARCH_AIX
#include <sys/select.h>
#endif

#ifdef TARGET_ARCH_HPUX
#define PP_FD_SET_CAST (int *)
#else
#define PP_FD_SET_CAST (fd_set *)
#endif

#include "pputil.h"
#include "globus_utp.h"

#define DEFAULT_MSG_SIZE_FILE "pp_msg_sizes"
#ifndef CALIBRATE_ITERS
#define CALIBRATE_ITERS 4000
#endif

extern int errno;
extern char *sys_errlist[];

#ifdef DEBUG
#define MyAssert(condition) \
    if (!(condition)) \
    { \
        printf("Fatal error: Assertion " #condition " failed in file %s at line %d\n", __FILE__, __LINE__); \
	exit(1); \
    }
static int debug_level = 0;
#else  /* DEBUG */
#define MyAssert(condition)
#endif /* DEBUG */


typedef int bool_t;

#define PP_TRUE	1
#define PP_FALSE	0

#define PP_MAX(V1,V2) (((V1) > (V2)) ? (V1) : (V2))
#define PP_MIN(V1,V2) (((V1) < (V2)) ? (V1) : (V2))

#define ZeroOutMemory(Where,Size)	bzero(Where, Size)
/*
#define ZeroOutMemory(Where,Size)	memset(Where,0,Size)
*/

char ping_host_save[300];
char pong_host_save[300];


/*
 * Various forward declarations
 */
void	ping_main(fd_t pong_fd, char *msg_size_file);
void	pong_main(fd_t ping_fd);
fd_t	invoke_pong(char *pong_host, char *executable);

void	config_socket(int s);
void	set_nonblocking(int fd);
fd_t	do_connect(char *host, int port);
int	setup_listener(int *port);
int	fd_read(fd_t fd, void *buf, int len, bool_t blocking);
int	fd_write(fd_t fd, void *buf, int len, bool_t blocking);


/*
 * print_usage()
 */
void
print_usage(int argc, char **argv)
{
    printf("Usage: %s [-f <message_size_file>]\n", argv[0]);
    printf("          [-c <server_host> <server_port>]\n");
    printf("          [-s <startup_host>]\n");
} /* print_usage() */


/*
 * main()
 */
int main(int argc, char **argv)
{
    int i;
    char *msg_size_file;
    char *ping_host;
    int ping_port;
    char *pong_host;

    setbuf(stdout, NULL);

    /* Get the command line arguments */
    msg_size_file = DEFAULT_MSG_SIZE_FILE;
    ping_host = NULL;
    ping_port = 0;
    pong_host = NULL;

    for (i = 1; i < argc; i++)
    {
	if ((strcmp(argv[i],"-f") == 0) && ((i + 1) < argc))
	{
	    msg_size_file = argv[++i];
	}
	else if ((strcmp(argv[i],"-c") == 0) && ((i + 2) < argc))
	{
	    ping_host = argv[++i];
	    ping_port = atoi(argv[++i]);
	}
	else if ((strcmp(argv[i],"-s") == 0) && ((i + 1) < argc))
	{
	    pong_host = argv[++i];
	}
	else if (strcmp(argv[i],"-h") == 0)
	{
	    print_usage(argc, argv);
	    return(0);
	}
	else
	{
	    print_usage(argc, argv);
	    return(1);
	}
    }

    if (ping_host)
    {
	fd_t ping_fd;
	ping_fd = do_connect(ping_host, ping_port);
	pong_main(ping_fd);
    }
    else if (pong_host)
    {
	fd_t pong_fd;
	pong_fd = invoke_pong(pong_host, argv[0]);
	ping_main(pong_fd, msg_size_file);
    }
    else
    {
	print_usage(argc, argv);
    }

    return(0);
} /* main() */


/*
 * ping_main()
 */
void ping_main(fd_t pong_fd, char *msg_size_file)
{
    char *msgbuf;
    int msg_size;
    int n_iters;
    int starting_n_iters;
    int i, j;
    char *data_file;
    int n_msg_sizes;
    int *msg_size_array;
    int max_msg_size;
    double time;
    int precision;
    long n;
    int ntest;
    int n_tests;
    int timer_index;
    double test_run_time;
    
    if (!read_msg_sizes(msg_size_file,
			malloc,
			PP_FALSE, /* allow_zero_length_message */
			&n_tests,
			&test_run_time,
			&n_msg_sizes,
			&msg_size_array,
			&max_msg_size))
    {
	printf("Couldn't read sizes file: %s\n", msg_size_file);
	exit(1);
    }

    /* Send n_tests to pong_main() */
    n = htonl(n_tests);
    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);

    /* Send n_tests to pong_main() */
    n = htonl(max_msg_size);
    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);

    /* Send n_tests to pong_main() */
    n = htonl(n_msg_sizes);
    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);

    /* Get a filename */
    if ((data_file = getenv("PPMP_FILE")) == (char *) NULL)
    {
#ifdef SSL
	data_file = "pptcp.ssl.utp";
#else
	data_file = "pptcp.utp";
#endif
    }

    /* Initialize timers */
    globus_module_activate(GLOBUS_UTP_MODULE);
#ifdef SSL
    globus_utp_init((n_msg_sizes * n_tests * 3), GLOBUS_UTP_MODE_SHARED);
#else  /* SSL */
    globus_utp_init((n_msg_sizes * n_tests), GLOBUS_UTP_MODE_SHARED);
#endif /* SSL */
    globus_utp_set_attribute("rcsid%s", "", "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/performance/pptcp.c,v 1.7 1998/06/11 00:28:12 tuecke Exp $");
    globus_utp_set_attribute("type%s", "", "pptcp");
    globus_utp_set_attribute("program_rcsid%s", "", rcsid+1);
    globus_utp_set_attribute("n_tests%s", "", "%d", n_tests);
    globus_utp_set_attribute("ping_host%s", "", "%s", ping_host_save);
    globus_utp_set_attribute("pong_host%s", "", "%s", pong_host_save);

    /* Allocate room for the message buffer */
    msgbuf = (char *) malloc(max_msg_size);

#ifdef SSL
    /* Randomize the message body.  This code is in sslhp.c */
    GenerateRandomBytes(msgbuf, max_msg_size);
#endif /* SSL */
    
    /*
     * Send some messages around to get things warmed up.
     * Use the results of this to figure out a multipler
     * which will automatically scale all of the test lengths.
     */
    msg_size = msg_size_array[0];
    n = htonl(msg_size);
    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);
    n_iters = CALIBRATE_ITERS;
    printf("Calibrating...\n");
    globus_utp_start_timer(0);
    for (j = 0; j < n_iters; j++)
    {
	fd_write(pong_fd, msgbuf, msg_size, PP_TRUE);
	fd_read(pong_fd, msgbuf, msg_size, PP_TRUE);
    }
    globus_utp_stop_timer(0);
    globus_utp_get_accum_time(0, &time, &precision);
    globus_utp_reset_timer(0);

    /* Adjust n_iters and send it to pong_main() */
    starting_n_iters = PP_MAX(((int) ((test_run_time / time) * n_iters)), 1);
    n = htonl(starting_n_iters);
    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);

    /* Run timings */
    for (ntest = 0; ntest < n_tests; ntest++)
    {
	n_iters = starting_n_iters;
	
	for (i = 0; i < n_msg_sizes; i++)
	{
	    timer_index = (ntest * n_msg_sizes) + i;
	    msg_size = msg_size_array[i];

	    /* Send msg_size to pong_main() */
	    n = htonl(msg_size);
	    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);

	    printf("Timing size=%d, iterations=%d, ntest=%d\n",
		   msg_size, n_iters, ntest);

#ifdef SSL
	    pptcp_write_timer = (ntest*n_msg_sizes)+i+(n_tests*n_msg_sizes);
	    globus_utp_name_timer(pptcp_write_timer,
			   "write crypto, msg_len:%d count:%d testno:%d",
			   msg_size, n_iters, ntest);
	    pptcp_read_timer = (ntest*n_msg_sizes)+i+(2*n_tests*n_msg_sizes);
	    globus_utp_name_timer(pptcp_read_timer,
			   "read crypto, msg_len:%d count:%d testno:%d",
			   msg_size, n_iters, ntest);
	    pptcp_do_timings = 1;
#endif /* SSL */
	    
	    globus_utp_name_timer(timer_index, "msg_len:%d count:%d testno:%d",
			   msg_size, n_iters, ntest);
	    globus_utp_start_timer(timer_index);
	    
	    for (j = 0; j < n_iters; j++)
	    {
		fd_write(pong_fd, msgbuf, msg_size, PP_TRUE);
		fd_read(pong_fd, msgbuf, msg_size, PP_TRUE);
	    }
	    
	    globus_utp_stop_timer(timer_index);

#ifdef SSL
	    pptcp_do_timings = 0;
#endif /* SSL */
	    
	    /* Get the accumlated time and display results */
	    globus_utp_get_accum_time(timer_index, &time, &precision);

#ifdef DISPLAY_TIMES
	    printf("Results:\n");
	    printf("                     roundtrip count: %d\n", n_iters);
	    printf("              message length (bytes): %d\n", msg_size);
	    printf("                   elapsed time (us): %f\n",
                   time*1000000);
	    printf("         average roundtrip time (us): %f\n",
		   time*1000000/n_iters);
	    printf("    latency (average oneway time,us): %f\n",
		   (time*1000000/n_iters)/2);
	    printf("            bandwidth (bytes/second): %f\n",
		   (n_iters*msg_size*2)/time);
	    printf("\n");
#endif /* DISPLAY_TIMES */

	    /* Update and send the iters_multiplier to pong_main() */
	    n_iters = PP_MAX(((int) ((test_run_time / time) * n_iters)), 1);
	    n = htonl(n_iters);
	    fd_write(pong_fd, &n, sizeof(n), PP_TRUE);

	}
    }

    printf("Done.\n");
    
    /* Write out the timer file */
    globus_utp_write_file(data_file);
    
    globus_module_deactivate(GLOBUS_UTP_MODULE);

    free(msgbuf);
} /* ping_main() */


/*
 * pong_main()
 */
void pong_main(fd_t ping_fd)
{
    char *msgbuf;
    int msg_size;
    int n_iters;
    int starting_n_iters;
    int i, j;
    int n_msg_sizes;
    int max_msg_size;
    long n;
    int ntest;
    int n_tests;

    /* Get n_tests from ping_main() */
    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
    n_tests = ntohl(n);

    /* Get max_msg_size from ping_main() */
    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
    max_msg_size = ntohl(n);

    /* Get n_msg_sizes from ping_main() */
    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
    n_msg_sizes = ntohl(n);

    /* Allocate room for the message buffer */
    msgbuf = (char *) malloc(max_msg_size);

    /* Do the calibration */
    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
    msg_size = ntohl(n);
    n_iters = CALIBRATE_ITERS;
    for (j = 0; j < n_iters; j++)
    {
	fd_read(ping_fd, msgbuf, msg_size, PP_TRUE);
	fd_write(ping_fd, msgbuf, msg_size, PP_TRUE);
    }

    /* Get n_iters from ping_main() */
    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
    starting_n_iters = ntohl(n);

    /* Run timings */
    for (ntest = 0; ntest < n_tests; ntest++)
    {
	n_iters = starting_n_iters;
	
	for (i = 0; i < n_msg_sizes; i++)
	{
	    /* Get msg_size from ping_main() */
	    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
	    msg_size = ntohl(n);

	    for (j = 0; j < n_iters; j++)
	    {
		fd_read(ping_fd, msgbuf, msg_size, PP_TRUE);
		fd_write(ping_fd, msgbuf, msg_size, PP_TRUE);
	    }
	    
	    /* Get an n_iters from ping_main() */
	    fd_read(ping_fd, &n, sizeof(n), PP_TRUE);
	    n_iters = ntohl(n);
	}
    }
    
    free(msgbuf);
} /* pong_main() */


/*
 * invoke_pong()
 */
fd_t invoke_pong(char *pong_host, char *executable)
{
    char pwd[1024], cmdbuf[2048];
    int listen_fd, pong_fd, port;
    char *s;

#if defined(_HPUX_SOURCE) || defined(SOLARIS)
    getcwd(pwd,1024);
#else    
    getwd(pwd);
#endif
    strip_tmp_mnt_from_path(pwd);
    
    strcpy(pong_host_save, pong_host);
    
    if ((s = getenv("PP_HOSTNAME")) != (char *) NULL)
    {
	strcpy(ping_host_save, s);
    }
    else
    {
	gethostname(ping_host_save, sizeof(ping_host_save));
    }

    if ((s = getenv("PP_REMOTE_PWD")) != (char *) NULL)
    {
	strcpy(pwd, s);
    }

    listen_fd = setup_listener(&port);

#ifdef DEBUG
    printf("Listening on %d\n", port);
#endif
    
    sprintf(cmdbuf, "%s -c %s %d",
	    executable, ping_host_save, port);

    if (getenv("PP_NOSTART") != (char *) NULL)
    {
	printf("Would run \"cd %s; %s\"\n", pwd, cmdbuf);
    }
    else
    {
	start_remote_node(pong_host, cmdbuf, pwd);
    }

    pong_fd = accept_new_connection(listen_fd);

#ifdef DEBUG
    printf("Got connection\n");
#endif

#ifdef SSL
    {
	SSLHandle *pong_handle;
	int createflags;
	int rv;
	
	read_certificate(1);
	
	createflags = SSL_ENCRYPT | SSL_NO_PROXY;
	pong_handle = SSL_Create(pong_fd, createflags);
	
	/* Do SSL handshake */
	rv = SSL_Handshake(pong_handle, SSL_HANDSHAKE_AS_SERVER);
	if (rv < 0)
	{
	    printf("SSL handshake failed\n");
	    exit(1);
	}

	printf("SSL Handshake succeeded.\n");
	return (pong_handle);
    }
#else  /* SSL */
    return (pong_fd);
#endif /* SSL */
    
} /* invoke_pong() */



/******************************************************************
 *	Basic TCP routines
 ******************************************************************/

/*
 * accept_new_connection()
 *
 * Do an accept() on the passed 'fd', and then setup and return
 * a new conn_t for that connection so that the normal send/recv
 * operations can be used over this connection.
 *
 * This must put the connection in an established state.  It must
 * be able to subsequently be used for communication.
 */
int accept_new_connection(int fd)
{
    struct sockaddr_in from;
    int new_fd;
    int len;
    
    len = sizeof(from);
    new_fd = accept(fd, (struct sockaddr *) &from, &len);
    if (new_fd < 0)
    {
	printf("Fatal error: accept_new_connection(): accept() failed: %s\n", sys_errlist[errno]);
	exit(1);
    }

    config_socket(new_fd);

#ifdef DEBUG
    if (debug_level >= 1)
    {
	struct hostent *hp;
	hp = gethostbyaddr((char *) &from.sin_addr, sizeof(from.sin_addr),
			   from.sin_family);
	printf("Notice: Got conn from %s/%d on %d\n",
	       hp->h_name, ntohs(from.sin_port), new_fd);
    }
#endif

    return (new_fd);
} /* accept_new_connection() */


/*
 * config_socket()
 *
 * Configure the passed socket (a file descriptor) with:
 *	- no delay: Keep the TCP driver from delaying
 *			outgoing packets to coalescing
 *	- keepalive: Periodically send messages down the socket
 *			so as to be able to detect if the process
 *			on the other end of the socket has died
 *	- non-blocking: read() and write() operations will not block
 */
void config_socket(int s)
{
#   if defined(TCP_NODELAY)
    {
	int one = 1;
	if (setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *) &one,
		       sizeof(one)) < 0)
	{
	    printf("Warning: config_socket(): setsockopt TCP_NODELAY failed: %s\n", sys_errlist[errno]);
	}
    }
#   endif
    
#   if defined(SO_KEEPALIVE)
    {
	int one = 1;
	if (setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, (char *) &one,
		       sizeof(one)) < 0)
	{
	    printf("Warning: config_socket(): setsockopt SO_KEEPALIVE failed: %s\n", sys_errlist[errno]);
	}
    }
#   endif

#   if PP_SNDBUF_SIZE != 0
#   if defined(SO_SNDBUF)
    {
	int sock_buffsize = PP_SNDBUF_SIZE;
	if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *) &sock_buffsize,
		       sizeof(sock_buffsize)) < 0)
	{
	    printf("Warning: config_socket(): setsockopt SO_SNDBUF failed: %s\n", sys_errlist[errno]);
	}
    }
#   endif

#   if defined(SO_RCVBUF)
    {
	int sock_buffsize = PP_SNDBUF_SIZE;
	if (setsockopt(s, SOL_SOCKET, SO_RCVBUF, (char *) &sock_buffsize,
		       sizeof(sock_buffsize)) < 0)
	{
	    printf("Warning: config_socket(): setsockopt SO_RCVBUF failed: %s\n", sys_errlist[errno]);
	}
    }
#   endif
#endif
    
#if 0
#ifndef SSL
    set_nonblocking(s);
#endif
#endif
} /* config_socket() */


/*
 * set_nonblocking()
 *
 * Set the passed file descriptor, fd, to non-blocking.  (Calls
 * to read() and write() on that fd will not block.)
 */
void set_nonblocking(int fd)
{
    int flags;
    
    if ((flags = fcntl(fd, F_GETFL, 0)) < 0)
    {
	printf("Fatal error: set_nonblocking(): fcntl F_GETFL 1: %s\n",
	       sys_errlist[errno]);
	exit(1);
    }

#if defined(_HPUX_SOURCE)
    flags |= O_NONBLOCK;
#else
    flags |= O_NDELAY;
#endif

    if (fcntl(fd, F_SETFL, flags) < 0)
    {
	printf("Fatal error: set_nonblocking(): fcntl F_SETFL: %s\n",
	       sys_errlist[errno]);
	exit(1);
    }

#ifdef F_SETFD
    /* Set close-on-exec for this fd */
    if (fcntl(fd, F_SETFD, 1) < 0)
    {
	printf("Fatal error: set_nonblocking(): fcntl F_SETFD: %s\n",
	       sys_errlist[errno]);
	exit(1);
    }
#endif
} /* set_nonblocking() */


/*
 * do_connect()
 */
fd_t do_connect(char *host, int port)
{
    struct sockaddr_in his_addr, use_his_addr;
    int s;
    bool_t connect_succeeded = PP_FALSE;
    int connect_failures = 0;
    struct hostent *hp;
    long pid, write_rc;

#ifdef DEBUG    
    if (debug_level >= 2)
	printf("Connecting to %s/%d\n", host, port);
#endif
    
    hp = gethostbyname(host);
    if (hp == (struct hostent *) NULL)
    {
	printf("Fatal error: do_connect(): gethostbyname %s failed\n", host);
	exit(1);
    }
    
    ZeroOutMemory(&his_addr, sizeof(his_addr));

    his_addr.sin_port = htons(port);
    memcpy(&his_addr.sin_addr, hp->h_addr, hp->h_length);
    his_addr.sin_family = hp->h_addrtype;

    while (!connect_succeeded)
    {
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
	    printf("Fatal error: do_connect(): Failed to create socket: %s %hu: %s\n",
		   host, port, sys_errlist[errno]);
	    exit(1);
	}
	use_his_addr = his_addr;

	if (connect(s, (struct sockaddr *) &use_his_addr,
		    sizeof(use_his_addr)) == 0)
	{
	    connect_succeeded = PP_TRUE;
	}
	else
	{
	    if (errno == EINPROGRESS)
	    {
		/*
		 * man connect: EINPROGRESS:
		 *   The socket is non-blocking and the connection
		 *   cannot be completed immediately. It is possible to
		 *   select(2) for completion by selecting the socket
		 *   for writing.
		 * So this connect has, for all practical purposes, succeeded.
		 */
                connect_succeeded = PP_TRUE;
#ifdef DEBUG		
		printf("do_connect(): Connect to %s/%d got EINPROGRESS: %s\n",
		       host, port, sys_errlist[errno]);
#endif /* DEBUG */		
            }
	    else if (errno == EINTR)
	    {
#ifdef TARGET_ARCH_SUNOS41
		/*
		 * With SunOS 4.1.3 (at least when used
		 * with FSU pthreads), connect() has
		 * an annoying little bug.  It may return EINTR, but
		 * still succeed.  When using round robin scheduling,
		 * where SIGALRM is used to timeslice between threads,
		 * this bug actually occurs with surprising frequency.
		 *
		 * My first attempted solution was to call getpeername(),
		 * with the idea that if it succeeds then the connect()
		 * succeeded, and if it failed then the connect() failed.
		 * This didn't work; getpeername() would sometime fail
		 * yet the connect() would still succeed.
		 *
		 * But it appears that selecting the file descriptor
		 * for writing causes it to wait until things are sane.
		 * (This idea comes from EINPROGRESS.)  And it also
		 * appears that when connect() returns EINTR it
		 * nonetheless always succeeds.
		 *
		 * Note that sometimes the select() returns EINTR,
		 * so we need to retry the select() in that case.
		 * And the EBADF check is just for good measure, as
		 * this would seem to catch the (as yet unobserved)
		 * case where the interrupted connect() actually
		 * failed.
		 */
		fd_set my_fd_set;
		int select_rc;
		int select_loop_done = PP_FALSE;
		while (!select_loop_done)
		{
		    FD_ZERO(&my_fd_set);
		    FD_SET(s, &my_fd_set);
		    select_rc = select(s+1,
				       PP_FD_SET_CAST NULL,
				       PP_FD_SET_CAST &my_fd_set,
				       PP_FD_SET_CAST NULL,
				       NULL);
		    if (select_rc == 1)
		    {
			select_loop_done = PP_TRUE;
			connect_succeeded = PP_TRUE;
		    }
		    else
		    {
			if (errno == EBADF)
			{
			    select_loop_done = PP_TRUE;
			}
			else if (errno != EINTR)
			{
			    printf("Fatal error: do_connect(): Ack! connect() returned EINTR, but selecting on the socket failed (select returned %d, errno=%d).  Guess its time to try another hack around this connect() bug.\n", select_rc, errno);
			    exit(1);
			}
		    }
		}
		
#else  /* TARGET_ARCH_SUNOS41 */
		
		/*
		 * Do nothing.  Just try again.
		 */
#ifdef DEBUG		
		printf("do_connect(): Connect to %s/%d, got EINTR.  Retrying...\n", host, port);
#endif /* DEBUG */		
		
#endif /* TARGET_ARCH_SUNOS41 */
	    }
	    else if (errno == ECONNREFUSED)
	    {
#ifdef DEBUG		
		printf("do_connect(): Connect to %s/%d refused.  Retrying...\n", host, port);
#endif /* DEBUG */
		close(s);
	    }
	    else
	    {
		printf("Fatal error: do_connect(): Connect to %s/%d failed: %s\n",
		       host, port, sys_errlist[errno]);
		exit(1);
	    }
	}
    }

    config_socket(s);

#ifdef SSL
    {
	SSLHandle *handle;
	int createflags;
	int rv;

	read_certificate(0);
	
	createflags = SSL_ENCRYPT | SSL_NO_PROXY;
	handle = SSL_Create(s, createflags);
	
	/* Do SSL handshake */
	rv = SSL_Handshake(handle, SSL_HANDSHAKE_AS_CLIENT);
	if (rv < 0)
	{
	    printf("SSL handshake failed\n");
	    exit(1);
	}

#ifdef DEBUG
	printf("SSL Handshake succeeded.\n");
#endif
	
	return (handle);
    }
#else  /* SSL */
    return (s);
#endif /* SSL */
} /* do_connect() */


/*
 * setup_listener()
 */
int setup_listener(int *port)
{
    struct sockaddr_in my_addr;
    int len;
    int listen_fd;
    
    ZeroOutMemory(&my_addr, sizeof(my_addr));

    my_addr.sin_addr.s_addr = INADDR_ANY;
    my_addr.sin_family = AF_INET;
    my_addr.sin_port = 0;

    listen_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (listen_fd < 0)
    {
	printf("Error: setup_listener(): socket() failed");
	return -1;
    }

    if (bind(listen_fd, (struct sockaddr *) &my_addr, sizeof(my_addr)) < 0)
    {
	printf("Error: setup_listener(): bind() failed");
	close(listen_fd);
	return -1;
    }

    if (listen(listen_fd, SOMAXCONN) < 0)
    {
	printf("Error: setup_listener(): listen() failed");
	close(listen_fd);
	return -1;
    }

    len = sizeof(my_addr);
    if (getsockname(listen_fd, (struct sockaddr *) &my_addr, &len) < 0)
    {
	printf("Error: setup_listener(): getsockname() failed");
	close(listen_fd);
	return -1;
    }

    *port = ntohs(my_addr.sin_port);

    return listen_fd;
} /* setup_listener() */
    

/*
 * fd_write()
 *
 * 'fd' is a non-blocking file descriptor. (Actually, it can be a
 * blocking fd as well, but then this routine is overkill).
 *
 * Write 'len' bytes starting at 'buf' to 'fd'.
 *
 * If 'blocking' is TRUE, then keep trying until the entire thing is written.
 * If 'blocking' is FALSE, then only write until the write would block.
 *
 * Do all error handling here, so that the calling routine does not
 * have to deal with that.
 *
 * Return: The number of bytes actually written.
 */
#ifdef SSL
int fd_write(fd_t fd, void *buf, int len, bool_t blocking)
{
    MyAssert(blocking);
    return(SSL_Write(fd, buf, len));
}
#else  /* SSL */
int fd_write(fd_t fd, void *buf, int len, bool_t blocking)
{
    int n_left = len;
    int n_sent;
    int write_len;
    char *send_ptr = (char *) buf;

    while (n_left > 0)
    {
	write_len = n_left;
	n_sent = write(fd, send_ptr, write_len);
	if (n_sent < 0)
	{
	    if (errno == EWOULDBLOCK)
	    {
		if (blocking)
		{
		    /*
		    printf("fd_write(): would block\n");
		    */
		    continue;
		}
		else
		{
		    break;
		}
	    }
	    else
	    {
		printf("Fatal error: fd_write(): Write failed: %s\n",
		       sys_errlist[errno]);
		exit(1);
	    }
	}
	
	MyAssert(n_sent != 0);
	
	n_left -= n_sent;
	send_ptr += n_sent;

	/*
	if (n_left > 0)
	{
	    printf("fd_write(): write() only did partial write, n_left=%d\n", n_left);
	}
	*/
    }

    MyAssert((!blocking) || (blocking && (n_left == 0)));
    
    return (len - n_left);
} /* fd_write() */
#endif /* SSL */


/*
 * fd_read()
 *
 * 'fd' is a non-blocking file descriptor. (Actually, it can be a
 * blocking fd as well, but then this routine is overkill).
 *
 * Read 'len' bytes into 'buf' from 'fd'.
 *
 * If 'blocking' is TRUE, then keep trying until the entire thing is read.
 * If 'blocking' is FALSE, then only read until the read would block.
 *
 * Do all error handling here, so that the calling routine does not
 * have to deal with that.
 *
 * This routine should never hit EOF, since a close
 * message is sent down the pipe before closing fds.
 *
 * Return: The number of bytes actually read,
 *	   0 if no bytes are read (this can only happen if blocking==FALSE)
 */
#ifdef SSL
int fd_read(fd_t fd, void *buf, int len, bool_t blocking)
{
    MyAssert(blocking);
    return(SSL_Read(fd, buf, len));
}
#else  /* SSL */
int fd_read(fd_t fd, void *buf, int len, bool_t blocking)
{
    int n_read;
    int n_left = len;
    char *read_ptr = (char *) buf;

    while (n_left > 0)
    {
	n_read = read(fd, read_ptr, n_left);
	
	if (n_read < 0)
	{
	    if (errno == EINTR)
	    {
		/*
		 * The read() got interrupted (for example, by a signal),
		 * so retry the read.
		 */
		continue;
	    }
	    else if (errno == EWOULDBLOCK)
	    {
		/*
		 * The read() would have blocked without reading anything.
		 * If blocking, keep trying.
		 * If non-blocking, quit trying and return.
		 */
		if (blocking)
		{
		    continue;
		}
		else
		{
		    break;
		}
	    }
	    else
	    {
		printf("Fatal error: fd_read() Read failed: %s\n",
		       sys_errlist[errno]);
		exit(1);
	    }
	}
	else if (n_read == 0)
	{
	    /*
	     * Got EOF, so die...
	     */
	    int len;
	    struct sockaddr_in addr;
	    
	    len = sizeof(addr);
	    if (getpeername(fd, (struct sockaddr *) &addr, &len) == 0)
	    {
		printf("Fatal error: fd_read(): got EOF for fd %d connected to %s/%d\n",
		       fd,
		       (char *) inet_ntoa(addr.sin_addr),
		       htons(addr.sin_port));
		exit(1);
	    }
	    else
	    {
		printf("Fatal error: fd_read() got EOF in mid-message for fd %d\n",
		       fd);
		exit(1);
	    }
	}

	n_left -= n_read;
	read_ptr += n_read;
    }
    
    MyAssert((!blocking) || (blocking && (n_left == 0)));

    return (len - n_left);
} /* fd_read() */
#endif /* SSL */


#ifdef NO_MEMMOVE
/*
 * memmove()
 */
void *memmove(void *Dest, void *Src, int Length)
{
    char *__Src = ((char *) (Src));
    char *__Dest = ((char *) (Dest));
    char *__EndSrc = (__Src + (Length));
    char *__EndDest = (__Dest + (Length));
    if ( (__Src < __Dest) && (__Dest < __EndSrc) )
    {
	/* Overlapping, with __Dest > __Src, so copy from end */
	while (__EndSrc > __Src)
	{
	    *(--__EndDest) = *(--__EndSrc);
	}
    }
    else if ( (__Dest < __Src) && (__Src < __EndDest) )
    {
	/* Overlapping, with __Dest < __Src, so copy from beginning */
	while (__Src < __EndSrc)
	{
	    *(__Dest++) = *(__Src++);
	}
    }
    else if ( __Src != __Dest )
    {
	/* Non-overlapping (and not the same), so memcpy() can be trusted */
	memcpy(Dest,Src,Length);
    }
    return(Dest);
} /* memmove() */
#endif /* NO_MEMMOVE */


#ifdef SSL
/*
 * read_certificate()
 */
void read_certificate(int is_server)
{
    char *fn;
    FILE *fp;
    RSAPrivateKey *key;
    unsigned char *cert;
    unsigned certlen;
    int rv;
    char *pw;
    int pw_len;
    
    fn = (char*) malloc(strlen(KEYDIR)+100);
    sprintf(fn, "%s/%s", KEYDIR, "Cert.txt");
    fp = fopen(fn, "r");
    if (!fp)
    {
	printf("Error opening certificate file \"%s\": %d",
	       fn, errno);
	exit(1);
    }
    rv = S_ReadCertificate(&cert, &certlen, fp);
    if (rv)
    {
	printf("bad certificate file \"%s\"", fn);
	exit(1);
    }
    fclose(fp);
    
    if (is_server)
    {
	sprintf(fn, "%s/%s", KEYDIR, "Key.der");
	fp = fopen(fn, "r");
	if (!fp)
	{
	    printf("Error opening key file \"%s\": %d", fn, errno);
	    exit(1);
	}
	/*
	pw = S_GetPassword("Key File Password: ");
	*/
	pw = KEY;
	key = PKCS8_ReadPrivateKey(fp, pw);
	free(pw);
	if (!key)
	{
	    printf("bad key file \"%s\"", fn);
	    exit(1);
	}
	
	SSL_ServerInfo(cert, certlen, key);
    }
    else
    {
	key = NULL;
	SSL_ClientInfo(cert, certlen, key);
    }
} /* read_certificate() */
#endif /* SSL */
