/*
 * qoslib.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/libraries/nexus/qoslib.h,v 1.5 2000/01/06 19:26:09 bresnaha Exp $"
 *
 * QoS Request Definitions
 */

#ifndef _NEXUS_INCLUDE_QOSLIB_H
#define _NEXUS_INCLUDE_QOSLIB_H

#ifndef EXTERN_C_BEGIN
#    ifdef __cplusplus
#        define EXTERN_C_BEGIN extern "C" {
#        define EXTERN_C_END }
#    else
#        define EXTERN_C_BEGIN
#        define EXTERN_C_END
#    endif
#endif

EXTERN_C_BEGIN

#include <nexus_resource.h>

#ifdef  QOS_USE_RSVP
#include <rapi_lib.h>
#endif  /* QOS_USE_RSVP */

/* QoSMan Operatoins */

#define QOS_RESOURCE_OP		0x00
#define QOS_LIST_OP		0x01
#define QOS_DETACH_OP		0x02
#define QOS_TERMINATE_OP	0x03

/*  QosLib Return Codes  */

#define QOS_FAILURE      -1
#define QOS_SUCCESS       0
#define QOS_NOT_ATTACHED  1


typedef int qos_status_obj;

typedef void (qos_callback)(nexus_resource_name_t *, qos_status_obj *);

typedef struct {
        const nexus_resource_name_t 	*who;
        qos_callback 			*proc;
} qos_request_obj;

typedef enum {
#define QOS_SPEC_NTYPES	3
	QOS_SPEC_NULL = 0,
	QOS_SPEC_DEFAULT = 1,
	QOS_SPEC_IS = 2
} qos_spec_t;

typedef struct {
	unsigned int service;	
        float r;		/* Token bucket avg rate (Bps) */
        float b;		/* Token bucket depth (B) */
        float p;		/* Peak data rate (Bps) */
        unsigned long m;	/* Min policed unit (B) */
        unsigned long M;	/* Max pkt size (B)     */
} qos_spec_is;

typedef union {
	qos_spec_is	is;
} qos_spec;

typedef struct {
        const nexus_resource_name_t 	*who;
        qos_callback 			*proc;
	int	 			spec_type;
  	qos_spec			spec;
} qos_request_socket;

typedef struct {
        const nexus_resource_name_t 	*who;
        qos_callback 			*proc;
#ifdef QOS_USE_POSIX_SCHED
        qos_sched_class_t 		class;
        qos_sched_priority_t 		priority;
#endif /* QOS_USE_POSIX_SCHED */
} qos_request_process;

typedef struct {
        const nexus_resource_name_t 	*who;
        qos_callback 			*proc;
#ifdef QOS_USE_POSIX_SCHED
        qos_sched_class_t 		class;
        qos_sched_priority_t 		priority;
#endif /* QOS_USE_POSIX_SCHED */
} qos_request_thread;


typedef struct {
        const nexus_resource_name_t 	*who;
        qos_callback 			*proc;
        nexus_bool_t	 		lock;
} qos_request_memory;


typedef union {
	qos_request_obj		object;
	qos_request_socket	socket;
	qos_request_process	process;
	qos_request_thread	thread;
	qos_request_memory	memory;
} qos_request_info;

extern int qos_request(qos_request_obj *);

extern int qos_sizeof_request(qos_request_obj*, int);
extern void qos_request_put(nexus_buffer_t*, qos_request_obj*);
extern void qos_request_get(nexus_buffer_t*, qos_request_obj*);

extern void qos_list_qosman( void );

EXTERN_C_END

#endif /* _NEXUS_INCLUDE_QOSLIB_H */
