/*
 * Nexus
 * Authors:     James Stepanek
 *              Aerospace
 *
 * overseer_iface.c	- Overseer Interface
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/libraries/nexus/overseer_iface.c,v 1.5 1998/08/24 16:40:39 stepanek Exp $";


#include "internal.h"

#ifdef BUILD_RESOURCE

#include <sys/socket.h>
#include <netinet/in.h>

#include "nexus_resource.h"


void nexus_overseer_init(nexus_module_list_t module_list[]);
void nexus_overseer_shutdown(nexus_bool_t shutdown_others);

int nexus_overseer_rusage(nexus_rusage_obj* rusage_obj);

/*
 * Overseer module list
 */
typedef struct _overseer_module_list_t   {
  char *				name;
  nexus_overseer_funcs_t *		funcs;
  struct _overseer_module_list_t *	next;
} overseer_module_list_t;

static overseer_module_list_t *	overseer_module_list_head;
static overseer_module_list_t *	overseer_module_list_tail;

#define AddOverseerModuleToList(Caller, Name, Funcs) \
{ \
    overseer_module_list_t *__rs; \
    NexusMalloc(Caller, __rs, overseer_module_list_t *, \
		sizeof(overseer_module_list_t)); \
    __rs->name = _nx_copy_string(Name); \
    __rs->funcs = (Funcs); \
    __rs->next = (overseer_module_list_t *) NULL; \
    if (overseer_module_list_head) \
    { \
	overseer_module_list_tail->next = __rs; \
	overseer_module_list_tail = __rs; \
    } \
    else \
    { \
	overseer_module_list_head = overseer_module_list_tail = __rs; \
    } \
}



/* 
 *  Initialize all overseer modules
 */ 
void nexus_overseer_init(nexus_module_list_t module_list[])    {

  int i;
  nexus_overseer_funcs_t *overseer_funcs;
  overseer_module_list_t *overseer_module;
  nexus_context_t * context;
  nexus_rusage_process current_process;

  /*
   * Scan the module_list looking for overseer modules.
   * For each of these, get the function table,
   * and add that module to the overseer_module_list.
   */
  for (i = 0; module_list[i].family_name != (char *) NULL; i++)    {
    
    if ((strcmp(module_list[i].family_name, "overseers") == 0))   {

      overseer_funcs
	= (nexus_overseer_funcs_t *) (*module_list[i].info_func)();
      AddOverseerModuleToList(nexus_overseer_init(),
			      module_list[i].module_name,
			      overseer_funcs);

    }

  }

  /*
   * Initialize each overseer module
   */
  for (overseer_module = overseer_module_list_head;
       overseer_module; 
       overseer_module = overseer_module->next)     {
    
    (*overseer_module->funcs->init)();

  }


  /*
   * process creation notification
   */

  _nx_context(&context);

  nexus_resource_name(&context->resource_name, RESOURCE_PROCESS);

  current_process.who = &context->resource_name;
  current_process.op = RUSAGE_CREATE;
  current_process.pid = globus_libc_getpid();

  nexus_overseer_rusage((nexus_rusage_obj*)&current_process);

}  /* nexus_overseer_init() */


/*
 * nexus_overseer_shutdown()
 *
 * If 'shutdown_others' is NEXUS_TRUE,
 * then try to shutdown all other nodes and contexts.
 */
void nexus_overseer_shutdown(nexus_bool_t shutdown_others)   {

  overseer_module_list_t *overseer_module;

  /* shutdown implies detachment implies destruction of all
     resources associated with this process
  */

  for (overseer_module = overseer_module_list_head;
       overseer_module;
       overseer_module = overseer_module->next)   {

    if (overseer_module->funcs->shutdown)   {

      (overseer_module->funcs->shutdown)(shutdown_others);

    }

  }

} /* nexus_overseer_shutdown() */


/* 
 * nexus_overseer_rusage
 */
int 
nexus_overseer_rusage(nexus_rusage_obj* rusage_obj)   {

  if (rusage_obj) {

    overseer_module_list_t *overseer_module;
    
    for (overseer_module = overseer_module_list_head;
	 overseer_module;
	 overseer_module = overseer_module->next)   {
      if (overseer_module->funcs->rusage)    {

	(overseer_module->funcs->rusage)(rusage_obj);

      }

    }

  }

  return (0);

} /* nexus_overseer_rusage */





#endif /* BUILD_RESOURCE */
