/*
 * th_p_i.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/libraries/nexus/old/th_p0_i.h,v 1.1 1998/04/22 07:06:10 toonen Exp $"
 */

typedef struct _nexus_thread_name_list_t
{
    char *				name;
    struct _nexus_thread_name_list_t *	next;
} nexus_thread_name_list_t;

typedef struct __nx_thread_t
{
    int					id;
    nexus_thread_name_list_t *		names;
    void *				context;
    nexus_thread_func_t			user_func;
    void *				user_arg;
    struct __nx_thread_t *		next_free;

#ifdef BUILD_RESOURCE
    nexus_resource_name_t		resource_name;
#endif /* BUILD_RESOURCE */

} _nx_thread_t;

/*
 * _nx_thread_self()
 *
 * Set *Thread (_nx_thread_t **) to the calling thread.
 */
#define _nx_thread_self(Thread) \
{  \
    *(Thread) = (_nx_thread_t *)ports0_thread_getspecific(nexus_all_global_vars.nexus_thread_t_pointer); \
}

/*
 * _nx_thread_id()
 *
 * Set *Thread_ID (int *) to be the thread id of the calling thread.
 */
#define _nx_thread_id(Thread_ID) \
{ \
    _nx_thread_t *__nx_thread; \
    _nx_thread_self(&__nx_thread); \
    *(Thread_ID) = __nx_thread->id; \
}

extern void _nx_thread_prefork(void);
extern void _nx_thread_postfork(void);
