/*
 * init.c
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/libraries/nexus/init.c,v 1.87 2000/04/05 22:00:02 bresnaha Exp $";

#define NEXUS_DEFINE_GLOBALS
#include "internal.h"
#include "globus_io.h"

extern void *_nx_pr_tcp_info(void);
#define NEXUS_USE_TCP_PROTO	{"protocols", "tcp", _nx_pr_tcp_info},

extern void *_nx_pr_udp_info(void);
#define NEXUS_USE_UDP_PROTO	{"protocols", "udp", _nx_pr_udp_info},

extern void * globus_i_nexus_pr_mpl_info(void);
#define NEXUS_USE_MPL_PROTO	\
    {"protocols", "mpl", globus_i_nexus_pr_mpl_info},

extern void * globus_i_nexus_pr_mpi_info(void);
#define NEXUS_USE_MPI_PROTO	\
    {"protocols", "mpi", globus_i_nexus_pr_mpi_info},

extern void * globus_i_nexus_pr_inx_info(void);
#define NEXUS_USE_INX_PROTO	\
    {"protocols", "inx", globus_i_nexus_pr_inx_info},

extern void *_nx_pr_shm_info(void);
#define NEXUS_USE_SHM_PROTO	{"protocols", "shm", _nx_pr_shm_info},

extern void *_nx_pr_totem_info(void);
#define NEXUS_USE_TOTEM_PROTO	{"protocols", "totem", _nx_pr_totem_info},

/* docing out all xtp : bresnaha
extern void *_nx_pr_xtp_info(void);
#define NEXUS_USE_XTP_PROTO	{"protocols", "xtp", _nx_pr_xtp_info},
*/

#if (defined HAVE_QOS) && (defined BUILD_RESOURCE)
extern void *nexus_overseer_qos_info(void);
#define NEXUS_USE_QOS_OVERSEER {"overseers", "qos", nexus_overseer_qos_info},
#else
#define NEXUS_USE_QOS_OVERSEER
#endif


extern void *_nx_rdb_file_info(void);
extern void *_nx_transform_perf_info(void);


static nexus_module_list_t default_module_list[] =
{
    NEXUS_USE_SHM_PROTO
    NEXUS_USE_MPL_PROTO
    NEXUS_USE_MPI_PROTO
    NEXUS_USE_INX_PROTO
    NEXUS_USE_TCP_PROTO
    NEXUS_USE_QOS_OVERSEER
    NEXUS_USE_UDP_PROTO
    NEXUS_USE_TOTEM_PROTO
/*    NEXUS_USE_XTP_PROTO
*/    {"rdb", "file", _nx_rdb_file_info},
    {"transform", "perf", _nx_transform_perf_info},
    {NULL, NULL, NULL},
};


static globus_bool_t		globus_l_nexus_initialized = NEXUS_FALSE;

/*
 * globus_i_nexus_activate()
 */
int
globus_i_nexus_activate(void)
{
    int			rc = NEXUS_SUCCESS;
    nexus_context_t *	context;
    char *              tmp_char_ptr;

    if (globus_l_nexus_initialized)
    {
	/* Fail if you try to reinitialize */
	return(GLOBUS_FAILURE);
    }
    else
    {
	globus_l_nexus_initialized = NEXUS_TRUE;
    }
    
    /*
     * Do some global initializations
     */
    _nx_pausing_for_fatal = NEXUS_FALSE;
    _nx_pause_on_fatal = NEXUS_FALSE;
    _nx_stdout = stdout;
    /*
    _nx_stdout = stderr;
    */

#ifdef BUILD_DEBUG
    {
	char *debug_level_string
	    = globus_libc_getenv("GLOBUS_NEXUS_DEBUG_LEVEL");
        if(debug_level_string != GLOBUS_NULL)
	{
    	    _nx_debug_level = atoi(debug_level_string);
        }
	else
	{
	    _nx_debug_level = 0;
	}
    }
#endif /* BUILD_DEBUG */
    
    /*
     * Initialize the fundamental modules.
     * Everything else depends on these being initialized.
     */
     rc = globus_module_activate(GLOBUS_COMMON_MODULE);
     if(rc != GLOBUS_SUCCESS)
     {
  	 printf("globus common activate failed\n");
         return rc;
     }

    tmp_char_ptr = globus_module_getenv("GLOBUS_NEXUS_TCP_MINIMUM_MESSAGE_SIZE");
    if(tmp_char_ptr == GLOBUS_NULL)
    {
        _nx_tcp_mim_msg_size = 0;
    }
    else
    {
        _nx_tcp_mim_msg_size = atoi(tmp_char_ptr);
    }
    /*
     * Initialize context management code,
     * and create an initial context for this process and this thread.
     * Dependencies:
     */
    _nx_context_init();
    context = _nx_context_alloc();
    _nx_set_context(context);
    _nx_initial_context = context;

    /*
     * Initialize event driver
     * Dependencies:
     *		_nx_thread_init();
     */
    globus_module_activate(GLOBUS_THREAD_MODULE);
    /* replace nexus_fd_init() with globus_io activate */

    rc = globus_module_activate(GLOBUS_IO_MODULE);
    if(rc != GLOBUS_SUCCESS)
    {
	printf("globus io activate failed\n");
        return rc;
    }


    /*
     * Initialize fault tolerance
     * Dependencies:
     */
    _nx_fault_tolerance_init();

    /*
     * Initialize rdb
     * Dependencies:
     */
    _nx_rdb_init(default_module_list);

    /*
     * Initialize _nx_my_hostname
     * Dependencies:
     *		_nx_rdb_init()
     */
    globus_libc_gethostname(_nx_my_hostname, MAXHOSTNAMELEN);


    /*
     * Initialize transform modules
     * Dependencies:
     */
    nexus_transform_init(default_module_list);

#ifdef BUILD_RESOURCE
    /*
     * Initialize overseer modules
     * Dependencies:
     */
    nexus_overseer_init(default_module_list);
#endif /* BUILD_RESOURCE */

    /*
     * Initialize protocols
     * Dependencies:
     *		nexus_fd_init()
     */
    _nx_proto_init(default_module_list);

    /*
     * Initialize attachment
     * Dependencies:
     *		nexus_fd_init()
     */
    _nx_attach_init();
    
    /*
     * Initialize transform modules
     * Dependencies:
     */
    _nx_commlink_init();
    
    /*
     * Initialize buffer management
     * Dependencies:
     */
    _nx_buffer_init();

#ifndef BUILD_LITE
    /*
     * Startup a handler thread
     */
    /*_nx_thread_create_handler_thread();*/
#endif /* BUILD_LITE */

  abort:

    return(rc);
} /* globus_i_nexus_activate() */


/*
 * globus_i_nexus_deactivate()
 */
int
globus_i_nexus_deactivate(void)
{
    int rc = NEXUS_SUCCESS;

    if (!globus_l_nexus_initialized)
    {
	return(GLOBUS_SUCCESS);
    }

#ifdef BUILD_RESOURCE
    nexus_overseer_shutdown(NEXUS_FALSE);
#endif
    _nx_proto_shutdown();
    _nx_rdb_shutdown();

    globus_module_deactivate(GLOBUS_IO_MODULE);
    globus_module_deactivate(GLOBUS_THREAD_MODULE);
    globus_module_deactivate(GLOBUS_COMMON_MODULE);

    return(rc);
} /* globus_i_nexus_deactivate() */
