/*
 * globals.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/libraries/nexus/globals.h,v 1.49 2000/04/05 22:00:02 bresnaha Exp $"
 */

#ifndef _NEXUS_INCLUDE_GLOBALS_H
#define _NEXUS_INCLUDE_GLOBALS_H

/*
 * _nx_my_mi_proto
 *
 * initialized in pr_iface.c and used in gp.c
 */
NEXUS_GLOBAL nexus_mi_proto_t *_nx_my_mi_proto;

/*
 * _nx_local_proto
 *
 * nexus_proto_t* for the local protocol module
 */
static nexus_proto_t *_nx_local_proto;

NEXUS_GLOBAL char _nx_my_hostname[MAXHOSTNAMELEN];
/*
 * This is used by the Nexus print routines for output.
 */
NEXUS_GLOBAL FILE 	*_nx_stdout;


/*
 * _nx_master_id_string
 *
 * This is a string that is supplied by the master node which
 * uniquely identifies this Nexus computation.
 */
NEXUS_GLOBAL char *	_nx_master_id_string;


#ifdef BUILD_LITE

/*
 * _nx_lite_context
 *
 * Since NexusLite has only one context in a process, and no threads,
 * the nexus_context_t* is just stored in a global.
 */
NEXUS_GLOBAL nexus_context_t *_nx_lite_context;

#endif /* BUILD_LITE */

/*
 * _nx_context_key
 *
 * This key is used to store the context pointer in thread specific storage.
 */
NEXUS_GLOBAL globus_thread_key_t _nx_context_key;



/*
 * _nx_context_list
 *
 * This is a list of all the contexts within this nexus process
 */
NEXUS_GLOBAL nexus_context_t *_nx_context_list;


/*
 * _nx_initial_context
 * 
 * This is the first context that is created during process
 * initialization.
 */
NEXUS_GLOBAL nexus_context_t *_nx_initial_context;

/*
 * Various debug flags...
 */
#ifdef BUILD_DEBUG
NEXUS_GLOBAL int		    _nx_debug_level;
#endif /* BUILD_DEBUG */


/*
 * For pause points.
 *   _nx_pause_on_fatal==NEXUS_TRUE is Nexus should pause when it hits
 * 	a fatal error.
 *   _nx_pausing_for_fatal==NEXUS_TRUE after we have paused on fatal (used
 *	to avoid looping in the pause.
 */
NEXUS_GLOBAL nexus_bool_t	_nx_pause_on_fatal;
NEXUS_GLOBAL nexus_bool_t	_nx_pausing_for_fatal;


/*
 * _nx_fault_tolerant
 */
NEXUS_GLOBAL nexus_bool_t	_nx_fault_tolerant;

NEXUS_GLOBAL int		_nx_skip_poll_count;

NEXUS_GLOBAL globus_size_t      _nx_tcp_mim_msg_size;

/*
 * _nx_transform_table
 */
NEXUS_GLOBAL nexus_transform_table_t
			_nx_transform_table[NEXUS_TRANSFORM_TABLE_SIZE];

#endif /* _NEXUS_INCLUDE_GLOBALS_H */
