/*
 * funcs.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-current/Globus/Communication/nexus/libraries/nexus/funcs.h,v 1.105 1999/07/27 22:21:14 bresnaha Exp $"
 */

#ifndef _NEXUS_INCLUDE_FUNCS_H
#define _NEXUS_INCLUDE_FUNCS_H

/*
 * attach.c
 */
extern int	_nx_attach_new_process_params(char *buf, int size);
extern void	_nx_attach_init(void);


/*
 * buffer.c
 */
extern void _nx_buffer_init(void);
extern int  _nx_buffer_create_from_raw(nexus_byte_t *raw_buffer,
				       unsigned long raw_size,
				       unsigned long offset_to_message_start,
				       unsigned long message_length,
				       nexus_endpoint_t *endpoint,
				       struct globus_nexus_buffer_s **buffer);
extern int  _nx_buffer_dispatch(struct globus_nexus_buffer_s *buffer);


/*
 * commlink.c
 */
extern void	_nx_commlink_init(void);
extern int	_nx_commlink_new_process_params(char *buf, int size);
extern int	_nx_write_startpoint(globus_io_handle_t * handle, 
				     nexus_startpoint_t *sp);
extern int	_nx_read_startpoint(globus_io_handle_t * handle, 
				    nexus_startpoint_t *sp);
extern void	_nx_startpoint_copy_handler(nexus_endpoint_t *endpoint,
					    nexus_buffer_t *buffer,
					    nexus_bool_t is_non_threaded_handler);

extern
globus_i_nexus_endpoint_id_t
globus_i_nexus_endpoint_table_add(
    globus_nexus_endpoint_t *		endpoint);

extern
int
globus_i_nexus_endpoint_table_remove(
    globus_nexus_endpoint_t *		endpoint);

extern
int
globus_i_nexus_endpoint_table_lookup(
    globus_byte_t *			liba,
    globus_nexus_endpoint_t **		endpoint);


/*
 * context.c
 */
extern void	_nx_context_init(void);
extern void	_nx_context_endpointattr_init();
extern nexus_context_t *_nx_context_alloc();
extern int	_nx_context_new_process_params(char *buf, int size);


/*
 * fault.c
 */
extern int	_nx_fault_tolerance_new_process_params(char *buf, int size);
extern void	_nx_fault_tolerance_init(void);
extern int	_nx_fault_detected(int fault_code);


/*
 * pr_iface.c
 */
extern int
_nx_proto_new_process_params(
    char *buf,
    int size);

extern void
_nx_proto_init(
    nexus_module_list_t module_list[]);

extern void
_nx_proto_shutdown(void);

extern void
_nx_proto_get_creator_sp_params(
    char *buf,
    int buf_size,
    nexus_startpoint_t *sp);

extern void
_nx_proto_construct_creator_sp(
    nexus_startpoint_t *creator_sp);

extern void
_nx_mi_proto_destroy(
    nexus_mi_proto_t *mi_proto);

extern int
_nx_mi_proto_table_insert(
    nexus_mi_proto_t *new_mi_proto,
    nexus_mi_proto_t **return_mi_proto);

extern nexus_mi_proto_t *
_nx_mi_proto_create(
    int size,
    nexus_byte_t *array,
    nexus_proto_t *proto);

extern int
_nx_mi_proto_create_for_proto_type(
    nexus_proto_type_t type,
    void *proto_info,
    nexus_endpoint_t *endpoint,
    nexus_mi_proto_t **return_mi_proto);

extern int
_nx_mi_proto_destroy_for_proto_type(
    nexus_endpoint_t * endpoint,
    nexus_mi_proto_t *mi_proto);

/* added by bresnaha */

extern globus_bool_t
globus_i_is_local_area_network(char * hostname0,
			       char * hostname1);

int globus_i_nexus_get_errno(globus_result_t * result);

/*
 * pr_local.c
 */
extern void *	_nx_pr_local_info(void);


#ifdef BUILD_RESOURCE

/*
 * pr_iface.c
 */

nexus_resource_name_t * 
_nx_mi_proto_name_for_proto_type( nexus_proto_type_t proto_type,
				  nexus_endpoint_t *endpoint );

/*
 * overseer_iface.c
 */

extern void nexus_overseer_init(nexus_module_list_t module_list[]);

#endif /* BUILD_RESOURCE */


/*
 * rdb_iface.c
 */
extern int	_nx_rdb_new_process_params(char *buf, int size);
extern void	_nx_rdb_init(nexus_module_list_t module_list[]);
extern void	_nx_rdb_shutdown(void);
extern nexus_bool_t _nx_rdb_hash_table_lookup(char *name,
					      char *key,
					      char **value);
extern void     _nx_rdb_hash_table_add(char *name,
				       nexus_list_t *attr);
extern nexus_list_t *_nx_rdb_parse_attributes(char *buf,
					      int buf_len,
					      char *starting_point,
					      FILE *fp);
extern void     _nx_rdb_flush_rest_of_line(char *buf,
					   int buf_len,
					   char *starting_point,
					   FILE *fp);
extern void     _nx_rdb_hash_table_add_nodes_with_attrs(
			nexus_rdb_hash_entry_t *nodes,
			nexus_list_t *attrs);

/*
 * transform_iface.c
 */
extern int	nexus_transform_new_process_params(char *buf, int size);
extern int	nexus_transform_init(nexus_module_list_t module_list[]);
extern void	nexus_transform_add_module(char *module_name,
					   void *(*info_func)(void));
extern void     nexus_transform_shutdown(void);
extern void	nexus_transformattr_init(int id,
					 void *info,
					 nexus_transformattr_t **attr);
extern void	nexus_transformattr_destroy(int id,
					    nexus_transformattr_t *attr);
extern void	nexus_transformattr_get_info(int id,
					     nexus_transformattr_t *attr,
					     void **info);
extern void	nexus_transformstate_init_on_endpoint(int id,
					   nexus_transformattr_t *attr,
					   nexus_transformstate_t **ep_state);
extern void	nexus_transformstate_destroy_on_endpoint(int id,
					nexus_transformstate_t *ep_state);
extern void	nexus_transformstate_update_endpoint_with_startpoint_destroy(
				int id,
				nexus_transformstate_t *ep_state,
				nexus_transformstate_t *sp_state);
extern void	nexus_transformstate_init_on_startpoint(int id,
					     nexus_transformstate_t *ep_state,
					     nexus_transformstate_t **sp_state,
					     nexus_bool_t *copy_sp_locally,
					     nexus_bool_t *destroy_sp_locally);
extern void	nexus_transformstate_copy(int id,
			       nexus_transformstate_t *sp_state,
			       nexus_transformstate_t **sp_state_copy);
extern void	nexus_transformstate_destroy_on_startpoint(
					int id,
    					nexus_transformstate_t *sp_state);
extern int	nexus_transformstate_sizeof(int id,
					    nexus_transformstate_t *sp_state);
extern void	nexus_transformstate_put(int id,
					 nexus_byte_t **buffer,
					 nexus_transformstate_t *sp_state);
extern void	nexus_transformstate_get(int id,
					 nexus_byte_t **buffer,
					 int format,
					 nexus_transformstate_t **sp_state);
extern int	nexus_buffer_transform(nexus_startpoint_t *sp,
				       nexus_byte_t *storage_start,
				       unsigned long storage_size,
				       nexus_byte_t *data_start,
				       unsigned long *data_size,
				       nexus_bool_t must_alloc_new_buffer,
				       nexus_byte_t *transform_info_start,
				       nexus_byte_t **out_storage_start,
				       unsigned long *out_storage_size,
				       nexus_byte_t **out_data_start,
				       unsigned long *out_data_size);
extern int	nexus_buffer_untransform(nexus_endpoint_t *ep,
					 nexus_byte_t *data_start,
					 unsigned long *data_size,
					 nexus_byte_t *transform_info_start,
					 int format,
					 nexus_byte_t **destination_start,
					 unsigned long *destination_size);
extern void	nexus_transform_info(int transform_id,
				     nexus_bool_t *modifies_data,
				     unsigned long *transform_info_size,
				     unsigned long *trailer_size);

/*
 * util.c
 */
extern char *	_nx_copy_string(char *s);
extern char *   _nx_find_attribute(char *attr,
				   char *search_string,
				   char separator);
extern void     _nx_get_next_value(char *values,
				   char separator,
				   char **next,
				   char **value);
extern void	_nx_hex_encode_byte_array(unsigned char *bytes,
					  int length,
					  char *hex);
extern void	_nx_hex_decode_byte_array(char *hex,
					  int length,
					  unsigned char *bytes);
#ifndef HAVE_STRTOUL
extern unsigned long strtoul(const char *nptr,
			     char **endptr,
			     int base);
#endif /* HAVE_STRTOUL */
extern globus_result_t	_nx_write_blocking(
	       globus_io_handle_t *                  handle, 
	       void *                                buf, 
	       globus_size_t                         size);

extern globus_result_t	_nx_read_blocking(
			   globus_io_handle_t *      handle, 
			   void *                    buf, 
			   globus_size_t             size);

#endif /* _NEXUS_INCLUDE_FUNCS_H */

