/******************************************************************************
globus_mp_mpi.c

Description:

  MPI activation

CVS Information:

  $Source: /home/globdev/CVS/globus-current/Globus/Communication/mp/library/globus_mp_mpi.c,v $
  $Date: 2000/04/07 05:31:33 $
  $Revision: 1.4 $
  $State: Exp $
  $Author: toonen $
******************************************************************************/

/******************************************************************************
			     Include header files
******************************************************************************/
#define  HAVE_MPI_PROTO 1
#include "globus_mp_mpi.h"


/******************************************************************************
			  Module activation structure
******************************************************************************/
static int
globus_l_mp_mpi_activate(void);

static int
globus_l_mp_mpi_deactivate(void);

static void
globus_l_mp_mpi_atexit(void);


globus_module_descriptor_t		globus_i_mp_mpi_module =
{
    "globus_mp_mpi",
    globus_l_mp_mpi_activate,
    globus_l_mp_mpi_deactivate,
    globus_l_mp_mpi_atexit
};

static globus_bool_t globus_l_mp_mpi_initialized = GLOBUS_FALSE;

/******************************************************************************
			   MPI activation functions
******************************************************************************/
static int
globus_l_mp_mpi_activate(void)
{
    int					initialized;

    MPI_Initialized(&initialized);
    if (!initialized)
    {
	globus_l_mp_mpi_initialized = GLOBUS_TRUE;
	MPI_Init(NULL, NULL);
    }

    return GLOBUS_SUCCESS;
}


static int
globus_l_mp_mpi_deactivate(void)
{
    return GLOBUS_SUCCESS;
}


static void
globus_l_mp_mpi_atexit(void)
{
    if (globus_l_mp_mpi_initialized)
    {
	MPI_Finalize();
    }
}


