/******************************************************************************
globus_duct_runtime_test.c

Description:

    Test program for globus_duct_runtime API. (and globus_duct_control API)

    This program does the following operation in order to test the
    globus_duct_runtime API:
    
    - Check in its  "duct" group (using the control_contact from env. variable)

    - Get the group structure,

    - send data to each nodes.
    
    - wait until it has got data from each other nodes.
    
******************************************************************************/
#include <stdio.h>
#include "globus_common.h"
#include "globus_nexus.h"
#include "globus_duct_runtime.h"
#include "globus_duct_test.h"

int received=0;

typedef void (*duct_test_userdata_callback_t) (int  msg_size,
					       globus_byte_t   * msg);

/******************************************************************************
all the necessary call back 
******************************************************************************/
void
duct_runtime_data_cb(struct globus_duct_runtime_s * runtimep,
		     int                            msg_size,
		     globus_byte_t                * msg,
		     void                         * userdata)
{

    fprintf(stderr, "duct_runtime_data_cb got message from %d\n",(int)*msg);
    
    ((duct_test_userdata_callback_t)userdata)(msg_size,msg);
} /* duct_runtime_data_cb */

void
duct_runtime_data_user_cb(int msg_size,
			  globus_byte_t   *msg)
{
    fprintf(stderr, "duct_runtime_data_user_cb activated\n");
    received++;
    /* I could do better, isn't it ? ...*/
} /* duct_runtime_data_user_cb() */


/******************************************************************************
******************************************************************************/
int
main(
    int					argc,
    char *				argv[])
{
    int rc;
    globus_duct_runtime_t   runtimep;
    char                  * checkin_contact;
    int                     checkin_id;       /* not used ... */

    int                     local_address;
    int                     remote_count;
    int                   * remote_addresses;
    int                     an_addresses;
    int                     remote_addresses_index;
    int                     i;
    unsigned char                    local_address_in_byte;
    
    fprintf(stderr, "Runtime_test started...\n");

    if ( globus_module_activate (GLOBUS_DUCT_RUNTIME_MODULE) != GLOBUS_SUCCESS )
    {
	fprintf(stderr,
		"Activation of Module GLOBUS_DUCT_RUNTIME_MODULE failed !\n");
	exit(1);
    }
    /* get the checkin_contact from env. var. */
    checkin_contact = getenv(GRAM_DUCT_TEST_CHECKIN_CONTACT_ENV_VAR);

    if (checkin_contact == GLOBUS_NULL || strlen(checkin_contact) == 0)
    {
	fprintf(stderr, "No checkin_contact env variable, abort\n");
	exit(1);
	
    }
    fprintf(stderr,"Got checkin_contact %s\n",checkin_contact);
    
    /* Check in its  "duct" group */
    rc = globus_duct_runtime_init (
	&runtimep,
	checkin_contact,
	checkin_id,
	duct_runtime_data_cb,
	(void *)duct_runtime_data_user_cb,
	GLOBUS_NULL,        /* not implemented */
	GLOBUS_NULL);       /* not implemented */
    if (rc != GLOBUS_SUCCESS)
    {
	fprintf(stderr, " globus_duct_runtime_init failed, rc= %d !\n",rc);
	exit(1);
    }
    fprintf(stderr,"globus_duct_runtime_init'ed\n");
    fprintf(stderr,"local_address=%d\n",runtimep.local_address);
	
    /* Get the group structure */

    rc = globus_duct_runtime_structure (
	&runtimep,
	&local_address,
	&remote_count,
	&remote_addresses);
    if (rc != GLOBUS_SUCCESS)
    {
	fprintf(stderr, "Could not get the group structure !\n");
	globus_duct_runtime_destroy(&runtimep);
	exit(1);
    }
    fprintf(stderr,"Got structure, My Address : %d\n",local_address);
    fprintf(stderr,"               Group size : %d\n",remote_count+1);
    for (i=0; i< remote_count; i++)
    {
	fprintf(stderr,"               Addr[%d]: %d\n",i,remote_addresses[i]);
    }
    
    /* send data to each nodes */
    /* Just to not bother with ordering I want to send only one byte */
    if ( (local_address > 255) || (local_address < 0) )
    {
	fprintf(stderr, "My local address does not fit in a char, This test does not work !\n");
	globus_duct_runtime_destroy(&runtimep);
	exit(1);
    }	
    local_address_in_byte = (char) local_address;
    fprintf(stderr,"I send my address %d\n",(int)local_address_in_byte);
    
    for (i=0; i< remote_count; i++)
    {
	rc = globus_duct_runtime_send(
	    &runtimep,
	    remote_addresses[i],
	    1,                   /* only one byte */
	    &local_address_in_byte);
	if (rc != GLOBUS_SUCCESS)
	{
	    fprintf(stderr,
		   "Could not send my address to %d !\n",
		   remote_addresses[i]);
	    globus_duct_runtime_destroy(&runtimep);
	    exit(1);
	}
    }
    
    
    /* wait until it has got data from each other nodes. */
    while (received<remote_count)
    {
	globus_poll();
	sleep(1);
    }
    
    fprintf(stderr,
	   "I got  %d messages, I can die!\n",
	   received);

    /* DO NOT forget that, or all the communication will not be
     * correctly terminated and other process might get stuck or die !
     */
    if ( globus_module_deactivate (GLOBUS_DUCT_RUNTIME_MODULE) != GLOBUS_SUCCESS )
    {
	fprintf(stderr,
		"DeActivation of Module GLOBUS_DUCT_RUNTIME_MODULE failed!\n");
	exit(1);
    }    
    exit(0);
}
