/******************************************************************************
globus_duct_runtime.h

Description:

  globus_duct runtime API defintions.  This API defines a simple set
  of communication abstractions to allow a set of processes to
  setup communication through a common manager process.

CVS Information:

  $Source: /home/globdev/CVS/globus-current/Globus/Communication/duct/libraries/runtime/globus_duct_runtime.h,v $
  $Date: 1998/08/18 22:41:48 $
  $Revision: 1.9 $
  $State: Exp $
  $Author: czajkows $
******************************************************************************/

#ifndef GLOBUS_DUCT_RUNTIME_H
#define GLOBUS_DUCT_RUNTIME_H

/******************************************************************************
			     Include header files
******************************************************************************/
#include "globus_common.h"     /* for globus_list_t and globus_hashtable_t */

#include "globus_duct_common.h"


#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 
EXTERN_C_BEGIN

/******************************************************************************
			       Define constants
******************************************************************************/

#define GLOBUS_DUCT_MAX_MSG_LENGTH 8096



/******************************************************************************
				Type definition
******************************************************************************/
struct globus_duct_runtime_s; 

typedef void (*globus_duct_data_callback_t) (struct globus_duct_runtime_s * runtimep,
				      int                     msg_size,
				      globus_byte_t   * msg,
				      void                  * userdata);

typedef void *globus_duct_config_callback_t;

typedef struct globus_duct_runtime_config_port_s {
  globus_nexus_endpointattr_t   epattr;
  globus_nexus_endpoint_t       ep;
  globus_nexus_startpoint_t     sp;
} globus_duct_runtime_config_port_t;

typedef struct globus_duct_runtime_data_port_s {
  globus_nexus_endpointattr_t epattr;
  globus_nexus_endpoint_t     ep;
  globus_nexus_startpoint_t   sp;
} globus_duct_runtime_data_port_t;

typedef struct globus_duct_runtime_s {
  globus_mutex_t                mutex;
  globus_cond_t                 cond;

  globus_nexus_startpoint_t     control;
  int                           control_initialized;

  int                           local_address;
  globus_list_t              *  remote_addresses;
  globus_hashtable_t            remote_data_spst;

  int                           data_protocol_version;

  int                           aborted;
  int                           abort_reason;
  int                           proto_negotiate;

  globus_duct_data_callback_t         data_callback;
  void                       * data_callback_userdata;
  globus_duct_config_callback_t       config_callback;
  void                       * config_callback_userdata;

  globus_duct_runtime_data_port_t     data_port;
  globus_duct_runtime_config_port_t   config_port;
} globus_duct_runtime_t;


/******************************************************************************
			      Function prototypes
******************************************************************************/

extern int 
globus_duct_runtime_activate (void);

extern int
globus_duct_runtime_deactivate (void);

#define GLOBUS_DUCT_RUNTIME_MODULE (&globus_duct_runtime_module)

extern globus_module_descriptor_t globus_duct_runtime_module;

extern int 
globus_duct_runtime_init (globus_duct_runtime_t         *runtimep,
			const char                  *checkin_contact,
			int                          checkin_id,
			globus_duct_data_callback_t    data_callback,
			void                        *data_callback_userdata,
			globus_duct_config_callback_t  config_callback,
			void                        *config_callback_userdata);

extern int 
globus_duct_runtime_send (globus_duct_runtime_t * runtimep,
			int                   dst_addr,
			int                   msg_size,
			globus_byte_t    * msg);

extern int 
globus_duct_runtime_structure (globus_duct_runtime_t * runtimep,
			     int            * local_address,
			     int            * remote_count,
			     int           ** remote_addresses);

extern void 
globus_duct_runtime_destroy (globus_duct_runtime_t * runtimep);

extern int 
globus_duct_runtime_make_startpoint (globus_nexus_startpoint_t * spp,
				   const char         * contact);

extern void
globus_duct_runtime_abort (globus_duct_runtime_t * runtimep,
			   int abort_reason);

EXTERN_C_END

#endif /* GLOBUS_DUCT_RUNTIME_H */

