
#ifndef UTIL_UTILS_H
#define UTIL_UTILS_H

/********************************************************************
 *
 * This file defines GRUB thread-safe utility routines
 *
 ********************************************************************/

#ifndef EXTERN_C_BEGIN
#ifdef __cplusplus
#define EXTERN_C_BEGIN extern "C" {
#define EXTERN_C_END }
#else
#define EXTERN_C_BEGIN
#define EXTERN_C_END
#endif
#endif
 

#include <stdarg.h>
#include <stdio.h>


EXTERN_C_BEGIN


int utils_sprintf(char *s, const char *format, /* args */ ... );
int utils_fprintf(FILE *fp, const char *format, /* args */ ... );

int utils_strlen (const char *str);

char *utils_strdup (const char *src);

int utils_streq (const char *s1, const char *s2);

void utils_debug(int pred, const char*format, ...);

EXTERN_C_END

#endif /* UTIL_UTILS_H */

