
/********************************************************************
 *
 * This file implements thread-safe utility routines
 *
 ********************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <assert.h>

#include "globus_common.h"

#include "nexus.h"

#include "utils.h"

int utils_sprintf(char *s, const char *format,  ...)
{
  va_list pa;

  int res;

  nexus_stdio_lock ();

  va_start(pa, format);
  res = vsprintf (s, format, pa);
  va_end(pa);

  nexus_stdio_unlock ();

  return res;
}

int utils_fprintf(FILE *fp, const char *format,  ...)
{
  va_list pa;

  int res;

  nexus_stdio_lock ();

  va_start(pa, format);
  res = vfprintf (fp, format, pa);
  va_end(pa);

  nexus_stdio_unlock ();

  return res;
}

int utils_strlen (const char *str)
{
  int len = 0;

  while (str[len] != '\0') len++;

  return len;
}

char *utils_strdup (const char *src)
{
  int i, len;
  char *dst;

  if (src==NULL) return NULL;

  for (len=0; src[len]!='\0'; len++) /* count */;

  dst = globus_malloc (sizeof(char)*(len + 1));
  assert (dst!=NULL);

  for (i=0; i<len; i++) {
    dst[i] = src[i];
  }
  dst[len] = '\0';

  return dst;
}


int utils_streq (const char *s1, const char *s2)
{
  int i=0;

  while ( (s1[i] != '\0')
	  || (s2[i] != '\0') ) {
    if ( s1[i] != s2[i] ) return 0;
    i++;
  }

  return 1;
}

void utils_debug (int pred_flag, const char*format, ...)
{
  va_list pa;

  if ( pred_flag ) {
    va_start(pa, format);
    nexus_stdio_lock ();
    vfprintf (stderr,
	      format, pa);
    nexus_stdio_unlock ();
    va_end(pa);
  }
}

