
/********************************************************************
 *
 * This file implements the Nexus shorthand buffer routines
 *
 ********************************************************************/

#include <assert.h>
#include <unistd.h>

#include "nxbuff.h"
#include "utils.h"
#include "globus_common.h"
#include "nexus.h"


/********************************************************************
 *
 * stringval
 *
 ********************************************************************/

int nxbuff_put_stringval (nexus_buffer_t *buff, const char *string)
{
  int err;
  int size_needed;
  int len;

  len = utils_strlen (string);
  err = nxbuff_put_int (buff, len);
  if (err) return -1;

  size_needed = nexus_sizeof_char (len);
  err = nexus_check_buffer_size (buff, size_needed, 8, 0, 0);
  if (err) return -1;

  nexus_put_char (buff, (char *)string, len);

  return 0;
}

int nxbuff_get_stringval (nexus_buffer_t *buff, char **stringp)
{
  int err;
  int len;

  assert (stringp!=NULL);

  err = nxbuff_get_int (buff, &len);
  if (err) return -1;

  (*stringp) = globus_malloc (sizeof(char)*(len + 1));
  if ((*stringp)==NULL) return -1;

  if ( 1 /* nexus_check_get_char (buff)>=len */) {
    if ( len > 0 ) {
      nexus_get_char (buff, (*stringp), len);
      (*stringp)[len] = '\0';
    }
    else {
      (*stringp)[0] = '\0';
    }
    return 0;
  }
  else {
    return -1;
  }
}

void nxbuff_free_stringval (char *string)
{
  globus_free (string);
}

/********************************************************************
 *
 * byte
 *
 ********************************************************************/

int nxbuff_put_byte (nexus_buffer_t *buff, globus_byte_t b)
{
  int size_needed;
  short s;
  int err;

  size_needed = nexus_sizeof_short (1);
  err = nexus_check_buffer_size (buff, size_needed, 8, 0, 0);
  if (err) return -1;

  s = b;

  nexus_put_short (buff, &s, 1);

  return 0;
}

int nxbuff_get_byte (nexus_buffer_t *buff, globus_byte_t *b)
{
  short s;

  assert (b!=NULL);

  if ( 1 /* nexus_check_get_short (buff) >= 1 */) {
    nexus_get_short (buff, &s, 1);
    *b = s;
    return 0;
  }
  else {
    return -1;
  }
}

/********************************************************************
 *
 * int
 *
 ********************************************************************/

int nxbuff_put_int (nexus_buffer_t *buff, int i)
{
  int size_needed;
  int err;

  size_needed = nexus_sizeof_int (1);
  err = nexus_check_buffer_size (buff, size_needed, 8, 0, 0);
  if (err) return -1;

  nexus_put_int (buff, &i, 1);

  return 0;
}

int nxbuff_get_int (nexus_buffer_t *buff, int *i)
{
  assert (i!=NULL);

  if ( 1 /* nexus_check_get_int (buff) >= 1 */) {
    nexus_get_int (buff, i, 1);
    return 0;
  }
  else {
    return -1;
  }
}

/********************************************************************
 *
 * float
 *
 ********************************************************************/

int nxbuff_put_float (nexus_buffer_t *buff, float f)
{
  int size_needed;
  int err;

  size_needed = nexus_sizeof_float (1);
  err = nexus_check_buffer_size (buff, size_needed, 8, 0, 0);
  if (err) return -1;

  nexus_put_float (buff, &f, 1);

  return 0;
}

int nxbuff_get_float (nexus_buffer_t *buff, float *f)
{
  assert (f!=NULL);

  if ( 1 /* nexus_check_get_float (buff) >= 1 */) {
    nexus_get_float (buff, f, 1);
    return 0;
  }
  else {
    return -1;
  }
}


/********************************************************************
 *
 * startpoint
 *
 ********************************************************************/

int nxbuff_put_startpoint_transfer (nexus_buffer_t *buff, 
				    nexus_startpoint_t *sp)
{
  int size_needed;
  int err;

  size_needed = nexus_sizeof_startpoint (sp, 1);
  err = nexus_check_buffer_size (buff, size_needed, 8, 0, 0);
  if (err) return -1;

  nexus_put_startpoint_transfer (buff, sp, 1);

  return 0;
}

int nxbuff_get_startpoint (nexus_buffer_t *buff, 
			   nexus_startpoint_t *sp)
{
  assert (sp!=NULL);

  if ( 1 /* nexus_check_get_startpoint (buff) >= 1 */) {
    nexus_get_startpoint (buff, sp, 1);
    return 0;
  }
  else {
    return -1;
  }
}

